/*
 * Decompiled with CFR 0.152.
 */
package ky.someone.mods.gag.block;

import dev.architectury.event.EventResult;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ky.someone.mods.gag.GAG;
import ky.someone.mods.gag.GAGUtil;
import ky.someone.mods.gag.block.BlockRegistry;
import ky.someone.mods.gag.config.GAGConfig;
import ky.someone.mods.gag.world.GAGPointOfInterestStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class NoSolicitorsSign
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty SILENT = BooleanProperty.m_61465_((String)"silent");
    private static final Map<Direction, VoxelShape> AABBS = new EnumMap<Direction, VoxelShape>(Map.of(Direction.NORTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)5.0, (double)12.0, (double)9.0, (double)9.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)4.0, (double)13.0, (double)12.0, (double)14.0, (double)15.0), Block.m_49796_((double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)15.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)15.0, (double)1.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0)}), Direction.SOUTH, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)5.0, (double)2.0, (double)9.0, (double)9.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)4.0, (double)1.0, (double)12.0, (double)14.0, (double)3.0), Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0), Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)2.0), Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0), Block.m_49796_((double)15.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0)}), Direction.EAST, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)5.0, (double)7.0, (double)4.0, (double)9.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)4.0, (double)4.0, (double)3.0, (double)14.0, (double)12.0), Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0), Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0)}), Direction.WEST, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)12.0, (double)5.0, (double)7.0, (double)14.0, (double)9.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)13.0, (double)4.0, (double)4.0, (double)15.0, (double)14.0, (double)12.0), Block.m_49796_((double)15.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0), Block.m_49796_((double)14.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)14.0, (double)1.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.m_49796_((double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0)})));

    public NoSolicitorsSign() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60910_().m_60978_(4.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SILENT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SILENT, FACING, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return AABBS.get(state.m_61143_((Property)FACING));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        GAGUtil.appendInfoTooltip(tooltip, List.of(Component.m_237115_((String)"block.gag.no_solicitors.info.1").m_130938_(GAGUtil.TOOLTIP_MAIN), Component.m_237115_((String)"block.gag.no_solicitors.info.2").m_130938_(GAGUtil.TOOLTIP_EXTRA)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_280296_();
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = this.m_49966_();
        FluidState fluid = ctx.m_43725_().m_6425_(ctx.m_8083_());
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        for (Direction direction : ctx.m_6232_()) {
            if (!direction.m_122434_().m_122479_() || !(state = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)level, pos)) continue;
            return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        if (direction.m_122424_() == state.m_61143_((Property)FACING) && !state.m_60710_((LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, newState, level, pos, newPos);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.m_21120_(hand).m_204117_(ItemTags.f_13167_)) {
            state = (BlockState)state.m_61122_((Property)SILENT);
            level.m_46597_(pos, state);
            level.m_5594_(null, pos, SoundEvents.f_144203_, SoundSource.BLOCKS, 0.2f, 0.7f);
            player.m_5661_((Component)Component.m_237110_((String)"block.gag.no_solicitors.silent", (Object[])new Object[]{GAGUtil.styledBool((Boolean)state.m_61143_((Property)SILENT))}), true);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean bl) {
        if (!state.m_60713_(newState.m_60734_()) && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GAGPointOfInterestStorage.get(serverLevel).removeIfPresent(pos);
        }
        super.m_6810_(state, level, pos, newState, bl);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GAGPointOfInterestStorage.get(serverLevel).add(pos, this);
        }
        super.m_6402_(level, pos, state, entity, stack);
    }

    public static EventResult notBuyingYourStuff(Entity entity, Level level) {
        ServerLevel serverLevel;
        if (entity.m_6095_() == EntityType.f_20494_ && level instanceof ServerLevel && NoSolicitorsSign.blockWandererSpawn(serverLevel = (ServerLevel)level, entity.m_20183_())) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public static boolean blockWandererSpawn(ServerLevel serverLevel, BlockPos pos) {
        Optional<BlockPos> ward = GAGPointOfInterestStorage.get(serverLevel).checkNearbyPOIs((Block)BlockRegistry.NO_SOLICITORS_SIGN.get(), pos, (Integer)GAGConfig.Miscellaneous.NO_SOLICITORS_RADIUS.get());
        GAG.LOGGER.debug("Wanderer spawn check at {} returned {}", (Object)pos, (Object)ward.isPresent());
        if (ward.isPresent()) {
            BlockPos wardPos = ward.get();
            if (!serverLevel.m_46749_(wardPos)) {
                return false;
            }
            BlockState state = serverLevel.m_8055_(wardPos);
            if (state.m_60734_() != BlockRegistry.NO_SOLICITORS_SIGN.get()) {
                GAG.LOGGER.warn("No Solicitors Sign at {} does not exist, has it been removed?", (Object)wardPos);
                GAGPointOfInterestStorage.get(serverLevel).removeIfPresent(wardPos);
                return false;
            }
            Boolean silent = (Boolean)state.m_61143_((Property)SILENT);
            if (!((Boolean)state.m_61143_((Property)SILENT)).booleanValue()) {
                serverLevel.m_5594_(null, pos, SoundEvents.f_12583_, SoundSource.BLOCKS, 0.2f, 0.7f);
                double d = serverLevel.f_46441_.m_188583_() * 0.25;
                double e = serverLevel.f_46441_.m_188583_() * 0.5;
                double f = serverLevel.f_46441_.m_188583_() * 0.25;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, (double)pos.m_123341_() + d, (double)pos.m_123342_() + e, (double)pos.m_123343_() + f, 5, d, e, f, 0.01);
            }
            return true;
        }
        return false;
    }
}

