/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchCostTypes;
import com.minecolonies.api.research.costs.IResearchCost;
import com.minecolonies.api.research.effects.IResearchEffect;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.research.AlternateBuildingResearchRequirement;
import com.minecolonies.core.research.BuildingResearchRequirement;
import com.minecolonies.core.research.GlobalResearchEffect;
import com.minecolonies.core.research.LocalResearch;
import com.minecolonies.core.research.ResearchEffectCategory;
import com.minecolonies.core.research.ResearchResearchRequirement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GlobalResearch
implements IGlobalResearch {
    public static final String RESEARCH_NAME_PROP = "name";
    public static final String RESEARCH_SUBTITLE_PROP = "subtitle";
    public static final String RESEARCH_BRANCH_PROP = "branch";
    private static final String RESEARCH_ICON_PROP = "icon";
    public static final String RESEARCH_UNIVERSITY_LEVEL_PROP = "researchLevel";
    private static final String RESEARCH_SORT_PROP = "sortOrder";
    private static final String RESEARCH_EXCLUSIVE_CHILD_PROP = "exclusiveChildResearch";
    private static final String RESEARCH_PARENT_PROP = "parentResearch";
    private static final String RESEARCH_NO_RESET_PROP = "no-reset";
    private static final String RESEARCH_REQUIREMENTS_PROP = "requirements";
    public static final String RESEARCH_ITEM_NAME_PROP = "item";
    public static final String RESEARCH_ITEM_LIST_PROP = "items";
    public static final String RESEARCH_ITEM_TAG_PROP = "tag";
    public static final String RESEARCH_QUANTITY_PROP = "quantity";
    private static final String RESEARCH_REQUIRED_BUILDING_PROP = "building";
    private static final String RESEARCH_MANDATORY_BUILDING_PROP = "mandatory-building";
    private static final String RESEARCH_ALTERNATE_BUILDING_PROP = "alternate-building";
    private static final String RESEARCH_REQUIRED_RESEARCH_PROP = "research";
    private static final String RESEARCH_LEVEL_PROP = "level";
    private static final String RESEARCH_HIDDEN_PROP = "hidden";
    private static final String RESEARCH_AUTOSTART_PROP = "autostart";
    private static final String RESEARCH_INSTANT_PROP = "instant";
    private static final String RESEARCH_EFFECTS_PROP = "effects";
    private final List<IResearchCost> costList = new ArrayList<IResearchCost>();
    private ResourceLocation parent;
    private final ResourceLocation id;
    private final ResourceLocation branch;
    private final ResourceLocation textureIcon;
    private final ItemStack itemIcon;
    private final TranslatableContents name;
    private final TranslatableContents subtitle;
    private final List<IResearchEffect<?>> effects = new ArrayList();
    private final int depth;
    private final int sortOrder;
    private boolean onlyChild;
    private final boolean hidden;
    private final boolean autostart;
    private final boolean instant;
    private final boolean immutable;
    private final List<ResourceLocation> children = new ArrayList<ResourceLocation>();
    private final List<IResearchRequirement> requirements = new ArrayList<IResearchRequirement>();

    public GlobalResearch(String id, String branch, String name, int universityLevel, IResearchEffect<?> effect) {
        this.id = new ResourceLocation(id);
        this.effects.add(effect);
        this.name = new TranslatableContents(name, null, TranslatableContents.f_237494_);
        this.subtitle = new TranslatableContents("", null, TranslatableContents.f_237494_);
        this.depth = universityLevel;
        this.sortOrder = 1;
        this.branch = new ResourceLocation(branch);
        this.hidden = false;
        this.instant = false;
        this.autostart = false;
        this.immutable = false;
        this.itemIcon = ItemStack.f_41583_;
        this.textureIcon = new ResourceLocation("");
        if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchDebugLog.get()).booleanValue()) {
            Log.getLogger().info("Statically assigned recipe [" + branch + "/" + id + "]");
        }
    }

    public GlobalResearch(ResourceLocation id, ResourceLocation branch, int universityLevel, List<IResearchEffect<?>> effects, ResourceLocation iconTexture, ItemStack iconItemStack, boolean immutable) {
        this.id = id;
        String autogenKey = "com." + this.id.m_135827_() + ".research." + this.id.m_135815_().replaceAll("[ /]", ".");
        this.name = new TranslatableContents(autogenKey + ".name", null, TranslatableContents.f_237494_);
        this.parent = new ResourceLocation("");
        this.subtitle = new TranslatableContents("", null, TranslatableContents.f_237494_);
        this.effects.addAll(effects);
        this.depth = universityLevel;
        this.sortOrder = 1;
        this.branch = branch;
        this.hidden = false;
        this.autostart = false;
        this.instant = false;
        this.immutable = immutable;
        this.textureIcon = FMLEnvironment.dist.isClient() ? this.validateIconTextures(iconTexture) : iconTexture;
        this.itemIcon = iconItemStack;
    }

    public GlobalResearch(ResourceLocation id, ResourceLocation branch, ResourceLocation parent, TranslatableContents desc, int universityLevel, int sortOrder, ResourceLocation iconTexture, ItemStack iconStack, TranslatableContents subtitle, boolean onlyChild, boolean hidden, boolean autostart, boolean instant, boolean immutable) {
        this.id = id;
        this.name = desc;
        this.subtitle = subtitle;
        this.branch = branch;
        this.parent = parent;
        this.depth = universityLevel;
        this.sortOrder = sortOrder;
        this.onlyChild = onlyChild;
        this.hidden = hidden;
        this.autostart = autostart;
        this.instant = instant;
        this.immutable = immutable;
        this.itemIcon = iconStack;
        this.textureIcon = iconTexture;
        if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchDebugLog.get()).booleanValue()) {
            Log.getLogger().info("Client received research [" + branch + "/" + id + "]");
        }
    }

    @Override
    public boolean canResearch(int uni_level, @NotNull ILocalResearchTree localTree) {
        IGlobalResearch parentResearch = this.parent.m_135815_().isEmpty() ? null : IGlobalResearchTree.getInstance().getResearch(this.branch, this.parent);
        ILocalResearch localParentResearch = this.parent.m_135815_().isEmpty() ? null : localTree.getResearch(this.branch, parentResearch.getId());
        ILocalResearch localResearch = localTree.getResearch(this.getBranch(), this.getId());
        return !(localResearch != null || !this.canDisplay(uni_level) || parentResearch != null && (localParentResearch == null || localParentResearch.getState() != ResearchState.FINISHED) || parentResearch != null && parentResearch.hasResearchedChild(localTree) && parentResearch.hasOnlyChild() || this.depth >= 6 && localTree.branchFinishedHighestLevel(this.branch));
    }

    @Override
    public boolean canDisplay(int uni_level) {
        return uni_level >= this.depth;
    }

    @Override
    public boolean hasEnoughResources(IItemHandler inventory) {
        if (this.costList.isEmpty()) {
            return true;
        }
        for (IResearchCost ingredient : this.costList) {
            int totalCount = 0;
            for (Item cost : ingredient.getItems()) {
                int count = InventoryUtils.getItemCountInItemHandler(inventory, stack -> stack.m_41720_().equals(cost));
                totalCount += count;
            }
            if (totalCount >= ingredient.getCount()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<IResearchCost> getCostList() {
        return ImmutableList.copyOf(this.costList);
    }

    @Override
    public void startResearch(@NotNull ILocalResearchTree localResearchTree) {
        if (localResearchTree.getResearch(this.branch, this.id) == null) {
            LocalResearch research = new LocalResearch(this.id, this.branch, this.depth);
            if (this.instant) {
                research.setProgress(IGlobalResearchTree.getInstance().getBranchData(this.branch).getBaseTime(research.getDepth()));
            }
            research.setState(ResearchState.IN_PROGRESS);
            localResearchTree.addResearch(this.branch, research);
        }
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public TranslatableContents getName() {
        return this.name;
    }

    @Override
    public TranslatableContents getSubtitle() {
        return this.subtitle;
    }

    @Override
    @NotNull
    public ResourceLocation getParent() {
        return this.parent;
    }

    @Override
    public ResourceLocation getBranch() {
        return this.branch;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public boolean isInstant() {
        return this.instant;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isAutostart() {
        return this.autostart;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public boolean hasOnlyChild() {
        return this.onlyChild;
    }

    @Override
    public void setOnlyChild(boolean onlyChild) {
        this.onlyChild = onlyChild;
    }

    @Override
    public boolean hasResearchedChild(@NotNull ILocalResearchTree localTree) {
        for (ResourceLocation child : this.children) {
            IGlobalResearch childResearch = IGlobalResearchTree.getInstance().getResearch(this.branch, child);
            ILocalResearch localResearch = localTree.getResearch(childResearch.getBranch(), childResearch.getId());
            if (localResearch == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addChild(IGlobalResearch child) {
        this.children.add(child.getId());
        child.setParent(this.getId());
    }

    @Override
    public void addChild(ResourceLocation child) {
        this.children.add(child);
    }

    @Override
    public void addCost(IResearchCost cost) {
        this.costList.add(cost);
    }

    @Override
    public void addEffect(IResearchEffect<?> effect) {
        this.effects.add(effect);
    }

    @Override
    public void addRequirement(IResearchRequirement requirement) {
        this.requirements.add(requirement);
    }

    @Override
    public List<IResearchRequirement> getResearchRequirement() {
        return this.requirements;
    }

    @Override
    public void setParent(ResourceLocation id) {
        this.parent = id;
    }

    @Override
    public List<ResourceLocation> getChildren() {
        return this.children;
    }

    @Override
    public List<IResearchEffect<?>> getEffects() {
        return this.effects;
    }

    @Override
    public ResourceLocation getIconTextureResourceLocation() {
        return this.textureIcon;
    }

    @Override
    public ItemStack getIconItemStack() {
        return this.itemIcon;
    }

    public GlobalResearch(@NotNull JsonObject researchJson, ResourceLocation resourceLocation, Map<ResourceLocation, ResearchEffectCategory> effectCategories, boolean checkIcons) {
        this.id = resourceLocation;
        String autogenKey = "com." + this.id.m_135827_() + ".research." + this.id.m_135815_().replaceAll("[ /]", ".");
        this.name = new TranslatableContents(this.getStringSafe(researchJson, RESEARCH_NAME_PROP, autogenKey + ".name"), null, TranslatableContents.f_237494_);
        this.subtitle = new TranslatableContents(this.getStringSafe(researchJson, RESEARCH_SUBTITLE_PROP, ""), null, TranslatableContents.f_237494_);
        this.branch = new ResourceLocation(this.getBranch(researchJson, resourceLocation));
        this.depth = this.getUniversityLevel(researchJson);
        this.sortOrder = this.getSortOrder(researchJson);
        this.parent = new ResourceLocation(this.getStringSafe(researchJson, RESEARCH_PARENT_PROP, ""));
        this.onlyChild = this.getBooleanSafe(researchJson, RESEARCH_EXCLUSIVE_CHILD_PROP);
        this.instant = this.getBooleanSafe(researchJson, RESEARCH_INSTANT_PROP);
        this.autostart = this.getBooleanSafe(researchJson, RESEARCH_AUTOSTART_PROP);
        this.hidden = this.getBooleanSafe(researchJson, RESEARCH_HIDDEN_PROP);
        this.immutable = this.getBooleanSafe(researchJson, RESEARCH_NO_RESET_PROP);
        String iconString = this.getStringSafe(researchJson, RESEARCH_ICON_PROP, "");
        if (iconString.contains(".")) {
            ResourceLocation unsafeIconTexture = new ResourceLocation(iconString);
            this.textureIcon = checkIcons && FMLEnvironment.dist.isClient() ? this.validateIconTextures(unsafeIconTexture) : unsafeIconTexture;
            this.itemIcon = ItemStack.f_41583_;
        } else {
            this.textureIcon = new ResourceLocation("");
            this.itemIcon = this.parseIconItemStacks(iconString);
        }
        this.parseRequirements(researchJson);
        this.parseEffects(researchJson, effectCategories);
    }

    private String getBranch(JsonObject researchJson, ResourceLocation resourceLocation) {
        if (researchJson.has(RESEARCH_BRANCH_PROP) && researchJson.get(RESEARCH_BRANCH_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_BRANCH_PROP).getAsJsonPrimitive().isString()) {
            return researchJson.get(RESEARCH_BRANCH_PROP).getAsString();
        }
        Log.getLogger().error("Error in Research Branch for" + resourceLocation);
        return "parse errors";
    }

    private int getUniversityLevel(JsonObject researchJson) {
        if (researchJson.has(RESEARCH_UNIVERSITY_LEVEL_PROP) && researchJson.get(RESEARCH_UNIVERSITY_LEVEL_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_UNIVERSITY_LEVEL_PROP).getAsJsonPrimitive().isNumber()) {
            return researchJson.get(RESEARCH_UNIVERSITY_LEVEL_PROP).getAsNumber().intValue();
        }
        Log.getLogger().info("No declared university level for " + this.branch + "/" + this.id);
        return 1;
    }

    private int getSortOrder(JsonObject researchJson) {
        if (researchJson.has(RESEARCH_SORT_PROP) && researchJson.get(RESEARCH_SORT_PROP).isJsonPrimitive() && researchJson.get(RESEARCH_SORT_PROP).getAsJsonPrimitive().isNumber()) {
            return researchJson.get(RESEARCH_SORT_PROP).getAsNumber().intValue();
        }
        return 0;
    }

    private ResourceLocation validateIconTextures(ResourceLocation icon) {
        try {
            Minecraft.m_91087_().m_91098_().m_215593_(icon);
            return icon;
        }
        catch (IOException notFoundError) {
            Log.getLogger().info("Resource file for Minecraft:" + icon.toString() + " not found for " + this.branch + "/" + this.id + " : " + notFoundError.getLocalizedMessage());
            return new ResourceLocation("");
        }
    }

    private ItemStack parseIconItemStacks(String icon) {
        int count;
        String[] iconParts = icon.split(":");
        String[] outputString = new String[2];
        if (iconParts.length > 3) {
            Log.getLogger().info("Malformed icon property for " + this.branch + "/" + this.id + ".  Icons may contain at most namespace:identifier:count.");
            return ItemStack.f_41583_;
        }
        if (iconParts.length == 3) {
            try {
                count = Integer.parseInt(iconParts[2]);
            }
            catch (NumberFormatException parseError) {
                Log.getLogger().info("Non-integer count assigned to icon of " + this.branch + "/" + this.id + " : " + parseError.getLocalizedMessage());
                count = 1;
            }
        } else {
            count = 1;
        }
        if (iconParts.length == 1) {
            outputString[0] = "minecraft";
            outputString[1] = iconParts[0];
        } else {
            outputString[0] = iconParts[0];
            outputString[1] = iconParts[1];
        }
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(outputString[0], outputString[1]));
        if (item.equals(Items.f_41852_)) {
            return ItemStack.f_41583_;
        }
        ItemStack is = new ItemStack((ItemLike)item);
        is.m_41764_(Math.min(count, is.m_41741_()));
        return is;
    }

    private String getStringSafe(JsonObject researchJson, String propertyName, String defaultRet) {
        if (researchJson.has(propertyName)) {
            if (researchJson.get(propertyName).isJsonPrimitive() && researchJson.get(propertyName).getAsJsonPrimitive().isString()) {
                return researchJson.get(propertyName).getAsString();
            }
            return "";
        }
        return defaultRet;
    }

    private boolean getBooleanSafe(JsonObject researchJson, String property) {
        if (researchJson.has(property) && researchJson.get(property).isJsonPrimitive() && researchJson.get(property).getAsJsonPrimitive().isBoolean()) {
            return researchJson.get(property).getAsBoolean();
        }
        return false;
    }

    private void parseRequirements(JsonObject researchJson) {
        if (researchJson.has(RESEARCH_REQUIREMENTS_PROP) && researchJson.get(RESEARCH_REQUIREMENTS_PROP).isJsonArray()) {
            for (JsonElement reqArrayElement : researchJson.get(RESEARCH_REQUIREMENTS_PROP).getAsJsonArray()) {
                if (!reqArrayElement.isJsonObject()) continue;
                JsonObject rootObject = reqArrayElement.getAsJsonObject();
                if (IMinecoloniesAPI.getInstance().getResearchCostRegistry().getEntries().stream().anyMatch(entry -> ((ModResearchCostTypes.ResearchCostType)entry.getValue()).hasCorrectJsonFields(rootObject))) {
                    Optional<IResearchCost> cost = IMinecoloniesAPI.getInstance().getResearchCostRegistry().getEntries().stream().filter(entry -> ((ModResearchCostTypes.ResearchCostType)entry.getValue()).hasCorrectJsonFields(rootObject)).map(entry -> ((ModResearchCostTypes.ResearchCostType)entry.getValue()).parseFromJson(rootObject)).findFirst();
                    cost.ifPresent(this.costList::add);
                    continue;
                }
                if (rootObject.has(RESEARCH_REQUIRED_BUILDING_PROP) && rootObject.get(RESEARCH_REQUIRED_BUILDING_PROP).isJsonPrimitive() && rootObject.get(RESEARCH_REQUIRED_BUILDING_PROP).getAsJsonPrimitive().isString()) {
                    int level = 1;
                    if (rootObject.has(RESEARCH_LEVEL_PROP) && rootObject.get(RESEARCH_LEVEL_PROP).isJsonPrimitive() && rootObject.get(RESEARCH_LEVEL_PROP).getAsJsonPrimitive().isNumber()) {
                        level = rootObject.get(RESEARCH_LEVEL_PROP).getAsNumber().intValue();
                    }
                    this.requirements.add(new BuildingResearchRequirement(level, rootObject.get(RESEARCH_REQUIRED_BUILDING_PROP).getAsString(), false));
                    continue;
                }
                if (rootObject.has(RESEARCH_REQUIRED_RESEARCH_PROP) && rootObject.get(RESEARCH_REQUIRED_RESEARCH_PROP).isJsonPrimitive() && rootObject.get(RESEARCH_REQUIRED_RESEARCH_PROP).getAsJsonPrimitive().isString()) {
                    if (rootObject.has(RESEARCH_NAME_PROP) && rootObject.get(RESEARCH_NAME_PROP).isJsonPrimitive() && rootObject.get(RESEARCH_NAME_PROP).getAsJsonPrimitive().isString()) {
                        this.requirements.add(new ResearchResearchRequirement(new ResourceLocation(rootObject.get(RESEARCH_REQUIRED_RESEARCH_PROP).getAsString()), Component.m_237115_((String)rootObject.get(RESEARCH_NAME_PROP).getAsString())));
                        continue;
                    }
                    this.requirements.add(new ResearchResearchRequirement(new ResourceLocation(rootObject.get(RESEARCH_REQUIRED_RESEARCH_PROP).getAsString())));
                    continue;
                }
                if (rootObject.has(RESEARCH_ALTERNATE_BUILDING_PROP) && rootObject.get(RESEARCH_ALTERNATE_BUILDING_PROP).isJsonPrimitive() && rootObject.get(RESEARCH_ALTERNATE_BUILDING_PROP).getAsJsonPrimitive().isString()) {
                    this.parseAndAssignAlternateBuildingRequirement(rootObject);
                    continue;
                }
                if (rootObject.has(RESEARCH_MANDATORY_BUILDING_PROP) && rootObject.get(RESEARCH_MANDATORY_BUILDING_PROP).isJsonPrimitive() && rootObject.get(RESEARCH_MANDATORY_BUILDING_PROP).getAsJsonPrimitive().isString() && rootObject.has(RESEARCH_LEVEL_PROP) && rootObject.get(RESEARCH_LEVEL_PROP).isJsonPrimitive() && rootObject.get(RESEARCH_LEVEL_PROP).getAsJsonPrimitive().isNumber()) {
                    this.requirements.add(new BuildingResearchRequirement(rootObject.get(RESEARCH_LEVEL_PROP).getAsNumber().intValue(), rootObject.get(RESEARCH_MANDATORY_BUILDING_PROP).getAsString(), true));
                    continue;
                }
                Log.getLogger().warn("Invalid Research Requirement formatting for {}/{}", (Object)this.branch, (Object)this.id);
            }
        }
    }

    private void parseAndAssignAlternateBuildingRequirement(JsonObject requirementJson) {
        int level = requirementJson.has(RESEARCH_LEVEL_PROP) && requirementJson.get(RESEARCH_LEVEL_PROP).isJsonPrimitive() && requirementJson.get(RESEARCH_LEVEL_PROP).getAsJsonPrimitive().isNumber() ? requirementJson.get(RESEARCH_LEVEL_PROP).getAsNumber().intValue() : 1;
        for (IResearchRequirement requirement : this.requirements) {
            if (!(requirement instanceof AlternateBuildingResearchRequirement)) continue;
            ((AlternateBuildingResearchRequirement)requirement).add(requirementJson.get(RESEARCH_ALTERNATE_BUILDING_PROP).getAsString(), level);
            return;
        }
        this.requirements.add(new AlternateBuildingResearchRequirement().add(requirementJson.getAsJsonObject().get(RESEARCH_ALTERNATE_BUILDING_PROP).getAsString(), level));
    }

    private void parseEffects(JsonObject researchJson, Map<ResourceLocation, ResearchEffectCategory> effectCategories) {
        if (researchJson.has(RESEARCH_EFFECTS_PROP) && researchJson.get(RESEARCH_EFFECTS_PROP).isJsonArray()) {
            for (JsonElement itemArrayElement : researchJson.get(RESEARCH_EFFECTS_PROP).getAsJsonArray()) {
                if (!itemArrayElement.isJsonObject()) continue;
                for (Map.Entry entry : itemArrayElement.getAsJsonObject().entrySet()) {
                    ResourceLocation effect = new ResourceLocation((String)entry.getKey());
                    if (effectCategories.containsKey(effect)) {
                        int strength;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber() && effectCategories.containsKey(effect)) {
                            int max;
                            int requested = ((JsonElement)entry.getValue()).getAsNumber().intValue();
                            if (requested <= (max = effectCategories.get(effect).getMaxLevel())) {
                                strength = ((JsonElement)entry.getValue()).getAsNumber().intValue();
                            } else {
                                strength = effectCategories.get(effect).getMaxLevel();
                                Log.getLogger().warn("Research " + this.id + " requested higher effect strength than exists.");
                            }
                        } else {
                            Log.getLogger().warn("Research " + this.id + " did not have a valid effect strength.");
                            strength = 6;
                        }
                        this.effects.add(new GlobalResearchEffect(effect, effectCategories.get(effect).get(strength), effectCategories.get(effect).getDisplay(strength), effectCategories.get(effect).getName(), effectCategories.get(effect).getSubtitle()));
                        continue;
                    }
                    if (((Boolean)MinecoloniesAPIProxy.getInstance().getConfig().getServer().researchDebugLog.get()).booleanValue()) {
                        Log.getLogger().warn(this.branch + "/" + this.id + " looking for non-existent research effects " + entry);
                    }
                    this.effects.add(new GlobalResearchEffect(effect, 6.0, 6.0));
                }
            }
        }
    }

    public static int parseItemCount(JsonObject jsonObject) {
        int count = 1;
        if (jsonObject.has(RESEARCH_QUANTITY_PROP) && jsonObject.get(RESEARCH_QUANTITY_PROP).isJsonPrimitive() && jsonObject.get(RESEARCH_QUANTITY_PROP).getAsJsonPrimitive().isNumber()) {
            count = Math.max(jsonObject.get(RESEARCH_QUANTITY_PROP).getAsInt(), 1);
        }
        return count;
    }
}

