/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers.main;

import com.ldtteam.structurize.blocks.interfaces.ILeveledBlueprintAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.ISurvivalBlueprintHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.PlacementSettings;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.Network;
import com.minecolonies.core.blocks.huts.BlockHutTownHall;
import com.minecolonies.core.entity.ai.workers.util.ConstructionTapeHelper;
import com.minecolonies.core.event.EventHandler;
import com.minecolonies.core.network.messages.client.OpenDecoBuildWindowMessage;
import com.minecolonies.core.network.messages.client.OpenPlantationFieldBuildWindowMessage;
import com.minecolonies.core.util.AdvancementUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SurvivalHandler
implements ISurvivalBlueprintHandler {
    public String getId() {
        return "minecolonies";
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)"com.minecolonies.coremod.blueprint.placement");
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canHandle(Blueprint blueprint, ClientLevel clientLevel, Player player, BlockPos blockPos, PlacementSettings placementSettings) {
        if (((Boolean)IMinecoloniesAPI.getInstance().getConfig().getServer().blueprintBuildMode.get()).booleanValue()) {
            IColonyView colonyView = IColonyManager.getInstance().getClosestColonyView((Level)clientLevel, blockPos);
            return colonyView != null;
        }
        return true;
    }

    public void handle(Blueprint blueprint, String packName, String blueprintPath, boolean clientPack, Level world, Player player, BlockPos blockPos, PlacementSettings placementSettings) {
        boolean isInColony;
        if (blueprint == null) {
            MessageUtils.format("com.minecolonies.coremod.structures.nocustomhuts", new Object[0]).sendTo(player);
            SoundUtils.playErrorSound(player, player.m_20183_());
            return;
        }
        blueprint.rotateWithMirror(placementSettings.rotation, placementSettings.mirror == Mirror.NONE ? Mirror.NONE : Mirror.FRONT_BACK, world);
        BlockState anchor = blueprint.m_8055_(blueprint.getPrimaryBlockOffset());
        IColony tempColony = IColonyManager.getInstance().getClosestColony(world, blockPos);
        boolean bl = isInColony = tempColony != null && tempColony.isCoordInColony(world, blockPos);
        if (isInColony && !tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS)) {
            MessageUtils.format("com.minecolonies.coremod.placement.noperm", new Object[0]).sendTo(player);
            SoundUtils.playErrorSound(player, player.m_20183_());
            return;
        }
        boolean successfulTownHallLocation = false;
        if (anchor.m_60734_() instanceof BlockHutTownHall) {
            if (isInColony || IColonyManager.getInstance().isFarEnoughFromColonies(world, blockPos)) {
                successfulTownHallLocation = true;
            } else {
                MessageUtils.format("com.minecolonies.coremod.placement.townhalltooclose", new Object[0]).sendTo(player);
                SoundUtils.playErrorSound(player, player.m_20183_());
                return;
            }
        }
        if (!(isInColony && this.isBlueprintInColony(blueprint, tempColony, blockPos) || successfulTownHallLocation)) {
            MessageUtils.format("com.minecolonies.coremod.placement.outofcolony", new Object[0]).sendTo(player);
            SoundUtils.playErrorSound(player, player.m_20183_());
            return;
        }
        if (anchor.m_60713_(ModBlocks.blockPlantationField)) {
            Network.getNetwork().sendToPlayer(new OpenPlantationFieldBuildWindowMessage(blockPos, packName, blueprintPath, placementSettings.getRotation(), placementSettings.mirror), (ServerPlayer)player);
        }
        if (anchor.m_60734_() instanceof AbstractBlockHut) {
            if (clientPack || !StructurePacks.hasPack((String)packName) || blueprintPath.startsWith("scans/")) {
                MessageUtils.format("com.minecolonies.coremod.structures.buildingmissing", new Object[0]).sendTo(player);
                SoundUtils.playErrorSound(player, player.m_20183_());
                return;
            }
            ItemStack stack = new ItemStack((ItemLike)anchor.m_60734_());
            if (EventHandler.onBlockHutPlaced(world, player, anchor.m_60734_(), blockPos)) {
                IBuilding building;
                int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.m_150109_()), anchor.m_60734_());
                if (slot == -1 && !player.m_7500_()) {
                    SoundUtils.playErrorSound(player, player.m_20183_());
                    return;
                }
                ItemStack inventoryStack = slot == -1 ? stack : player.m_150109_().m_8020_(slot);
                CompoundTag compound = inventoryStack.m_41783_();
                if (compound != null && compound.m_128441_("colony") && tempColony != null && tempColony.getID() != compound.m_128451_("colony")) {
                    MessageUtils.format("com.minecolonies.coremod.gui.buildtool.wrongcolony", compound.m_128451_("colony")).sendTo(player);
                    SoundUtils.playErrorSound(player, player.m_20183_());
                    return;
                }
                world.m_46961_(blockPos, true);
                world.m_46597_(blockPos, anchor);
                ((AbstractBlockHut)anchor.m_60734_()).onBlockPlacedByBuildTool(world, blockPos, anchor, (LivingEntity)player, null, placementSettings.getMirror() != Mirror.NONE, packName, blueprintPath);
                MinecraftForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.m_46472_(), (LevelAccessor)world, (BlockPos)blockPos), world.m_8055_(blockPos.m_7495_()), (Entity)player));
                InventoryUtils.reduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.m_150109_()), inventoryStack, 1);
                if (tempColony == null) {
                    SoundUtils.playSuccessSound(player, player.m_20183_());
                    return;
                }
                AdvancementUtils.TriggerAdvancementPlayersForColony(tempColony, playerMP -> AdvancementTriggers.PLACE_STRUCTURE.trigger((ServerPlayer)playerMP, ((AbstractBlockHut)anchor.m_60734_()).getBlueprintName()));
                int level = 0;
                boolean finishedUpgrade = false;
                if (compound != null) {
                    if (compound.m_128441_("otherLevel")) {
                        level = compound.m_128451_("otherLevel");
                    }
                    if (compound.m_128441_("isPasteable")) {
                        Object newBlueprintPath = blueprintPath;
                        newBlueprintPath = ((String)newBlueprintPath).substring(0, ((String)newBlueprintPath).length() - 1);
                        newBlueprintPath = (String)newBlueprintPath + level;
                        CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(player.f_19853_, StructurePacks.getBlueprintFuture((String)packName, (String)newBlueprintPath), blockPos, placementSettings.getRotation(), placementSettings.getMirror() != Mirror.NONE ? Mirror.FRONT_BACK : Mirror.NONE, true, (ServerPlayer)player);
                        finishedUpgrade = true;
                    }
                }
                if ((building = IColonyManager.getInstance().getBuilding(world, blockPos)) == null) {
                    if (!(anchor.m_60734_() instanceof BlockHutTownHall)) {
                        SoundUtils.playErrorSound(player, player.m_20183_());
                        Log.getLogger().error("BuildTool: building is null!", (Throwable)new Exception());
                        return;
                    }
                } else {
                    if (building.getTileEntity() != null) {
                        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, blockPos);
                        if (colony == null) {
                            Log.getLogger().info("No colony for " + player.m_7755_().getString());
                        } else {
                            building.getTileEntity().setColony(colony);
                        }
                    }
                    building.setStructurePack(packName);
                    building.setBlueprintPath(blueprintPath);
                    building.setBuildingLevel(level);
                    if (level > 0) {
                        building.setDeconstructed();
                    }
                    if (!(building instanceof IRSComponent)) {
                        ConstructionTapeHelper.placeConstructionTape(building.getCorners(), building.getColony());
                    }
                    building.setIsMirrored(placementSettings.mirror != Mirror.NONE);
                    if (finishedUpgrade) {
                        building.onUpgradeComplete(building.getBuildingLevel());
                    }
                }
            }
            SoundUtils.playSuccessSound(player, player.m_20183_());
        } else if (blueprint.m_8055_(blueprint.getPrimaryBlockOffset()).m_60734_() instanceof ILeveledBlueprintAnchorBlock) {
            int level = Utils.getBlueprintLevel(blueprint.getFileName());
            if (level == -1) {
                Network.getNetwork().sendToPlayer(new OpenDecoBuildWindowMessage(blockPos, packName, blueprintPath, placementSettings.getRotation(), placementSettings.mirror), (ServerPlayer)player);
            } else {
                Network.getNetwork().sendToPlayer(new OpenDecoBuildWindowMessage(blockPos, packName, blueprintPath.replace(level + ".blueprint", "1.blueprint"), placementSettings.getRotation(), placementSettings.mirror), (ServerPlayer)player);
            }
        } else {
            Network.getNetwork().sendToPlayer(new OpenDecoBuildWindowMessage(blockPos, packName, blueprintPath, placementSettings.getRotation(), placementSettings.mirror), (ServerPlayer)player);
        }
        Log.getLogger().warn("Handling Survival Placement in Colony");
    }

    private boolean isBlueprintInColony(Blueprint blueprint, IColony colony, BlockPos blockPos) {
        Level world = colony.getWorld();
        BlockPos zeroPos = blockPos.m_121996_((Vec3i)blueprint.getPrimaryBlockOffset());
        BlockPos pos1 = new BlockPos(zeroPos.m_123341_(), zeroPos.m_123342_(), zeroPos.m_123343_());
        BlockPos pos2 = new BlockPos(zeroPos.m_123341_() + blueprint.getSizeX() - 1, zeroPos.m_123342_() + blueprint.getSizeY() - 1, zeroPos.m_123343_() + blueprint.getSizeZ() - 1);
        int minX = Math.min(pos1.m_123341_(), pos2.m_123341_()) + 1;
        int maxX = Math.max(pos1.m_123341_(), pos2.m_123341_());
        int minZ = Math.min(pos1.m_123343_(), pos2.m_123343_()) + 1;
        int maxZ = Math.max(pos1.m_123343_(), pos2.m_123343_());
        for (int x = minX; x < maxX; x += 16) {
            for (int z = minZ; z < maxZ; z += 16) {
                int chunkX = x >> 4;
                int chunkZ = z >> 4;
                ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                if (ColonyUtils.getOwningColony(world.m_6325_(pos.f_45578_, pos.f_45579_)) == colony.getID()) continue;
                return false;
            }
        }
        return true;
    }
}

