/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.minecolonies.api.entity.citizen.AbstractCivilianEntity;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.api.sounds.SoundManager;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class PlaySoundForCitizenMessage
implements IMessage {
    private int entityid;
    private SoundEvent soundEvent;
    private SoundSource soundSource;
    private BlockPos pos;
    private ResourceKey<Level> dimensionID;
    private float volume;
    private float pitch;
    private int length;
    private int repetitions;

    public PlaySoundForCitizenMessage() {
    }

    public PlaySoundForCitizenMessage(int entityID, SoundEvent event, BlockPos pos, Level world) {
        this(entityID, event, SoundSource.NEUTRAL, pos, world, 0.5f, 1.0f, 1, 1);
    }

    public PlaySoundForCitizenMessage(int entityID, SoundEvent event, SoundSource soundSource, BlockPos pos, Level world) {
        this(entityID, event, soundSource, pos, world, 0.5f, 1.0f, 1, 1);
    }

    public PlaySoundForCitizenMessage(int entityID, SoundEvent event, SoundSource soundSource, BlockPos pos, Level world, int length, int repetitions) {
        this(entityID, event, soundSource, pos, world, 0.5f, 1.0f, length, repetitions);
    }

    public PlaySoundForCitizenMessage(int entityID, SoundEvent event, SoundSource soundSource, BlockPos pos, Level world, float volume, float pitch, int length, int repetitions) {
        this.entityid = entityID;
        this.soundEvent = event;
        this.soundSource = soundSource;
        this.pos = pos;
        this.dimensionID = world.m_46472_();
        this.volume = volume;
        this.pitch = pitch;
        this.length = length;
        this.repetitions = repetitions;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130085_(ForgeRegistries.SOUND_EVENTS.getKey((Object)this.soundEvent));
        buf.writeInt(this.soundSource.ordinal());
        buf.m_130064_(this.pos);
        buf.m_130070_(this.dimensionID.m_135782_().toString());
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
        buf.writeInt(this.length);
        buf.writeInt(this.repetitions);
        buf.writeInt(this.entityid);
    }

    @Override
    public void fromBytes(FriendlyByteBuf buf) {
        this.soundEvent = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buf.m_130281_());
        this.soundSource = SoundSource.values()[buf.readInt()];
        this.pos = buf.m_130135_();
        this.dimensionID = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(buf.m_130136_(Short.MAX_VALUE)));
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
        this.length = buf.readInt();
        this.repetitions = buf.readInt();
        this.entityid = buf.readInt();
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityid);
        if (entity instanceof AbstractCivilianEntity) {
            SoundManager.addToQueue(entity.m_20148_(), this.soundEvent, this.soundSource, this.repetitions, this.length, this.pos, this.volume, this.pitch);
        }
    }
}

