/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.util.DamageSourceKeys;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Map;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.JsonCodecProvider;
import org.jetbrains.annotations.NotNull;

public class DefaultDamageTypeProvider
extends JsonCodecProvider<DamageType> {
    public DefaultDamageTypeProvider(@NotNull PackOutput packOutput, @NotNull ExistingFileHelper existingFileHelper) {
        super(packOutput, existingFileHelper, "minecolonies", (DynamicOps)JsonOps.INSTANCE, PackType.SERVER_DATA, "damage_type", DamageType.f_268510_, DefaultDamageTypeProvider.getDamageTypes());
    }

    private static Map<ResourceLocation, DamageType> getDamageTypes() {
        return Map.ofEntries(Map.entry(DamageSourceKeys.CONSOLE.m_135782_(), DefaultDamageTypeProvider.damage("console")), Map.entry(DamageSourceKeys.DEFAULT.m_135782_(), DefaultDamageTypeProvider.damage("default")), Map.entry(DamageSourceKeys.DESPAWN.m_135782_(), DefaultDamageTypeProvider.damage("despawn")), Map.entry(DamageSourceKeys.NETHER.m_135782_(), DefaultDamageTypeProvider.damage("nether")), Map.entry(DamageSourceKeys.GUARD.m_135782_(), DefaultDamageTypeProvider.damage("entity.minecolonies.guard")), Map.entry(DamageSourceKeys.GUARD_PVP.m_135782_(), DefaultDamageTypeProvider.damage("entity.minecolonies.guardpvp")), Map.entry(DamageSourceKeys.SLAP.m_135782_(), DefaultDamageTypeProvider.damage("entity.minecolonies.slap")), Map.entry(DamageSourceKeys.STUCK_DAMAGE.m_135782_(), DefaultDamageTypeProvider.damage("entity.minecolonies.stuckdamage")), Map.entry(DamageSourceKeys.TRAINING.m_135782_(), DefaultDamageTypeProvider.damage("entity.minecolonies.training")), Map.entry(DamageSourceKeys.WAKEY.m_135782_(), DefaultDamageTypeProvider.damage("entity.minecolonies.wakeywakey")), Map.entry(DamageSourceKeys.AMAZON.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.AMAZON)), Map.entry(DamageSourceKeys.AMAZONCHIEF.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.AMAZONCHIEF)), Map.entry(DamageSourceKeys.AMAZONSPEARMAN.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.AMAZONSPEARMAN)), Map.entry(DamageSourceKeys.ARCHERBARBARIAN.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.ARCHERBARBARIAN)), Map.entry(DamageSourceKeys.ARCHERMUMMY.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.ARCHERMUMMY)), Map.entry(DamageSourceKeys.ARCHERPIRATE.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.ARCHERPIRATE)), Map.entry(DamageSourceKeys.BARBARIAN.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.BARBARIAN)), Map.entry(DamageSourceKeys.CHIEFBARBARIAN.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.CHIEFBARBARIAN)), Map.entry(DamageSourceKeys.CHIEFPIRATE.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.CHIEFPIRATE)), Map.entry(DamageSourceKeys.MERCENARY.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.MERCENARY)), Map.entry(DamageSourceKeys.MUMMY.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.MUMMY)), Map.entry(DamageSourceKeys.NORSEMENARCHER.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.NORSEMEN_ARCHER)), Map.entry(DamageSourceKeys.NORSEMENCHIEF.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.NORSEMEN_CHIEF)), Map.entry(DamageSourceKeys.PHARAO.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.PHARAO)), Map.entry(DamageSourceKeys.PIRATE.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.PIRATE)), Map.entry(DamageSourceKeys.SHIELDMAIDEN.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.SHIELDMAIDEN)), Map.entry(DamageSourceKeys.SPEAR.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.SPEAR)), Map.entry(DamageSourceKeys.VISITOR.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.VISITOR)), Map.entry(DamageSourceKeys.DROWNED_PIRATE.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.DROWNED_PIRATE)), Map.entry(DamageSourceKeys.DROWNED_ARCHERPIRATE.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.DROWNED_ARCHERPIRATE)), Map.entry(DamageSourceKeys.DROWNED_CHIEFPIRATE.m_135782_(), DefaultDamageTypeProvider.entityDamage(ModEntities.DROWNED_CHIEFPIRATE)));
    }

    @NotNull
    private static DamageType entityDamage(@NotNull EntityType<?> entityType) {
        return DefaultDamageTypeProvider.damage(entityType.m_20675_());
    }

    @NotNull
    private static DamageType damage(@NotNull String msgId) {
        return new DamageType(msgId, DamageScaling.ALWAYS, 0.1f);
    }
}

