/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.event;

import com.minecolonies.api.quests.IQuestInstance;
import com.minecolonies.api.quests.IQuestManager;
import com.minecolonies.api.quests.IQuestObjectiveTemplate;
import com.minecolonies.core.quests.objectives.IBreakBlockObjectiveTemplate;
import com.minecolonies.core.quests.objectives.IKillEntityObjectiveTemplate;
import com.minecolonies.core.quests.objectives.IPlaceBlockObjectiveTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="minecolonies", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class QuestObjectiveEventHandler {
    private static final Map<Block, Map<UUID, List<IQuestInstance>>> breakBlockObjectives = new HashMap<Block, Map<UUID, List<IQuestInstance>>>();
    private static final Map<EntityType<?>, Map<UUID, List<IQuestInstance>>> entityKillObjectives = new HashMap();
    private static final Map<Block, Map<UUID, List<IQuestInstance>>> placeBlockObjectives = new HashMap<Block, Map<UUID, List<IQuestInstance>>>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void on(BlockEvent.BreakEvent event) {
        LevelAccessor world = event.getLevel();
        if (world.m_5776_()) {
            return;
        }
        Block block = event.getState().m_60734_();
        if (breakBlockObjectives.containsKey(block) && breakBlockObjectives.get(block).containsKey(event.getPlayer().m_20148_())) {
            List<IQuestInstance> objectives = breakBlockObjectives.get(block).get(event.getPlayer().m_20148_());
            for (IQuestInstance colonyQuest : new ArrayList<IQuestInstance>(objectives)) {
                IQuestObjectiveTemplate objective = IQuestManager.GLOBAL_SERVER_QUESTS.get(colonyQuest.getId()).getObjective(colonyQuest.getObjectiveIndex());
                if (objective instanceof IBreakBlockObjectiveTemplate) {
                    ((IBreakBlockObjectiveTemplate)((Object)objective)).onBlockBreak(colonyQuest.getCurrentObjectiveInstance(), colonyQuest, event.getPlayer());
                    continue;
                }
                objectives.remove(colonyQuest);
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void on(LivingDeathEvent event) {
        if (event.getSource().m_7639_() instanceof Player && entityKillObjectives.containsKey(event.getEntity().m_6095_()) && entityKillObjectives.get(event.getEntity().m_6095_()).containsKey(event.getSource().m_7639_().m_20148_())) {
            List<IQuestInstance> objectives = entityKillObjectives.get(event.getEntity().m_6095_()).get(event.getSource().m_7639_().m_20148_());
            for (IQuestInstance colonyQuest : new ArrayList<IQuestInstance>(objectives)) {
                IQuestObjectiveTemplate objective = IQuestManager.GLOBAL_SERVER_QUESTS.get(colonyQuest.getId()).getObjective(colonyQuest.getObjectiveIndex());
                if (objective instanceof IKillEntityObjectiveTemplate) {
                    ((IKillEntityObjectiveTemplate)((Object)objective)).onEntityKill(colonyQuest.getCurrentObjectiveInstance(), colonyQuest, (Player)event.getSource().m_7639_());
                    continue;
                }
                objectives.remove(colonyQuest);
                break;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void on(BlockEvent.EntityPlaceEvent event) {
        LevelAccessor world = event.getLevel();
        if (world.m_5776_() || !(event.getEntity() instanceof Player)) {
            return;
        }
        Block block = event.getPlacedBlock().m_60734_();
        if (placeBlockObjectives.containsKey(block) && placeBlockObjectives.get(block).containsKey(event.getEntity().m_20148_())) {
            List<IQuestInstance> objectives = placeBlockObjectives.get(block).get(event.getEntity().m_20148_());
            for (IQuestInstance colonyQuest : new ArrayList<IQuestInstance>(objectives)) {
                IQuestObjectiveTemplate objective = IQuestManager.GLOBAL_SERVER_QUESTS.get(colonyQuest.getId()).getObjective(colonyQuest.getObjectiveIndex());
                if (objective instanceof IPlaceBlockObjectiveTemplate) {
                    ((IPlaceBlockObjectiveTemplate)((Object)objective)).onBlockPlace(colonyQuest.getCurrentObjectiveInstance(), colonyQuest, (Player)event.getEntity());
                    continue;
                }
                objectives.remove(colonyQuest);
                break;
            }
        }
    }

    public static void addQuestMineObjectiveListener(Block blockToMine, UUID assignedPlayer, IQuestInstance colonyQuest) {
        Map currentMap = breakBlockObjectives.getOrDefault(blockToMine, new HashMap());
        List objectives = currentMap.getOrDefault(assignedPlayer, new ArrayList());
        objectives.add(colonyQuest);
        currentMap.put(assignedPlayer, objectives);
        breakBlockObjectives.put(blockToMine, currentMap);
    }

    public static void removeQuestMineObjectiveListener(Block blockToMine, UUID assignedPlayer, IQuestInstance colonyQuest) {
        ((List)((Map)breakBlockObjectives.getOrDefault(blockToMine, new HashMap())).getOrDefault(assignedPlayer, new ArrayList())).remove(colonyQuest);
    }

    public static void addQuestPlaceObjectiveListener(Block blockToPlace, UUID assignedPlayer, IQuestInstance colonyQuest) {
        Map currentMap = placeBlockObjectives.getOrDefault(blockToPlace, new HashMap());
        List objectives = currentMap.getOrDefault(assignedPlayer, new ArrayList());
        objectives.add(colonyQuest);
        currentMap.put(assignedPlayer, objectives);
        placeBlockObjectives.put(blockToPlace, currentMap);
    }

    public static void removeQuestPlaceBlockObjectiveListener(Block blockToPlace, UUID assignedPlayer, IQuestInstance colonyQuest) {
        ((List)((Map)placeBlockObjectives.getOrDefault(blockToPlace, new HashMap())).getOrDefault(assignedPlayer, new ArrayList())).remove(colonyQuest);
    }

    public static void addKillQuestObjectiveListener(EntityType<?> entityToKill, UUID assignedPlayer, IQuestInstance colonyQuest) {
        Map currentMap = entityKillObjectives.getOrDefault(entityToKill, new HashMap());
        List objectives = currentMap.getOrDefault(assignedPlayer, new ArrayList());
        objectives.add(colonyQuest);
        currentMap.put(assignedPlayer, objectives);
        entityKillObjectives.put(entityToKill, currentMap);
    }

    public static void removeKillQuestObjectiveListener(EntityType<?> entityToKill, UUID assignedPlayer, IQuestInstance colonyQuest) {
        ((List)((Map)entityKillObjectives.getOrDefault(entityToKill, new HashMap())).getOrDefault(assignedPlayer, new ArrayList())).remove(colonyQuest);
    }
}

