/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.event;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.datalistener.CitizenNameListener;
import com.minecolonies.core.datalistener.CrafterRecipeListener;
import com.minecolonies.core.datalistener.CustomVisitorListener;
import com.minecolonies.core.datalistener.ItemNbtListener;
import com.minecolonies.core.datalistener.QuestJsonListener;
import com.minecolonies.core.datalistener.ResearchListener;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import com.minecolonies.core.util.BackUpHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class FMLEventHandler {
    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        IColonyManager.getInstance().onServerTick(event);
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        IColonyManager.getInstance().onClientTick(event);
    }

    @SubscribeEvent
    public static void onPlayerLogin(@NotNull PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            IColonyManager.getInstance().getIColonyByOwner(event.getEntity().f_19853_, event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onAddReloadListenerEvent(@NotNull AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new CrafterRecipeListener());
        event.addListener((PreparableReloadListener)new ResearchListener());
        event.addListener((PreparableReloadListener)new CustomVisitorListener());
        event.addListener((PreparableReloadListener)new CitizenNameListener());
        event.addListener((PreparableReloadListener)new QuestJsonListener());
        event.addListener((PreparableReloadListener)new ItemNbtListener());
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        IColonyManager.getInstance().onWorldTick(event);
    }

    @SubscribeEvent
    public static void onServerAboutToStart(@NotNull ServerAboutToStartEvent event) {
        IColonyManager.getInstance().getRecipeManager().reset();
    }

    @SubscribeEvent
    public static void onServerStopped(@NotNull ServerStoppingEvent event) {
        Pathfinding.shutdown();
    }

    @SubscribeEvent
    public static void onServerStarted(@NotNull ServerStartedEvent event) {
        BackUpHelper.loadMissingColonies();
    }
}

