/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PathJobWalkRandomEdge
extends AbstractPathJob {
    private static final int NODE_EDGE_CHANCE = 10;
    private final BlockPos searchAroundPos;

    public PathJobWalkRandomEdge(Level world, @NotNull BlockPos searchAroundPos, int range, Mob entity) {
        super(world, PathfindingUtils.prepareStart((LivingEntity)entity), range, new PathResult(), entity);
        this.searchAroundPos = searchAroundPos;
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.searchAroundPos, x, y, z);
    }

    @Override
    protected boolean isAtDestination(MNode n) {
        if (this.searchAroundPos.m_123342_() - n.y > 3) {
            return false;
        }
        if (ColonyConstants.rand.nextInt(10) == 0) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!this.cachedBlockLookup.getBlockState(n.x + direction.m_122429_(), n.y - 1 + direction.m_122430_(), n.z + direction.m_122431_()).m_60795_()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected double getEndNodeScore(MNode n) {
        return BlockPosUtil.distManhattan(this.start, n.x, n.y, n.z);
    }
}

