/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.events.raid.RaidManager;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class PathJobRaiderPathing
extends AbstractPathJob {
    private final double THROUGH_BLOCK_COST = 30.0;
    private final List<IBuilding> buildings;
    private final BlockPos direction;
    private double addCost = 1.0;

    public PathJobRaiderPathing(List<IBuilding> buildings, Level world, @NotNull BlockPos start, BlockPos targetSpawnPoint) {
        super(world, start, targetSpawnPoint, new PathResult(), null);
        this.buildings = buildings;
        this.direction = targetSpawnPoint;
        this.maxNodes = 5000;
        this.setPathingOptions(new PathingOptions().withJumpCost(1.0).withStartSwimCost(1.0).withSwimCost(1.0).withCanSwim(true).withCanEnterDoors(true));
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.direction, x, y, z);
    }

    @Override
    protected boolean isAtDestination(MNode n) {
        if (BlockPosUtil.distSqr(this.start, n.x, n.y, n.z) < 2500) {
            return false;
        }
        return BlockPosUtil.distSqr(this.direction, n.x, n.y, n.z) < 2500 && RaidManager.isValidSpawnPoint(this.buildings, (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y, n.z)) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    @Override
    protected boolean isPassable(int x, int y, int z, boolean head, MNode currentnode) {
        return true;
    }

    @Override
    protected void visitNode(MNode node) {
        super.visitNode(node);
        if (!node.isSwimming()) {
            this.exploreInDirection(node, 0, -1, 0);
        }
        if (SurfaceType.getSurfaceType(this.cachedBlockLookup, this.cachedBlockLookup.getBlockState(node.x, node.y, node.z), (BlockPos)this.tempWorldPos.m_122178_(node.x, node.y, node.z)) == SurfaceType.WALKABLE) {
            this.exploreInDirection(node, 0, 1, 0);
            return;
        }
        int dX = 0;
        int dY = 0;
        int dZ = 0;
        if (node.parent != null) {
            dX = node.x - node.parent.x;
            dY = node.y - node.parent.y;
            dZ = node.z - node.parent.z;
        }
        if (dY >= 0 || dX != 0 || dZ != 0) {
            for (Direction dir : BlockPosUtil.HORIZONTAL_DIRS) {
                BlockState toPlace = (BlockState)Blocks.f_50155_.m_49966_().m_61124_((Property)LadderBlock.f_54337_, (Comparable)dir.m_122424_());
                if (!BlockUtils.isAnySolid((BlockState)this.cachedBlockLookup.getBlockState(node.x + dir.m_122429_(), node.y + dir.m_122430_(), node.z + dir.m_122431_())) || !Blocks.f_50155_.m_7898_(toPlace, this.world, (BlockPos)this.tempWorldPos.m_122178_(node.x, node.y, node.z))) continue;
                this.exploreInDirection(node, 0, 1, 0);
                return;
            }
        }
    }

    @Override
    protected int getGroundHeight(MNode parent, int x, int y, int z) {
        int height = super.getGroundHeight(parent, x, y, z);
        if (height != y) {
            this.addCost = 0.5;
        }
        if (parent.x - x == 0 && parent.z - z == 0 || Math.abs(height - y) > 1 && SurfaceType.getSurfaceType(this.cachedBlockLookup, this.cachedBlockLookup.getBlockState(x, y - 1, z), (BlockPos)this.tempWorldPos.m_122178_(x, y - 1, z), this.getPathingOptions()) == SurfaceType.WALKABLE) {
            this.addCost = 3.5;
            return y;
        }
        return height;
    }

    @Override
    protected double modifyCost(double cost, MNode parent, boolean swimstart, boolean swimming, int x, int y, int z, BlockState state, BlockState below) {
        double modifier = this.addCost;
        this.addCost = 1.0;
        if (!super.isPassable(x, y, z, false, null)) {
            modifier *= 30.0;
        }
        if (SurfaceType.getSurfaceType(this.cachedBlockLookup, this.cachedBlockLookup.getBlockState(x, y - 1, z), (BlockPos)this.tempWorldPos.m_122178_(x, y - 1, z), this.getPathingOptions()) != SurfaceType.WALKABLE) {
            modifier *= 30.0;
        }
        return cost * modifier;
    }
}

