/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathJobMoveAwayFromLocation
extends AbstractPathJob {
    @NotNull
    protected final BlockPos avoid;
    protected final int avoidDistance;
    private BlockPos preferredDirection;

    public PathJobMoveAwayFromLocation(Level world, @NotNull BlockPos start, @NotNull BlockPos avoid, int avoidDistance, int range, Mob entity) {
        super(world, start, range, new PathResult(), entity);
        IColony colony;
        this.avoid = new BlockPos((Vec3i)avoid);
        this.avoidDistance = avoidDistance;
        this.preferredDirection = entity.m_20183_().m_121955_((Vec3i)entity.m_20183_().m_121996_((Vec3i)avoid).m_142393_(range));
        if (entity instanceof AbstractEntityCitizen && (colony = ((AbstractEntityCitizen)entity).getCitizenColonyHandler().getColony()) != null) {
            this.preferredDirection = colony.getCenter();
        }
    }

    @Override
    @Nullable
    protected Path search() {
        if ((Integer)MineColonies.getConfig().getServer().pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info(String.format("Pathfinding from [%d,%d,%d] away from [%d,%d,%d]", this.start.m_123341_(), this.start.m_123342_(), this.start.m_123343_(), this.avoid.m_123341_(), this.avoid.m_123342_(), this.avoid.m_123343_()));
        }
        return super.search();
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.dist(this.preferredDirection, x, y, z);
    }

    @Override
    protected double modifyCost(double cost, MNode parent, boolean swimstart, boolean swimming, int x, int y, int z, BlockState state, BlockState below) {
        if (BlockPosUtil.dist(this.avoid, x, y, z) < 3.0) {
            return cost + 100.0;
        }
        return cost;
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        return BlockPosUtil.dist(this.avoid, n.x, n.y, n.z) > (double)this.avoidDistance && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    @Override
    protected double getEndNodeScore(@NotNull MNode n) {
        return -BlockPosUtil.dist(this.avoid, n.x, n.y, n.z);
    }
}

