/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Pond;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.entity.pathfinding.pathresults.WaterPathResult;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class PathJobFindWater
extends AbstractPathJob {
    private static final int MIN_DISTANCE = 40;
    private static final int MAX_RANGE = 100;
    private final BlockPos hutLocation;
    @NotNull
    private final List<Tuple<BlockPos, BlockPos>> ponds;

    public PathJobFindWater(Level world, @NotNull BlockPos start, BlockPos home, int range, @NotNull List<Tuple<BlockPos, BlockPos>> ponds, Mob entity) {
        super(world, start, range, (PathResult)new WaterPathResult(), entity);
        this.ponds = new ArrayList<Tuple<BlockPos, BlockPos>>(ponds);
        this.hutLocation = home;
    }

    @Override
    @NotNull
    public WaterPathResult getResult() {
        return (WaterPathResult)super.getResult();
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.distManhattan(this.hutLocation, x, y, z);
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        if (BlockPosUtil.distSqr(this.hutLocation, n.x, n.y, n.z) > 10000) {
            return false;
        }
        if (n.isSwimming() && Pond.checkWater((BlockGetter)this.world, (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z))) {
            for (Tuple<BlockPos, BlockPos> existingPond : this.ponds) {
                if (BlockPosUtil.distManhattan(existingPond.getA(), n.x, n.y, n.z) >= 7) continue;
                return false;
            }
            PathJobFindFishingPos job = new PathJobFindFishingPos(this.world, new BlockPos(n.x, n.y, n.z), this.hutLocation, 10);
            job.setPathingOptions(this.getPathingOptions());
            Path path = job.search();
            if (path != null && path.m_77403_()) {
                this.getResult().pond = new BlockPos(n.x, n.y, n.z);
                this.getResult().parent = path.m_77406_();
                return true;
            }
        }
        return false;
    }

    @Override
    public void setPathingOptions(PathingOptions pathingOptions) {
        super.setPathingOptions(pathingOptions);
        this.getPathingOptions().swimCostEnter = 0.0;
        this.getPathingOptions().swimCost = 0.0;
    }

    private class PathJobFindFishingPos
    extends AbstractPathJob {
        private final BlockPos direction;
        private final int distance;

        public PathJobFindFishingPos(@NotNull LevelReader world, @NotNull BlockPos start, BlockPos direction, int distance) {
            super(world, start, distance + 100, new PathResult(), null);
            this.direction = direction;
            this.distance = distance;
        }

        @Override
        protected double computeHeuristic(int x, int y, int z) {
            return BlockPosUtil.distManhattan(this.direction, x, y, z);
        }

        @Override
        protected boolean isAtDestination(MNode n) {
            return !n.isSwimming() && BlockPosUtil.distManhattan(this.start, n.x, n.y, n.z) < this.distance && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.m_122178_(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE && this.canSeeTargetFromPos(n);
        }

        private boolean canSeeTargetFromPos(MNode n) {
            Vec3 vec3d1;
            Vec3 vec3d = new Vec3((double)this.start.m_123341_(), (double)this.start.m_123342_() + 1.8, (double)this.start.m_123343_());
            return this.world.m_45547_(new ClipContext(vec3d, vec3d1 = new Vec3((double)n.x, (double)n.y, (double)n.z), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity)).m_6662_() == HitResult.Type.MISS;
        }
    }
}

