/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding;

import com.ldtteam.domumornamentum.block.decorative.FloatingCarpetBlock;
import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.util.ShapeUtil;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BambooSaplingBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SurfaceType {
    WALKABLE,
    DROPABLE,
    NOT_PASSABLE;


    @NotNull
    public static SurfaceType getSurfaceType(BlockGetter world, BlockState blockState, BlockPos pos) {
        return SurfaceType.getSurfaceType(world, blockState, pos, null);
    }

    @NotNull
    public static SurfaceType getSurfaceType(BlockGetter world, BlockState blockState, BlockPos pos, @Nullable PathingOptions pathingOptions) {
        Block block = blockState.m_60734_();
        if (PathfindingUtils.isDangerous(blockState)) {
            if (pathingOptions != null && pathingOptions.canPassDanger()) {
                if (ShapeUtil.isEmpty(blockState.m_60812_(world, pos))) {
                    return DROPABLE;
                }
                return WALKABLE;
            }
            return NOT_PASSABLE;
        }
        if (block instanceof FenceBlock || block instanceof FenceGateBlock || block instanceof WallBlock || block instanceof AbstractBlockMinecoloniesDefault || block instanceof BambooStalkBlock || block instanceof BambooSaplingBlock || block instanceof DoorBlock) {
            return NOT_PASSABLE;
        }
        VoxelShape shape = blockState.m_60812_(world, pos);
        double maxShapeY = ShapeUtil.max(shape, Direction.Axis.Y);
        if (maxShapeY < 0.5 && PathfindingUtils.isDangerous(world.m_8055_(pos.m_7495_()))) {
            if (pathingOptions != null && pathingOptions.canPassDanger()) {
                return WALKABLE;
            }
            return NOT_PASSABLE;
        }
        if ((block instanceof PanelBlock || block instanceof TrapdoorBlock) && !((Boolean)blockState.m_61143_((Property)TrapdoorBlock.f_57514_)).booleanValue()) {
            return WALKABLE;
        }
        if (maxShapeY > 1.0) {
            return NOT_PASSABLE;
        }
        FluidState fluid = world.m_6425_(pos);
        if (PathfindingUtils.isWater(world, pos, blockState, fluid)) {
            return WALKABLE;
        }
        if (PathfindingUtils.isLava(world, pos, blockState, fluid)) {
            return NOT_PASSABLE;
        }
        if (block instanceof AbstractBlockMinecoloniesConstructionTape || block instanceof SignBlock || block instanceof VineBlock) {
            return DROPABLE;
        }
        if (BlockUtils.isAnySolid((BlockState)blockState) && ShapeUtil.max(shape, Direction.Axis.X) - ShapeUtil.min(shape, Direction.Axis.X) > 0.75 && ShapeUtil.max(shape, Direction.Axis.Z) - ShapeUtil.min(shape, Direction.Axis.Z) > 0.75 || blockState.m_60734_() == Blocks.f_50125_ && (Integer)blockState.m_61143_((Property)SnowLayerBlock.f_56581_) > 1 || block instanceof FloatingCarpetBlock || block instanceof CarpetBlock) {
            return WALKABLE;
        }
        return DROPABLE;
    }
}

