/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.mobs.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.mobs.AbstractEntityRaiderMob;
import com.minecolonies.api.entity.mobs.IArcherMobEntity;
import com.minecolonies.api.entity.mobs.IRangedMobEntity;
import com.minecolonies.api.entity.mobs.drownedpirate.AbstractDrownedEntityPirate;
import com.minecolonies.api.entity.mobs.registry.IMobAIRegistry;
import com.minecolonies.core.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.mobs.aitasks.EntityAIBreakDoor;
import com.minecolonies.core.entity.mobs.aitasks.RaiderMeleeAI;
import com.minecolonies.core.entity.mobs.aitasks.RaiderRangedAI;
import com.minecolonies.core.entity.mobs.aitasks.RaiderWalkAI;
import com.minecolonies.core.util.MultimapCollector;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class MobAIRegistry
implements IMobAIRegistry {
    private final List<TaskInformationWrapper<AbstractEntityRaiderMob, Goal>> mobAiTasks = Lists.newArrayList();
    private final List<TaskInformationWrapper<AbstractEntityRaiderMob, Goal>> mobAiTargetTasks = Lists.newArrayList();
    private final List<TaskInformationWrapper<AbstractEntityRaiderMob, IStateAI>> mobStateAITasks = Lists.newArrayList();

    public MobAIRegistry() {
        MobAIRegistry.setupMobAiTasks(this);
    }

    private static void setupMobAiTasks(IMobAIRegistry registry) {
        registry.registerNewAiTaskForMobs(0, FloatGoal::new, mob -> !(mob instanceof AbstractDrownedEntityPirate)).registerNewAiTargetTaskForMobs(3, mob -> new EntityAIInteractToggleAble((Mob)mob, EntityAIInteractToggleAble.FENCE_TOGGLE)).registerNewAiTargetTaskForMobs(3, mob -> new EntityAIBreakDoor((Mob)mob)).registerNewAiTaskForMobs(5, mob -> new LookAtPlayerGoal((Mob)mob, Player.class, 8.0f)).registerNewAiTaskForMobs(6, mob -> new LookAtPlayerGoal((Mob)mob, EntityCitizen.class, 8.0f)).registerNewStateAI(mob -> new RaiderMeleeAI<AbstractEntityRaiderMob>((AbstractEntityRaiderMob)mob, mob.getAI()), mob -> !(mob instanceof IArcherMobEntity)).registerNewStateAI(mob -> new RaiderRangedAI<AbstractEntityRaiderMob>((AbstractEntityRaiderMob)mob, mob.getAI()), mob -> mob instanceof IRangedMobEntity).registerNewStateAI(mob -> new RaiderWalkAI((AbstractEntityRaiderMob)mob, mob.getAI()), mob -> true);
    }

    @Override
    @NotNull
    public Multimap<Integer, Goal> getEntityAiTasksForMobs(AbstractEntityRaiderMob mob) {
        return (Multimap)this.mobAiTasks.stream().filter(wrapper -> wrapper.entityPredicate.test(mob)).collect(MultimapCollector.toMultimap(TaskInformationWrapper::getPriority, wrapper -> (Goal)wrapper.getAiTaskProducer().apply(mob)));
    }

    @Override
    @NotNull
    public IMobAIRegistry registerNewAiTaskForMobs(int priority, Function<AbstractEntityRaiderMob, Goal> aiTaskProducer, Predicate<AbstractEntityRaiderMob> applyPredicate) {
        this.mobAiTasks.add(new TaskInformationWrapper<AbstractEntityRaiderMob, Goal>(priority, aiTaskProducer, applyPredicate));
        return this;
    }

    @Override
    @NotNull
    public IMobAIRegistry registerNewStateAI(Function<AbstractEntityRaiderMob, IStateAI> aiTaskProducer, Predicate<AbstractEntityRaiderMob> applyPredicate) {
        this.mobStateAITasks.add(new TaskInformationWrapper<AbstractEntityRaiderMob, IStateAI>(0, aiTaskProducer, applyPredicate));
        return this;
    }

    @Override
    @NotNull
    public void applyToMob(AbstractEntityRaiderMob mob) {
        for (TaskInformationWrapper<AbstractEntityRaiderMob, IStateAI> taskInformationWrapper : this.mobStateAITasks) {
            if (!taskInformationWrapper.entityPredicate.test(mob)) continue;
            taskInformationWrapper.aiTaskProducer.apply(mob);
        }
        for (TaskInformationWrapper<AbstractEntityRaiderMob, IStateAI> taskInformationWrapper : this.mobAiTargetTasks) {
            if (!taskInformationWrapper.entityPredicate.test(mob)) continue;
            mob.f_21345_.m_25352_(taskInformationWrapper.priority, (Goal)taskInformationWrapper.aiTaskProducer.apply(mob));
        }
        for (TaskInformationWrapper<AbstractEntityRaiderMob, IStateAI> taskInformationWrapper : this.mobAiTasks) {
            if (!taskInformationWrapper.entityPredicate.test(mob)) continue;
            mob.f_21345_.m_25352_(taskInformationWrapper.priority, (Goal)taskInformationWrapper.aiTaskProducer.apply(mob));
        }
    }

    @Override
    @NotNull
    public Multimap<Integer, Goal> getEntityAiTargetTasksForMobs(AbstractEntityRaiderMob mob) {
        return (Multimap)this.mobAiTargetTasks.stream().filter(wrapper -> wrapper.getEntityPredicate().test(mob)).collect(MultimapCollector.toMultimap(TaskInformationWrapper::getPriority, wrapper -> (Goal)wrapper.getAiTaskProducer().apply(mob)));
    }

    @Override
    @NotNull
    public IMobAIRegistry registerNewAiTargetTaskForMobs(int priority, Function<AbstractEntityRaiderMob, Goal> aiTaskProducer, Predicate<AbstractEntityRaiderMob> applyPredicate) {
        this.mobAiTargetTasks.add(new TaskInformationWrapper<AbstractEntityRaiderMob, Goal>(priority, aiTaskProducer, applyPredicate));
        return this;
    }

    private static final class TaskInformationWrapper<M extends Entity, G> {
        private final int priority;
        private final Function<AbstractEntityRaiderMob, G> aiTaskProducer;
        private final Predicate<M> entityPredicate;

        TaskInformationWrapper(int priority, Function<AbstractEntityRaiderMob, G> aiTaskProducer, Predicate<M> entityPredicate) {
            this.priority = priority;
            this.aiTaskProducer = aiTaskProducer;
            this.entityPredicate = entityPredicate;
        }

        public int getPriority() {
            return this.priority;
        }

        public Function<AbstractEntityRaiderMob, G> getAiTaskProducer() {
            return this.aiTaskProducer;
        }

        public Predicate<M> getEntityPredicate() {
            return this.entityPredicate;
        }
    }
}

