/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.mobs.aitasks;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.ai.combat.CombatAIStates;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.mobs.AbstractEntityRaiderMob;
import com.minecolonies.api.entity.pathfinding.IPathJob;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.events.raid.HordeRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class RaiderWalkAI
implements IStateAI {
    private final AbstractEntityRaiderMob raider;
    private BlockPos targetBlock = null;
    private long walkTimer = 0L;
    private PathResult<? extends IPathJob> randomPathResult;
    private boolean walkInBuildingState = false;

    public RaiderWalkAI(AbstractEntityRaiderMob raider, ITickRateStateMachine<IState> stateMachine) {
        this.raider = raider;
        stateMachine.addTransition(new TickingTransition<IState>(CombatAIStates.NO_TARGET, this::walk, () -> null, 80));
    }

    private boolean walk() {
        if (this.raider.getColony() != null) {
            IColonyEvent event = this.raider.getColony().getEventManager().getEventByID(this.raider.getEventID());
            if (event == null) {
                return false;
            }
            if (event.getStatus() == EventStatus.PREPARING && event instanceof HordeRaidEvent) {
                this.walkToCampFire();
                return false;
            }
            this.raider.setTempEnvDamageImmunity(false);
            if (this.targetBlock == null || this.raider.f_19853_.m_46467_() > this.walkTimer) {
                this.targetBlock = this.raider.getColony().getRaiderManager().getRandomBuilding();
                this.walkTimer = this.raider.f_19853_.m_46467_() + 4800L;
                List<BlockPos> wayPoints = ((IColonyRaidEvent)event).getWayPoints();
                BlockPos moveToPos = ShipBasedRaiderUtils.chooseWaypointFor(wayPoints, this.raider.m_20183_(), this.targetBlock);
                this.raider.getNavigation().moveToXYZ(moveToPos.m_123341_(), moveToPos.m_123342_(), moveToPos.m_123343_(), !moveToPos.equals((Object)this.targetBlock) && moveToPos.m_123333_((Vec3i)wayPoints.get(0)) > 50 ? 1.8 : 1.1);
                this.walkInBuildingState = false;
                this.randomPathResult = null;
            } else if (this.walkInBuildingState) {
                BlockPos moveToPos = this.findRandomPositionToWalkTo();
                if (moveToPos != null) {
                    if (moveToPos == BlockPos.f_121853_) {
                        this.walkInBuildingState = false;
                        this.targetBlock = null;
                        return false;
                    }
                    this.raider.getNavigation().moveToXYZ(moveToPos.m_123341_(), moveToPos.m_123342_(), moveToPos.m_123343_(), 0.9);
                    if (this.raider.m_20183_().m_123331_((Vec3i)moveToPos) < 4.0) {
                        if (this.raider.m_217043_().m_188500_() < 0.25) {
                            this.walkInBuildingState = false;
                            this.targetBlock = null;
                        } else {
                            this.randomPathResult = null;
                            this.walkTimer = this.raider.f_19853_.m_46467_() + 1200L;
                            this.findRandomPositionToWalkTo();
                        }
                    }
                }
            } else if (this.raider.m_20183_().m_123331_((Vec3i)this.targetBlock) < 25.0) {
                this.findRandomPositionToWalkTo();
                this.walkTimer = this.raider.f_19853_.m_46467_() + 600L;
                this.walkInBuildingState = true;
            } else if (this.raider.getNavigation().m_26571_() || this.raider.getNavigation().getDesiredPos() == null) {
                List<BlockPos> wayPoints = ((IColonyRaidEvent)event).getWayPoints();
                BlockPos moveToPos = ShipBasedRaiderUtils.chooseWaypointFor(wayPoints, this.raider.m_20183_(), this.targetBlock);
                if (moveToPos.equals((Object)BlockPos.f_121853_)) {
                    Log.getLogger().warn("Raider trying to path to zero position, target pos:" + this.targetBlock + " Waypoints:");
                    for (BlockPos pos : wayPoints) {
                        Log.getLogger().warn(pos.m_123344_());
                    }
                }
                this.raider.getNavigation().moveToXYZ(moveToPos.m_123341_(), moveToPos.m_123342_(), moveToPos.m_123343_(), !moveToPos.equals((Object)this.targetBlock) && moveToPos.m_123333_((Vec3i)wayPoints.get(0)) > 50 ? 1.8 : 1.1);
            }
        }
        return false;
    }

    protected BlockPos findRandomPositionToWalkTo() {
        if (this.randomPathResult == null || this.randomPathResult.failedToReachDestination()) {
            AbstractBuilding building;
            IBuilding iBuilding = this.raider.getColony().getBuildingManager().getBuilding(this.targetBlock);
            if (iBuilding instanceof AbstractBuilding && (building = (AbstractBuilding)iBuilding).getBuildingLevel() > 0 && !((BlockPos)building.getCorners().m_14418_()).equals(building.getCorners().m_14419_())) {
                this.randomPathResult = this.raider.getNavigation().moveToRandomPos(10, 0.9, building.getCorners());
                this.randomPathResult.getJob().getPathingOptions().withCanEnterDoors(true).withToggleCost(0.0).withNonLadderClimbableCost(0.0);
            } else {
                return BlockPos.f_121853_;
            }
        }
        if (this.randomPathResult.isPathReachingDestination()) {
            return this.randomPathResult.getPath().m_77395_().m_77288_();
        }
        if (this.randomPathResult.isCancelled()) {
            this.randomPathResult = null;
            return null;
        }
        return null;
    }

    private void walkToCampFire() {
        if (this.raider.f_19853_.m_46467_() - this.walkTimer < 0L) {
            return;
        }
        BlockPos campFire = ((HordeRaidEvent)this.raider.getColony().getEventManager().getEventByID(this.raider.getEventID())).getRandomCampfire();
        if (campFire == null) {
            return;
        }
        this.walkTimer = this.raider.f_19853_.m_46467_() + (long)this.raider.f_19853_.f_46441_.m_188503_(1000);
        BlockPos posAroundCampfire = BlockPosUtil.getRandomPosition(this.raider.f_19853_, campFire, BlockPos.f_121853_, 3, 6);
        if (posAroundCampfire != null && posAroundCampfire != BlockPos.f_121853_) {
            this.raider.getNavigation().moveToXYZ(posAroundCampfire.m_123341_(), posAroundCampfire.m_123342_(), posAroundCampfire.m_123343_(), 1.0);
        }
    }
}

