/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.util;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.BlockStateUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.MineColonies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tree {
    private static final String DYNAMICTREERADIUS = "radius";
    private static final int NUMBER_OF_LEAVES = 3;
    private static final int LEAVES_WIDTH = 4;
    private static final int A_LOT_OF_LUCK = 10000;
    private BlockPos location;
    private BlockPos topLog;
    private LinkedList<BlockPos> woodBlocks = new LinkedList();
    private LinkedList<BlockPos> leaves = new LinkedList();
    private boolean isTree;
    private ItemStack sapling;
    private ArrayList<BlockPos> stumpLocations;
    private Property<?> variant;
    private boolean slimeTree = false;
    private boolean dynamicTree = false;
    private boolean netherTree = false;

    private Tree() {
        this.isTree = true;
    }

    public Tree(@NotNull Level world, @NotNull BlockPos log, @Nullable IColony colony) {
        BlockState block = BlockPosUtil.getBlockState(world, log);
        if (block.m_204336_(ModTags.tree) || Compatibility.isSlimeBlock(block.m_60734_()) || Compatibility.isDynamicBlock(block.m_60734_())) {
            this.isTree = true;
            this.woodBlocks = new LinkedList();
            this.leaves = new LinkedList();
            this.location = log;
            this.topLog = log;
            this.addAndSearch(world, log, colony);
            this.addAndSearch(world);
            this.checkTree(world, this.topLog);
            this.dynamicTree = Compatibility.isDynamicBlock(block.m_60734_());
            this.stumpLocations = new ArrayList();
            this.woodBlocks.clear();
            this.slimeTree = Compatibility.isSlimeBlock(block.m_60734_());
            this.sapling = this.calcSapling(world);
            if (this.sapling.m_204117_(Tags.Items.MUSHROOMS) || this.sapling.m_204117_(ModTags.fungi)) {
                this.netherTree = true;
            }
            this.variant = BlockStateUtils.getPropertyByNameFromState(world.m_8055_(this.location), "variant");
        } else {
            this.isTree = false;
        }
    }

    private ItemStack calcSapling(Level world) {
        if (this.topLog == null) {
            return ItemStack.f_41583_;
        }
        BlockPos firstLeaf = this.getFirstLeaf((LevelAccessor)world);
        ItemStack sapling = this.calcSaplingForPos(world, firstLeaf, true);
        if (sapling != null) {
            return sapling;
        }
        for (BlockPos pos : this.leaves) {
            sapling = this.calcSaplingForPos(world, pos, true);
            if (sapling == null) continue;
            return sapling;
        }
        sapling = this.calcSaplingForPos(world, firstLeaf, false);
        if (sapling != null) {
            return sapling;
        }
        return ItemStackUtils.EMPTY;
    }

    private ItemStack calcSaplingForPos(Level world, BlockPos pos, boolean checkFitsBase) {
        BlockState blockState = world.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (blockState.m_204336_(BlockTags.f_13035_) || Compatibility.isDynamicLeaf(block) || blockState.m_204336_(ModTags.hugeMushroomBlocks)) {
            NonNullList<ItemStack> list = NonNullList.m_122779_();
            if (checkFitsBase && Compatibility.isDynamicLeaf(block) && (!this.isDynamicTree() || !Compatibility.isDynamicFamilyFitting(pos, this.location, (LevelAccessor)world))) {
                return null;
            }
            if (Compatibility.isDynamicLeaf(block)) {
                list = Compatibility.getDropsForDynamicLeaf((LevelAccessor)world, pos, blockState, 10000, block);
            } else {
                list.addAll(Tree.getSaplingsForLeaf((ServerLevel)world, pos));
            }
            for (ItemStack stack : list) {
                if (stack.m_41619_() || !stack.m_204117_(ItemTags.f_13180_) && !stack.m_204117_(Tags.Items.MUSHROOMS)) continue;
                IColonyManager.getInstance().getCompatibilityManager().connectLeafToSapling(block, stack);
                return stack;
            }
        } else if (blockState.m_204336_(BlockTags.f_13078_)) {
            return IColonyManager.getInstance().getCompatibilityManager().getSaplingForLeaf(block);
        }
        return null;
    }

    public static List<ItemStack> getSaplingsForLeaf(ServerLevel world, BlockPos position) {
        NonNullList list = NonNullList.m_122779_();
        BlockState state = world.m_8055_(position);
        if (state.m_60713_(Blocks.f_220838_)) {
            list.add((Object)new ItemStack((ItemLike)Items.f_220175_));
            return list;
        }
        for (int i = 1; i < 100; ++i) {
            list.addAll((Collection)state.m_287290_(new LootParams.Builder(world).m_287286_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)Items.f_42423_)).m_287239_(100.0f).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_()))));
            if (list.isEmpty()) continue;
            for (ItemStack stack : list) {
                if (!stack.m_204117_(ItemTags.f_13180_) && !stack.m_204117_(Tags.Items.MUSHROOMS)) continue;
                return list;
            }
        }
        return list;
    }

    private BlockPos getFirstLeaf(LevelAccessor world) {
        for (int i = 1; i + this.topLog.m_123342_() < 255 && i < 10; ++i) {
            BlockState blockState = world.m_8055_(this.topLog.m_7918_(0, i, 0));
            if (!blockState.m_204336_(BlockTags.f_13035_) && !blockState.m_204336_(ModTags.hugeMushroomBlocks)) continue;
            return this.topLog.m_7918_(0, i, 0);
        }
        return this.topLog.m_7918_(0, 1, 0);
    }

    public static boolean checkTree(@NotNull LevelReader world, BlockPos pos, List<ItemStorage> treesToNotCut, int dyntreesize) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        if (!(state.m_204336_(ModTags.tree) || Compatibility.isSlimeBlock(block) || Compatibility.isDynamicBlock(block))) {
            return false;
        }
        if (Compatibility.isDynamicBlock(block) && BlockStateUtils.getPropertyByNameFromState(state, DYNAMICTREERADIUS) != null && (Integer)state.m_61143_(BlockStateUtils.getPropertyByNameFromState(state, DYNAMICTREERADIUS)) < dyntreesize) {
            return false;
        }
        Tuple<BlockPos, BlockPos> baseAndTOp = Tree.getBottomAndTopLog(world, pos, new LinkedList<BlockPos>(), null, null);
        BlockPos basePos = (BlockPos)baseAndTOp.m_14418_();
        return BlockUtils.isAnySolid((BlockState)world.m_8055_(basePos.m_7495_())) && world.m_8055_(basePos.m_7495_()).m_60734_() != Blocks.f_50652_ && Tree.hasEnoughLeavesAndIsSupposedToCut(world, (BlockPos)baseAndTOp.m_14419_(), treesToNotCut);
    }

    @NotNull
    private static Tuple<BlockPos, BlockPos> getBottomAndTopLog(@NotNull LevelReader world, @NotNull BlockPos log, @NotNull LinkedList<BlockPos> woodenBlocks, BlockPos bottomLog, BlockPos topLog) {
        BlockPos top;
        BlockPos bottom = bottomLog == null ? log : bottomLog;
        BlockPos blockPos = top = topLog == null ? log : topLog;
        if (woodenBlocks.size() >= (Integer)MineColonies.getConfig().getServer().maxTreeSize.get()) {
            return new Tuple((Object)bottom, (Object)top);
        }
        if (log.m_123342_() < bottom.m_123342_()) {
            bottom = log;
        }
        if (log.m_123342_() > top.m_123342_()) {
            top = log;
        }
        woodenBlocks.add(log);
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos temp = log.m_7918_(x, y, z);
                    BlockState block = world.m_8055_(temp);
                    if (!block.m_204336_(ModTags.tree) && !Compatibility.isSlimeBlock(block.m_60734_()) && !Compatibility.isDynamicBlock(block.m_60734_()) || woodenBlocks.contains(temp)) continue;
                    return Tree.getBottomAndTopLog(world, temp, woodenBlocks, bottom, top);
                }
            }
        }
        return new Tuple((Object)bottom, (Object)top);
    }

    private static boolean hasEnoughLeavesAndIsSupposedToCut(@NotNull LevelReader world, BlockPos pos, List<ItemStorage> treesToNotCut) {
        boolean checkedLeaves = false;
        int leafCount = 0;
        int dynamicBonusY = 0;
        BlockState blockState = world.m_8055_(pos);
        if (blockState.m_204336_(ModTags.mangroveTree) || Compatibility.isDynamicBlock(blockState.m_60734_())) {
            dynamicBonusY = 8;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                for (int dy = -3; dy <= 3 + dynamicBonusY; ++dy) {
                    BlockPos leafPos = pos.m_7918_(dx, dy, dz);
                    BlockState block = world.m_8055_(leafPos);
                    if (!block.m_204336_(BlockTags.f_13035_) && !block.m_204336_(ModTags.hugeMushroomBlocks) && !block.m_204336_(BlockTags.f_13078_)) continue;
                    if (!checkedLeaves && !Tree.supposedToCut(world, treesToNotCut, leafPos)) {
                        return false;
                    }
                    checkedLeaves = true;
                    if (++leafCount < 3 && !Compatibility.isDynamicLeaf(block.m_60734_())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean supposedToCut(LevelReader world, List<ItemStorage> treesToNotCut, BlockPos leafPos) {
        BlockState leaf = world.m_8055_(leafPos);
        if (leaf.m_61145_((Property)LeavesBlock.f_54419_).orElse(false).booleanValue()) {
            return false;
        }
        ItemStack sap = IColonyManager.getInstance().getCompatibilityManager().getSaplingForLeaf(leaf.m_60734_());
        if (sap == null) {
            return true;
        }
        for (ItemStorage stack : treesToNotCut) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(sap, stack.getItemStack()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static Tree read(@NotNull CompoundTag compound) {
        @NotNull Tree tree = new Tree();
        tree.location = BlockPosUtil.read(compound, "location");
        tree.woodBlocks = new LinkedList();
        ListTag logs = compound.m_128437_("Logs", 10);
        for (int i = 0; i < logs.size(); ++i) {
            tree.woodBlocks.add(BlockPosUtil.readFromListNBT(logs, i));
        }
        tree.stumpLocations = new ArrayList();
        ListTag stumps = compound.m_128437_("Stumps", 10);
        for (int i = 0; i < stumps.size(); ++i) {
            tree.stumpLocations.add(BlockPosUtil.readFromListNBT(stumps, i));
        }
        tree.topLog = BlockPosUtil.read(compound, "topLog");
        tree.slimeTree = compound.m_128471_("slimeTree");
        tree.dynamicTree = compound.m_128471_("dynamicTree");
        if (compound.m_128441_("treesapling")) {
            tree.sapling = ItemStack.m_41712_((CompoundTag)compound.m_128469_("treesapling"));
        } else {
            tree.isTree = false;
        }
        tree.netherTree = compound.m_128441_("netherTree") ? compound.m_128471_("netherTree") : false;
        if (compound.m_128441_("leaves")) {
            ListTag leavesBin = compound.m_128437_("leaves", 10);
            for (int i = 0; i < leavesBin.size(); ++i) {
                tree.leaves.add(BlockPosUtil.readFromListNBT(leavesBin, i));
            }
        }
        return tree;
    }

    private void checkTree(@NotNull Level world, @NotNull BlockPos topLog) {
        if (!BlockUtils.isAnySolid((BlockState)world.m_8055_(new BlockPos(this.location.m_123341_(), this.location.m_123342_() - 1, this.location.m_123343_())))) {
            return;
        }
        int leafCount = 0;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 1; ++y) {
                    BlockPos leaf = new BlockPos(topLog.m_123341_() + x, topLog.m_123342_() + y, topLog.m_123343_() + z);
                    BlockState leaves = world.m_8055_(leaf);
                    if (!leaves.m_204336_(BlockTags.f_13035_) && !leaves.m_204336_(ModTags.hugeMushroomBlocks) || leaves.m_61145_((Property)LeavesBlock.f_54419_).orElse(false).booleanValue() || ++leafCount < 3) continue;
                    this.isTree = true;
                    return;
                }
            }
        }
    }

    public void findLogs(@NotNull Level world, @Nullable IColony colony) {
        this.addAndSearch(world, this.location, colony);
        this.woodBlocks.sort((c1, c2) -> (int)(c1.m_123331_((Vec3i)this.location) - c2.m_123331_((Vec3i)this.location)));
        if (this.getStumpLocations().isEmpty()) {
            this.fillTreeStumps(this.location.m_123342_());
        }
    }

    public void fillTreeStumps(int yLevel) {
        for (BlockPos blockPos : this.woodBlocks) {
            if (blockPos.m_123342_() != yLevel) continue;
            this.stumpLocations.add(blockPos);
        }
        if (this.stumpLocations.size() > 1 && this.sapling.m_150930_(Items.f_220175_)) {
            BlockPos.MutableBlockPos acc = BlockPos.f_121853_.m_122032_();
            for (BlockPos stump : this.stumpLocations) {
                acc = acc.m_122193_((Vec3i)stump);
            }
            BlockPos blockPos = new BlockPos(acc.m_123341_() / this.stumpLocations.size(), acc.m_123342_() / this.stumpLocations.size(), acc.m_123343_() / this.stumpLocations.size());
            this.stumpLocations.clear();
            this.stumpLocations.add(blockPos);
        }
    }

    private void addAndSearch(@NotNull Level world, @NotNull BlockPos log, @Nullable IColony colony) {
        if (this.woodBlocks.size() >= (Integer)MineColonies.getConfig().getServer().maxTreeSize.get()) {
            return;
        }
        if (this.woodBlocks.contains(log)) {
            return;
        }
        if (!this.isBlockPartOfSameTree(world.m_8055_(log), world.m_8055_(this.location))) {
            return;
        }
        if (log.m_123342_() < this.location.m_123342_()) {
            this.location = log;
        }
        if (log.m_123342_() > this.topLog.m_123342_()) {
            this.topLog = log;
        }
        if (colony != null) {
            for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
                if (!building.isInBuilding(log)) continue;
                return;
            }
        }
        this.woodBlocks.add(log);
        if (Compatibility.isDynamicBlock(BlockPosUtil.getBlock(world, log))) {
            return;
        }
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos temp = log.m_7918_(x, y, z);
                    BlockState block = BlockPosUtil.getBlockState(world, temp);
                    if (!block.m_204336_(ModTags.tree) && !Compatibility.isSlimeBlock(block.m_60734_())) continue;
                    this.addAndSearch(world, temp, colony);
                }
            }
        }
    }

    private boolean isBlockPartOfSameTree(@NotNull BlockState existingBlock, @NotNull BlockState newBlock) {
        if (existingBlock.m_204336_(ModTags.mangroveTree)) {
            return newBlock.m_204336_(ModTags.mangroveTree);
        }
        return existingBlock.m_60734_().equals(newBlock.m_60734_());
    }

    private void addAndSearch(@NotNull Level world) {
        int temp;
        int locXMin = this.location.m_123341_() - 4;
        int locXMax = this.location.m_123341_() + 4;
        int locYMin = this.location.m_123342_() + 1;
        int locZMin = this.location.m_123343_() - 4;
        int locZMax = this.location.m_123343_() + 4;
        if (locXMin > locXMax) {
            temp = locXMax;
            locXMax = locXMin;
            locXMin = temp;
        }
        if (locZMin > locZMax) {
            temp = locZMax;
            locZMax = locZMin;
            locZMin = temp;
        }
        for (int locX = locXMin; locX <= locXMax; ++locX) {
            for (int locY = locYMin; locY < world.m_141928_(); ++locY) {
                for (int locZ = locZMin; locZ <= locZMax; ++locZ) {
                    BlockPos leaf = new BlockPos(locX, locY, locZ);
                    BlockState block = world.m_8055_(leaf);
                    if (!block.m_204336_(BlockTags.f_13035_) && !block.m_204336_(ModTags.hugeMushroomBlocks) && !block.m_204336_(BlockTags.f_13078_) && !block.m_60713_(Blocks.f_50701_) || block.m_61145_((Property)LeavesBlock.f_54419_).orElse(false).booleanValue()) continue;
                    this.leaves.add(leaf);
                }
            }
        }
    }

    public BlockPos pollNextLog() {
        return this.woodBlocks.pollLast();
    }

    public ItemStack getSapling() {
        return this.sapling;
    }

    public BlockPos pollNextLeaf() {
        return this.leaves.pollLast();
    }

    public BlockPos peekNextLog() {
        return this.woodBlocks.peekLast();
    }

    public BlockPos peekNextLeaf() {
        return this.leaves.peekLast();
    }

    public boolean hasLeaves() {
        return !this.leaves.isEmpty();
    }

    public boolean hasLogs() {
        return !this.woodBlocks.isEmpty();
    }

    public boolean isSlimeTree() {
        return this.slimeTree;
    }

    public boolean isDynamicTree() {
        return this.dynamicTree;
    }

    public boolean isNetherTree() {
        return this.netherTree;
    }

    @NotNull
    public List<BlockPos> getStumpLocations() {
        return new ArrayList<BlockPos>(this.stumpLocations);
    }

    public void removeStump(BlockPos pos) {
        this.stumpLocations.remove(pos);
    }

    public Property<?> getVariant() {
        return this.variant;
    }

    public BlockPos getLocation() {
        return this.location;
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public boolean equals(@Nullable Object tree) {
        return tree != null && tree.getClass() == this.getClass() && ((Tree)tree).getLocation().equals((Object)this.location);
    }

    public void write(@NotNull CompoundTag compound) {
        if (!this.isTree) {
            return;
        }
        BlockPosUtil.write(compound, "location", this.location);
        @NotNull ListTag logs = new ListTag();
        for (BlockPos blockPos : this.woodBlocks) {
            BlockPosUtil.writeToListNBT(logs, blockPos);
        }
        compound.m_128365_("Logs", (Tag)logs);
        @NotNull ListTag stumps = new ListTag();
        for (BlockPos stump : this.stumpLocations) {
            BlockPosUtil.writeToListNBT(stumps, stump);
        }
        compound.m_128365_("Stumps", (Tag)stumps);
        BlockPosUtil.write(compound, "topLog", this.topLog);
        compound.m_128379_("slimeTree", this.slimeTree);
        compound.m_128379_("dynamicTree", this.dynamicTree);
        CompoundTag compoundTag = new CompoundTag();
        this.sapling.m_41739_(compoundTag);
        compound.m_128365_("treesapling", (Tag)compoundTag);
        compound.m_128379_("netherTree", this.netherTree);
        @NotNull ListTag leavesBin = new ListTag();
        for (BlockPos pos : this.leaves) {
            BlockPosUtil.writeToListNBT(leavesBin, pos);
        }
        compound.m_128365_("leaves", (Tag)leavesBin);
    }

    public boolean isTree() {
        return this.isTree;
    }

    public static boolean checkIfInColony(BlockPos pos, IColony colony, LevelReader world, boolean allowInsideBuilding) {
        if (!colony.getLoadedChunks().contains(ChunkPos.m_151388_((BlockPos)pos))) {
            return false;
        }
        if (allowInsideBuilding || Compatibility.isDynamicBlock(world.m_8055_(pos).m_60734_())) {
            return true;
        }
        for (IBuilding building : colony.getBuildingManager().getBuildings().values()) {
            if (!building.isInBuilding(pos)) continue;
            return false;
        }
        return true;
    }
}

