/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.production;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.ai.workers.util.GuardGear;
import com.minecolonies.api.entity.ai.workers.util.GuardGearBuilder;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.constant.GuardConstants;
import com.minecolonies.api.util.constant.IToolType;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.colony.buildings.modules.ExpeditionLogModule;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.buildings.modules.expedition.ExpeditionLog;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingNetherWorker;
import com.minecolonies.core.colony.jobs.JobNetherWorker;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.items.ItemAdventureToken;
import com.minecolonies.core.util.TeleportHelper;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.PortalShape;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkNether
extends AbstractEntityAICrafting<JobNetherWorker, BuildingNetherWorker> {
    private static final int TICK_DELAY = 40;
    private static final String OBJECTIVE_HUT_LEVEL = "HutLevel";
    private static final String OBJECTIVE_SECONDARY_SKILL = "SecSkillLevel";
    private static final float SECONDARY_DAMAGE_REDUCTION = 0.005f;
    private final Map<EquipmentSlot, ItemStack> virtualEquipmentSlots = new HashMap<EquipmentSlot, ItemStack>();
    final List<ItemStack> netherEdible = IColonyManager.getInstance().getCompatibilityManager().getEdibles(((BuildingNetherWorker)this.building).getBuildingLevel() - 1).stream().map(ItemStorage::getItemStack).collect(Collectors.toList());
    public final List<List<GuardGear>> itemsNeeded = new ArrayList<List<GuardGear>>();

    public EntityAIWorkNether(@NotNull JobNetherWorker job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.NETHER_LEAVE, this::leaveForNether, 40), new AITarget<Object>(AIWorkerState.NETHER_AWAY, this::stayInNether, 40), new AITarget<Object>(AIWorkerState.NETHER_RETURN, this::returnFromNether, 40), new AITarget<Object>(AIWorkerState.NETHER_OPENPORTAL, this::openPortal, 40), new AITarget<Object>(AIWorkerState.NETHER_CLOSEPORTAL, this::closePortal, 40));
        this.worker.m_21553_(true);
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(3, Integer.MAX_VALUE, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(2, 4, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.DIA_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 3, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.IRON_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 2, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.CHAIN_BUILDING_LEVEL_RANGE));
        this.itemsNeeded.add(GuardGearBuilder.buildGearForLevel(0, 1, GuardConstants.LEATHER_BUILDING_LEVEL_RANGE, GuardConstants.GOLD_BUILDING_LEVEL_RANGE));
    }

    @Override
    protected void updateRenderMetaData() {
        StringBuilder renderData = new StringBuilder(this.getState() == AIWorkerState.CRAFT || this.getState() == AIWorkerState.NETHER_LEAVE || this.getState() == AIWorkerState.NETHER_RETURN || this.getState() == AIWorkerState.NETHER_OPENPORTAL || this.getState() == AIWorkerState.NETHER_CLOSEPORTAL ? "working" : "");
        for (int slot = 0; slot < this.worker.getInventoryCitizen().getSlots(); ++slot) {
            ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(slot);
            if (stack.m_41720_() == Items.f_42000_ && renderData.indexOf("torch") == -1) {
                renderData.append("torch");
                continue;
            }
            if (stack.canPerformAction(ToolActions.PICKAXE_DIG) && renderData.indexOf("pickaxe") == -1) {
                renderData.append("pickaxe");
                continue;
            }
            if (!stack.canPerformAction(ToolActions.SHOVEL_DIG) || renderData.indexOf("shovel") != -1) continue;
            renderData.append("shovel");
        }
        this.worker.setRenderMetadata(renderData.toString());
    }

    @Override
    public Class<BuildingNetherWorker> getExpectedBuildingClass() {
        return BuildingNetherWorker.class;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.START_WORKING;
    }

    @Override
    public boolean canBeInterrupted() {
        return !this.worker.m_20145_();
    }

    private void goToVault() {
        this.worker.m_5496_(SoundEvents.f_12288_, this.worker.m_217043_().m_188501_() * 0.5f + 0.25f, 0.25f);
        this.worker.m_6842_(true);
        this.worker.m_20225_(true);
        BlockPos vaultPos = ((BuildingNetherWorker)this.building).getVaultLocation();
        if (vaultPos != null) {
            TeleportHelper.teleportCitizen(this.worker, this.world, vaultPos);
        }
    }

    private void returnFromVault(boolean force) {
        BlockPos vaultPos = ((BuildingNetherWorker)this.building).getVaultLocation();
        BlockPos portalPos = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portalPos != null && vaultPos != null && EntityUtils.isLivingAtSite((LivingEntity)this.worker, vaultPos.m_123341_(), vaultPos.m_123342_(), vaultPos.m_123343_(), 2)) {
            TeleportHelper.teleportCitizen(this.worker, this.world, portalPos);
            this.worker.m_20225_(false);
            this.worker.m_5496_(SoundEvents.f_12288_, this.worker.m_217043_().m_188501_() * 0.5f + 0.25f, 0.25f);
            if (!force) {
                return;
            }
        }
        this.worker.m_6842_(false);
        this.worker.m_20225_(false);
    }

    @Override
    protected IAIState decide() {
        IAIState crafterState;
        if (((JobNetherWorker)this.job).isInNether()) {
            if (!this.worker.m_20145_()) {
                this.goToVault();
            }
            return AIWorkerState.NETHER_AWAY;
        }
        if (this.worker.m_20145_()) {
            this.returnFromVault(true);
        }
        if ((crafterState = super.decide()) != AIWorkerState.IDLE && crafterState != AIWorkerState.START_WORKING) {
            return crafterState;
        }
        this.checkAndRequestArmor();
        IRecipeStorage rs = ((BuildingNetherWorker.CraftingModule)((BuildingNetherWorker)this.building).getFirstModuleOccurance(BuildingNetherWorker.CraftingModule.class)).getFirstRecipe(ItemStack::m_41619_);
        boolean hasItemsAvailable = true;
        if (rs != null) {
            for (ItemStorage item : rs.getInput()) {
                if (this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)item.getItem(), 1), item.getAmount(), item.getAmount())) continue;
                hasItemsAvailable = false;
            }
        }
        if (!hasItemsAvailable) {
            this.setDelay(60);
            return AIWorkerState.IDLE;
        }
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portal == null) {
            Log.getLogger().warn("--- Missing Portal Tag In Nether Worker Building! Aborting Operation! ---");
            this.setDelay(120);
            return AIWorkerState.IDLE;
        }
        this.checkIfRequestForItemExistOrCreate(new StackList(this.getEdiblesList(), "Edible Food", 16));
        boolean missingAxe = this.checkForToolOrWeapon(ToolType.AXE);
        boolean missingPick = this.checkForToolOrWeapon(ToolType.PICKAXE);
        boolean missingShovel = this.checkForToolOrWeapon(ToolType.SHOVEL);
        boolean missingSword = this.checkForToolOrWeapon(ToolType.SWORD);
        boolean missingLighter = this.checkForToolOrWeapon(ToolType.FLINT_N_STEEL);
        if (missingAxe || missingPick || missingShovel || missingSword || missingLighter) {
            this.worker.getCitizenData().setIdleAtJob(true);
            this.setDelay(60);
            return AIWorkerState.IDLE;
        }
        if (this.currentRecipeStorage == null) {
            BlockState block;
            ICraftingBuildingModule module = (ICraftingBuildingModule)((BuildingNetherWorker)this.building).getFirstModuleOccurance(BuildingNetherWorker.CraftingModule.class);
            this.currentRecipeStorage = module.getFirstFulfillableRecipe(ItemStackUtils::isEmpty, 1, false);
            if (((BuildingNetherWorker)this.building).isReadyForTrip()) {
                this.worker.getCitizenData().setIdleAtJob(true);
            }
            if (this.currentRecipeStorage == null && ((BuildingNetherWorker)this.building).shallClosePortalOnReturn() && (block = this.world.m_8055_(portal)).m_60713_(Blocks.f_50142_)) {
                return AIWorkerState.NETHER_CLOSEPORTAL;
            }
            return this.getState();
        }
        if (!((BuildingNetherWorker)this.building).isReadyForTrip()) {
            this.worker.getCitizenData().setIdleAtJob(false);
            this.setDelay(120);
            return AIWorkerState.IDLE;
        }
        if (this.walkTo != null || this.walkToBuilding()) {
            return this.getState();
        }
        if (InventoryUtils.isItemHandlerFull((IItemHandler)this.worker.getInventoryCitizen())) {
            return AIWorkerState.INVENTORY_FULL;
        }
        IAIState checkResult = this.checkForItems(this.currentRecipeStorage);
        if (checkResult == AIWorkerState.GET_RECIPE) {
            this.currentRecipeStorage = null;
            this.worker.getCitizenData().setIdleAtJob(true);
            this.setDelay(60);
            return AIWorkerState.IDLE;
        }
        if (checkResult != AIWorkerState.CRAFT) {
            return checkResult;
        }
        return AIWorkerState.NETHER_LEAVE;
    }

    protected IAIState leaveForNether() {
        if (InventoryUtils.isItemHandlerFull((IItemHandler)this.worker.getInventoryCitizen())) {
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRecipeStorage == null) {
            ((JobNetherWorker)this.job).setInNether(false);
            this.worker.getCitizenData().setIdleAtJob(true);
            return AIWorkerState.IDLE;
        }
        if (!this.world.m_6188_().m_83459_(OBJECTIVE_HUT_LEVEL)) {
            this.world.m_6188_().m_83436_(OBJECTIVE_HUT_LEVEL, ObjectiveCriteria.f_83588_, (Component)Component.m_237113_((String)"Worker Building Level"), ObjectiveCriteria.RenderType.INTEGER);
        }
        if (!this.world.m_6188_().m_83459_(OBJECTIVE_SECONDARY_SKILL)) {
            this.world.m_6188_().m_83436_(OBJECTIVE_SECONDARY_SKILL, ObjectiveCriteria.f_83588_, (Component)Component.m_237113_((String)"Worker Secondary Skill Level"), ObjectiveCriteria.RenderType.INTEGER);
        }
        Objective hutLevelObjective = this.world.m_6188_().m_83477_(OBJECTIVE_HUT_LEVEL);
        Objective secondarySkillLevelObjective = this.world.m_6188_().m_83477_(OBJECTIVE_SECONDARY_SKILL);
        Score s = this.world.m_6188_().m_83471_(this.worker.m_6302_(), hutLevelObjective);
        s.m_83402_(((BuildingNetherWorker)this.building).getBuildingLevel());
        s = this.world.m_6188_().m_83471_(this.worker.m_6302_(), secondarySkillLevelObjective);
        s.m_83402_(this.getSecondarySkillLevel());
        ExpeditionLog expeditionLog = ((ExpeditionLogModule)((BuildingNetherWorker)this.building).getFirstModuleOccurance(ExpeditionLogModule.class)).getLog();
        expeditionLog.reset();
        expeditionLog.setStatus(ExpeditionLog.Status.STARTING);
        expeditionLog.setCitizen(this.worker);
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portal != null && this.currentRecipeStorage != null) {
            BlockState block = this.world.m_8055_(portal);
            if (block.m_60713_(Blocks.f_50142_)) {
                if (this.walkToBlock(portal, 1)) {
                    return this.getState();
                }
                this.goToVault();
                ((BuildingNetherWorker)this.building).recordTrip();
                ((JobNetherWorker)this.job).setInNether(true);
                expeditionLog.setStatus(ExpeditionLog.Status.IN_PROGRESS);
                this.logAllEquipment(expeditionLog, false);
                List<ItemStack> result = this.currentRecipeStorage.fullfillRecipeAndCopy(this.getLootContext(), (List<IItemHandler>)ImmutableList.of((Object)this.worker.getItemHandlerCitizen()), false);
                if (result != null) {
                    result = new ArrayList<ItemStack>(result);
                    Collections.shuffle(result, this.worker.getCitizenData().getRandom());
                    ((JobNetherWorker)this.job).addCraftedResultsList(result);
                }
                this.worker.getCitizenData().setIdleAtJob(false);
                return AIWorkerState.NETHER_AWAY;
            }
            return AIWorkerState.NETHER_OPENPORTAL;
        }
        this.worker.getCitizenData().setIdleAtJob(true);
        return AIWorkerState.IDLE;
    }

    protected IAIState stayInNether() {
        if (((BuildingNetherWorker)this.building).getVaultLocation() == null) {
            BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
            if (portal != null && this.walkToBlock(portal, 1)) {
                return this.getState();
            }
            if (!this.worker.m_20145_()) {
                this.worker.m_6842_(true);
            }
        }
        ExpeditionLog expeditionLog = ((ExpeditionLogModule)((BuildingNetherWorker)this.building).getFirstModuleOccurance(ExpeditionLogModule.class)).getLog();
        if (!((JobNetherWorker)this.job).getCraftedResults().isEmpty()) {
            ItemStack currStack = ((JobNetherWorker)this.job).getCraftedResults().poll();
            if (currStack.m_41720_() instanceof ItemAdventureToken) {
                if (currStack.m_41782_()) {
                    CompoundTag tag = currStack.m_41783_();
                    if (tag.m_128441_("damage-done")) {
                        this.equipArmor(true);
                        this.worker.m_8061_(EquipmentSlot.MAINHAND, this.findTool(ToolType.SWORD));
                        DamageSource source = this.world.m_269111_().m_269079_(DamageSourceKeys.NETHER);
                        EntityType mobType = EntityType.f_20501_;
                        if (tag.m_128441_("entity-type")) {
                            mobType = EntityType.m_20632_((String)tag.m_128461_("entity-type")).orElse(EntityType.f_20501_);
                        }
                        LivingEntity mob = (LivingEntity)mobType.m_20615_(this.world);
                        float mobHealth = mob.m_21223_();
                        float incomingDamage = tag.m_128457_("damage-done");
                        incomingDamage -= incomingDamage * ((float)this.getSecondarySkillLevel() * 0.005f);
                        int hit = 0;
                        while (mobHealth > 0.0f && !this.worker.m_21224_()) {
                            this.worker.f_20916_ = 0;
                            this.worker.f_19802_ = 0;
                            float damageToDo = 3.0f;
                            boolean doDamage = this.worker.m_217043_().m_188499_();
                            boolean takeDamage = this.worker.m_217043_().m_188499_();
                            ItemStack sword = this.worker.m_6844_(EquipmentSlot.MAINHAND);
                            if (!sword.m_41619_()) {
                                damageToDo = sword.m_41720_() instanceof SwordItem ? (damageToDo += ((SwordItem)sword.m_41720_()).m_43299_()) : (float)((double)damageToDo + TinkersToolHelper.getDamage(sword));
                                damageToDo = (float)((double)damageToDo + (double)EnchantmentHelper.m_44833_((ItemStack)sword, (MobType)mob.m_6336_()) / 2.5);
                                if (doDamage) {
                                    sword.m_41622_(1, (LivingEntity)this.worker, entity -> this.worker.m_8061_(EquipmentSlot.MAINHAND, this.findTool(ToolType.SWORD)));
                                }
                            }
                            if (doDamage) {
                                mobHealth -= damageToDo;
                            }
                            if (takeDamage && !this.worker.m_6469_(source, incomingDamage)) {
                                incomingDamage = this.worker.calculateDamageAfterAbsorbs(source, incomingDamage);
                                this.worker.m_21153_(this.worker.m_21223_() - incomingDamage);
                            }
                            if (hit % 2 == 0) {
                                float healAmount = this.checkHeal(this.worker);
                                float saturationFactor = 0.25f;
                                if (healAmount > 0.0f) {
                                    this.worker.m_5634_(healAmount);
                                    this.worker.getCitizenData().decreaseSaturation(healAmount * 0.25f);
                                }
                            } else if (this.worker.getCitizenData().getSaturation() < 10.0) {
                                this.attemptToEat();
                            }
                            ++hit;
                        }
                        expeditionLog.setCitizen(this.worker);
                        this.logAllEquipment(expeditionLog, true);
                        if (this.worker.m_21224_()) {
                            expeditionLog.setKilled();
                            InventoryUtils.clearItemHandler(this.worker.getItemHandlerCitizen());
                            ((JobNetherWorker)this.job).getCraftedResults().clear();
                            ((JobNetherWorker)this.job).getProcessedResults().clear();
                            return AIWorkerState.IDLE;
                        }
                        LootParams context = this.getLootContext();
                        LootTable loot = this.world.m_7654_().m_278653_().m_278676_(mob.m_5743_());
                        ObjectArrayList mobLoot = loot.m_287195_(context);
                        ((JobNetherWorker)this.job).addProcessedResultsList((Collection<ItemStack>)mobLoot);
                        expeditionLog.addMob(mobType);
                        expeditionLog.addLoot((List<ItemStack>)mobLoot);
                        this.worker.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                        this.equipArmor(false);
                    }
                    if (currStack.m_41783_().m_128441_("xp-dropped")) {
                        this.worker.getCitizenExperienceHandler().addExperience(this.worker.getCitizenItemHandler().applyMending(currStack.m_41783_().m_128451_("xp-dropped")));
                    }
                }
            } else if (!currStack.m_41619_()) {
                int itemDelay = 0;
                Item mobType = currStack.m_41720_();
                if (mobType instanceof BlockItem) {
                    BlockItem bi = (BlockItem)mobType;
                    Block block = bi.m_40614_();
                    ItemStack tool = this.findTool(block.m_49966_(), this.worker.m_20183_());
                    if (tool.m_41720_() instanceof TieredItem) {
                        this.worker.m_8061_(EquipmentSlot.MAINHAND, tool);
                        for (int i = 0; i < currStack.m_41613_() && !tool.m_41619_(); ++i) {
                            LootParams context = this.getLootContext();
                            LootTable loot = this.world.m_7654_().m_278653_().m_278676_(block.m_60589_());
                            ObjectArrayList mobLoot = loot.m_287195_(context);
                            ((JobNetherWorker)this.job).addProcessedResultsList((Collection<ItemStack>)mobLoot);
                            expeditionLog.addLoot((List<ItemStack>)mobLoot);
                            tool.m_41622_(1, (LivingEntity)this.worker, entity -> {});
                            if (tool.m_41619_()) {
                                tool = this.findTool(block.m_49966_(), this.worker.m_20183_());
                                this.worker.m_8061_(EquipmentSlot.MAINHAND, tool);
                            }
                            this.worker.getCitizenExperienceHandler().addExperience(this.worker.getCitizenItemHandler().applyMending(this.xpOnDrop(block)));
                            itemDelay += 40;
                        }
                        this.worker.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                        this.logAllEquipment(expeditionLog, false);
                    } else {
                        itemDelay = 40;
                    }
                } else {
                    ((JobNetherWorker)this.job).addProcessedResultsList((Collection<ItemStack>)ImmutableList.of((Object)currStack));
                    expeditionLog.addLoot(Collections.singletonList(currStack));
                    itemDelay = 40 * currStack.m_41613_();
                }
                this.setDelay(itemDelay);
            }
            return this.getState();
        }
        if (!((JobNetherWorker)this.job).getProcessedResults().isEmpty()) {
            if (!this.worker.m_21224_()) {
                expeditionLog.setStatus(ExpeditionLog.Status.RETURNING_HOME);
                ItemStack item = ((JobNetherWorker)this.job).getProcessedResults().poll();
                if (InventoryUtils.addItemStackToItemHandler(this.worker.getItemHandlerCitizen(), item)) {
                    this.worker.decreaseSaturationForContinuousAction();
                    this.worker.getCitizenExperienceHandler().addExperience(0.2);
                }
            } else {
                ((JobNetherWorker)this.job).getProcessedResults().clear();
            }
            return this.getState();
        }
        expeditionLog.setStatus(ExpeditionLog.Status.COMPLETED);
        return AIWorkerState.NETHER_RETURN;
    }

    private int xpOnDrop(Block block) {
        RandomSource rnd = this.worker.m_217043_();
        if (block == Blocks.f_49997_) {
            return rnd.m_216339_(0, 2);
        }
        if (block == Blocks.f_50089_) {
            return rnd.m_216339_(3, 7);
        }
        if (block == Blocks.f_50264_) {
            return rnd.m_216339_(3, 7);
        }
        if (block == Blocks.f_50059_) {
            return rnd.m_216339_(2, 5);
        }
        if (block == Blocks.f_50331_) {
            return rnd.m_216339_(2, 5);
        }
        return block == Blocks.f_49998_ ? rnd.m_216339_(0, 1) : 0;
    }

    protected IAIState returnFromNether() {
        if (this.worker.m_20145_()) {
            this.returnFromVault(false);
            return this.getState();
        }
        if (((BuildingNetherWorker)this.building).shallClosePortalOnReturn() && this.world.m_8055_(((BuildingNetherWorker)this.building).getPortalLocation()).m_60713_(Blocks.f_50142_)) {
            return AIWorkerState.NETHER_CLOSEPORTAL;
        }
        if (this.walkToBuilding()) {
            return this.getState();
        }
        this.worker.getCitizenData().setIdleAtJob(true);
        ((JobNetherWorker)this.job).setInNether(false);
        this.currentRecipeStorage = null;
        return AIWorkerState.INVENTORY_FULL;
    }

    protected IAIState openPortal() {
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        if (portal != null && this.currentRecipeStorage != null) {
            if (this.walkToBlock(portal, 1)) {
                return this.getState();
            }
            BlockState block = this.world.m_8055_(portal);
            Optional ps = PortalShape.m_77712_((LevelAccessor)this.world, (BlockPos)portal, p -> p.m_77698_(), (Direction.Axis)Direction.Axis.X);
            if (!ps.isPresent()) {
                return AIWorkerState.IDLE;
            }
            if (!block.m_60713_(Blocks.f_50142_)) {
                this.useFlintAndSteel();
                ((PortalShape)ps.get()).m_77743_();
                return AIWorkerState.NETHER_LEAVE;
            }
        }
        return AIWorkerState.START_WORKING;
    }

    protected IAIState closePortal() {
        BlockPos portal = ((BuildingNetherWorker)this.building).getPortalLocation();
        BlockState block = this.world.m_8055_(portal);
        if (block.m_60713_(Blocks.f_50142_)) {
            if (this.walkToBlock(portal, 1)) {
                return this.getState();
            }
            this.useFlintAndSteel();
            this.world.m_46597_(((BuildingNetherWorker)this.building).getPortalLocation(), Blocks.f_50016_.m_49966_());
        }
        if (((JobNetherWorker)this.job).isInNether()) {
            return AIWorkerState.NETHER_RETURN;
        }
        this.currentRecipeStorage = null;
        return AIWorkerState.INVENTORY_FULL;
    }

    private void useFlintAndSteel() {
        ItemStack tool = this.findTool(ToolType.FLINT_N_STEEL);
        tool.m_41622_(1, (LivingEntity)this.worker, entity -> {});
    }

    private ItemStack findItem(@NotNull Predicate<ItemStack> predicate) {
        int slotOfStack = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(this.worker.getItemHandlerCitizen(), predicate);
        return slotOfStack < 0 ? ItemStack.f_41583_ : this.worker.getInventoryCitizen().getStackInSlot(slotOfStack);
    }

    private ItemStack findTool(@NotNull IToolType tool) {
        return this.findItem(stack -> ItemStackUtils.hasToolLevel(stack, tool, 0, ((BuildingNetherWorker)this.building).getMaxToolLevel()));
    }

    private ItemStack findTool(@NotNull BlockState target, BlockPos pos) {
        int slotOfStack = this.getMostEfficientTool(target, pos);
        return slotOfStack < 0 ? ItemStack.f_41583_ : this.worker.getInventoryCitizen().getStackInSlot(slotOfStack);
    }

    private void setEquipSlot(EquipmentSlot equipSlot, boolean equip) {
        if (equip) {
            for (List<GuardGear> itemList : this.itemsNeeded) {
                for (GuardGear item : itemList) {
                    int toBeEquipped;
                    if (!item.getType().equals((Object)equipSlot) || ((BuildingNetherWorker)this.building).getBuildingLevel() < item.getMinBuildingLevelRequired() || ((BuildingNetherWorker)this.building).getBuildingLevel() > item.getMaxBuildingLevelRequired() || item.test(this.worker.getInventoryCitizen().getArmorInSlot(item.getType())) || (toBeEquipped = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith(this.worker.getItemHandlerCitizen(), item)) <= -1) continue;
                    ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(toBeEquipped);
                    this.worker.getInventoryCitizen().transferArmorToSlot(item.getType(), toBeEquipped);
                    this.virtualEquipmentSlots.put(item.getType(), stack);
                }
            }
        } else {
            this.worker.getInventoryCitizen().moveArmorToInventory(equipSlot);
            this.virtualEquipmentSlots.put(equipSlot, ItemStack.f_41583_);
        }
    }

    private void equipArmor(boolean equip) {
        this.setEquipSlot(EquipmentSlot.HEAD, equip);
        this.setEquipSlot(EquipmentSlot.CHEST, equip);
        this.setEquipSlot(EquipmentSlot.LEGS, equip);
        this.setEquipSlot(EquipmentSlot.FEET, equip);
    }

    private void logAllEquipment(@NotNull ExpeditionLog expeditionLog, boolean alreadyEquipped) {
        if (!alreadyEquipped) {
            this.equipArmor(true);
        }
        StackList edible = new StackList(this.getEdiblesList(), "Edible Food", 1);
        ArrayList<ItemStack> equipment = new ArrayList<ItemStack>();
        equipment.add(this.findTool(ToolType.SWORD));
        equipment.add(this.worker.getInventoryCitizen().getArmorInSlot(EquipmentSlot.HEAD));
        equipment.add(this.worker.getInventoryCitizen().getArmorInSlot(EquipmentSlot.CHEST));
        equipment.add(this.worker.getInventoryCitizen().getArmorInSlot(EquipmentSlot.LEGS));
        equipment.add(this.worker.getInventoryCitizen().getArmorInSlot(EquipmentSlot.FEET));
        equipment.add(this.findTool(ToolType.PICKAXE));
        equipment.add(this.findTool(ToolType.AXE));
        equipment.add(this.findTool(ToolType.SHOVEL));
        equipment.add(this.findItem(edible::matches));
        expeditionLog.setEquipment(equipment);
        if (!alreadyEquipped) {
            this.equipArmor(false);
        }
    }

    private List<ItemStack> getEdiblesList() {
        ImmutableList<ItemStorage> allowedItems = ((ItemListModule)((BuildingNetherWorker)this.building).getModuleMatching(ItemListModule.class, m -> m.getId().equals("food"))).getList();
        this.netherEdible.removeIf(item -> allowedItems.contains(new ItemStorage((ItemStack)item)));
        return this.netherEdible;
    }

    protected void attemptToEat() {
        StackList edible = new StackList(this.getEdiblesList(), "Edible Food", 1);
        int slot = InventoryUtils.findFirstSlotInProviderNotEmptyWith((ICapabilityProvider)this.worker, edible::matches);
        ICitizenData citizenData = this.worker.getCitizenData();
        if (slot > -1) {
            ItemStack stack = this.worker.getInventoryCitizen().getStackInSlot(slot);
            ItemStackUtils.consumeFood(stack, this.worker, null);
        }
    }

    protected void checkAndRequestArmor() {
        for (List<GuardGear> itemList : this.itemsNeeded) {
            for (GuardGear item : itemList) {
                int slot;
                if (((BuildingNetherWorker)this.building).getBuildingLevel() < item.getMinBuildingLevelRequired() || ((BuildingNetherWorker)this.building).getBuildingLevel() > item.getMaxBuildingLevelRequired()) continue;
                int bestSlot = -1;
                int bestLevel = -1;
                IItemHandler bestHandler = null;
                if (this.virtualEquipmentSlots.containsKey(item.getType()) && !ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType()))) {
                    bestLevel = ItemStackUtils.getMiningLevel(this.virtualEquipmentSlots.get(item.getType()), item.getItemNeeded());
                } else {
                    ItemStack invItem = this.findItem(item::test);
                    if (!invItem.m_41619_()) {
                        if (!this.virtualEquipmentSlots.containsKey(item.getType()) || ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType()))) {
                            this.virtualEquipmentSlots.put(item.getType(), invItem);
                            bestLevel = ItemStackUtils.getMiningLevel(invItem, item.getItemNeeded());
                        }
                    } else {
                        this.virtualEquipmentSlots.put(item.getType(), ItemStack.f_41583_);
                    }
                }
                Map<IItemHandler, List<Integer>> items = InventoryUtils.findAllSlotsInProviderWith(this.building, item::test);
                if (items.isEmpty()) {
                    if (ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType()))) {
                        this.checkForToolOrWeaponAsync(item.getItemNeeded(), item.getMinArmorLevel(), item.getMaxArmorLevel());
                    }
                } else {
                    for (Map.Entry<IItemHandler, List<Integer>> entry : items.entrySet()) {
                        for (Integer slot2 : entry.getValue()) {
                            int currentLevel;
                            ItemStack stack2 = entry.getKey().getStackInSlot(slot2.intValue());
                            if (ItemStackUtils.isEmpty(stack2) || (currentLevel = ItemStackUtils.getMiningLevel(stack2, item.getItemNeeded())) <= bestLevel) continue;
                            bestLevel = currentLevel;
                            bestSlot = slot2;
                            bestHandler = entry.getKey();
                        }
                    }
                }
                if (bestHandler == null) continue;
                if (!ItemStackUtils.isEmpty(this.virtualEquipmentSlots.get(item.getType())) && (slot = InventoryUtils.findFirstSlotInItemHandlerNotEmptyWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> stack == this.virtualEquipmentSlots.get(item.getType()))) > -1) {
                    InventoryUtils.transferItemStackIntoNextFreeSlotInProvider((IItemHandler)this.worker.getInventoryCitizen(), slot, this.building);
                }
                this.virtualEquipmentSlots.put(item.getType(), bestHandler.getStackInSlot(bestSlot));
                InventoryUtils.transferItemStackIntoNextFreeSlotInItemHandler(bestHandler, bestSlot, (IItemHandler)this.worker.getInventoryCitizen());
            }
        }
    }

    private float checkHeal(AbstractEntityCitizen citizen) {
        ICitizenData citizenData = citizen.getCitizenData();
        double healAmount = 0.0;
        if (citizen.m_21223_() < citizen.m_21233_()) {
            double limitDecrease = citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SATLIMIT);
            if (citizenData.getSaturation() >= 20.0 + limitDecrease) {
                healAmount = 2.0 * (1.0 + citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION));
            } else {
                if (citizenData.getSaturation() < 6.0) {
                    return (float)healAmount;
                }
                healAmount = 1.0 * (1.0 + citizen.getCitizenColonyHandler().getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.REGENERATION));
            }
            citizen.m_5634_((float)healAmount);
        }
        return (float)healAmount;
    }
}

