/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard.training;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingArchery;
import com.minecolonies.core.colony.jobs.JobArcherTraining;
import com.minecolonies.core.entity.ai.workers.guard.training.AbstractEntityAITraining;
import com.minecolonies.core.util.WorkerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIArcherTraining
extends AbstractEntityAITraining<JobArcherTraining, BuildingArchery> {
    private static final int XP_PER_SUCCESSFUL_SHOT = 1;
    private static final int BUILDING_LEVEL_TARGET_MULTIPLIER = 5;
    private static final double MIN_DISTANCE_FOR_SUCCESS = 2.0;
    private static final int RANGED_ATTACK_DELAY_BASE = 10;
    private static final double XP_BASE_RATE = 0.2;
    private static final int CHECK_SHOT_DELAY = 60;
    private static final VisibleCitizenStatus ARCHER_TRAIN = new VisibleCitizenStatus(new ResourceLocation("minecolonies", "textures/icons/work/archer_uni.png"), "com.minecolonies.gui.visiblestatus.archer_uni");
    private BlockPos currentShootingTarget;
    private int targetCounter;
    private Arrow arrowInProgress;

    public EntityAIArcherTraining(@NotNull JobArcherTraining job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.COMBAT_TRAINING, this::findShootingStandPosition, 5), new AITarget<Object>(AIWorkerState.ARCHER_SELECT_TARGET, this::selectTarget, 5), new AITarget<Object>(AIWorkerState.ARCHER_CHECK_SHOT, this::checkShot, 60), new AITarget<Object>(AIWorkerState.ARCHER_SHOOT, this::shoot, 5));
    }

    private IAIState selectTarget() {
        BuildingArchery archeryBuilding = (BuildingArchery)this.building;
        if (this.targetCounter >= archeryBuilding.getBuildingLevel() * 5) {
            this.targetCounter = 0;
            return AIWorkerState.DECIDE;
        }
        BlockPos targetPos = archeryBuilding.getRandomShootingTarget(this.worker.m_217043_());
        if (targetPos == null || !WorldUtil.isBlockLoaded((LevelAccessor)this.world, targetPos) || !this.world.m_45547_(new ClipContext(new Vec3(this.worker.m_20185_(), this.worker.m_20188_(), this.worker.m_20189_()), new Vec3((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.worker)).m_82425_().equals((Object)targetPos)) {
            return AIWorkerState.DECIDE;
        }
        this.worker.getCitizenData().setVisibleStatus(ARCHER_TRAIN);
        this.currentShootingTarget = targetPos;
        ++this.targetCounter;
        return AIWorkerState.ARCHER_SHOOT;
    }

    private IAIState findShootingStandPosition() {
        BuildingArchery archeryBuilding = (BuildingArchery)this.building;
        BlockPos shootingPos = archeryBuilding.getRandomShootingStandPosition(this.worker.m_217043_());
        if (shootingPos == null) {
            return AIWorkerState.DECIDE;
        }
        this.stateAfterPathing = AIWorkerState.ARCHER_SELECT_TARGET;
        this.currentPathingTarget = shootingPos;
        return AIWorkerState.GO_TO_TARGET;
    }

    protected IAIState shoot() {
        Arrow arrow;
        if (this.currentShootingTarget == null || !this.isSetup()) {
            this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
            return AIWorkerState.START_WORKING;
        }
        if (this.worker.m_6117_()) {
            WorkerUtil.faceBlock(this.currentShootingTarget, this.worker);
            this.worker.m_6674_(InteractionHand.MAIN_HAND);
            arrow = (Arrow)ModEntities.MC_NORMAL_ARROW.m_20615_(this.world);
            arrow.m_36781_(0.0);
            arrow.m_5602_((Entity)this.worker);
            arrow.m_6034_(this.worker.m_20185_(), this.worker.m_20186_() + 1.0, this.worker.m_20189_());
            double xVector = (double)this.currentShootingTarget.m_123341_() - this.worker.m_20185_();
            double yVector = (double)this.currentShootingTarget.m_123342_() - arrow.m_20186_();
            double zVector = (double)this.currentShootingTarget.m_123343_() - this.worker.m_20189_();
            double distance = Mth.m_14116_((float)((float)(xVector * xVector + zVector * zVector)));
            double chance = 15.0 / ((double)this.getPrimarySkillLevel() / 2.0 + 1.0);
            arrow.m_6686_(xVector, yVector + distance * (double)0.2f, zVector, 1.6f, (float)chance);
            this.worker.m_5496_(SoundEvents.f_12382_, 1.0f, (float)SoundUtils.getRandomPitch(this.worker.m_217043_()));
            this.worker.f_19853_.m_7967_((Entity)arrow);
            double xDiff = (double)this.currentShootingTarget.m_123341_() - this.worker.m_20185_();
            double zDiff = (double)this.currentShootingTarget.m_123343_() - this.worker.m_20189_();
            double goToX = xDiff > 0.0 ? 0.01 : -0.01;
            double goToZ = zDiff > 0.0 ? 0.01 : -0.01;
            this.worker.m_6478_(MoverType.SELF, new Vec3(goToX, 0.0, goToZ));
            if (this.worker.m_217043_().m_188499_()) {
                this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
            }
        } else {
            this.reduceAttackDelay();
            if (this.currentAttackDelay <= 0) {
                this.worker.m_6672_(InteractionHand.MAIN_HAND);
            }
            return AIWorkerState.ARCHER_SHOOT;
        }
        this.worker.m_5810_();
        this.incrementActionsDoneAndDecSaturation();
        this.arrowInProgress = arrow;
        this.currentAttackDelay = 10;
        return AIWorkerState.ARCHER_CHECK_SHOT;
    }

    private IAIState checkShot() {
        Vec3 vec3 = new Vec3((double)this.currentShootingTarget.m_123341_(), (double)this.currentShootingTarget.m_123342_(), (double)this.currentShootingTarget.m_123343_());
        if (this.arrowInProgress.m_20238_(vec3) < 2.0) {
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
        } else {
            this.worker.getCitizenExperienceHandler().addExperience(0.2);
        }
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        return AIWorkerState.ARCHER_SELECT_TARGET;
    }

    @Override
    protected boolean isSetup() {
        if (this.checkForToolOrWeapon(ToolType.BOW)) {
            this.setDelay(60);
            return false;
        }
        int bowSlot = InventoryUtils.getFirstSlotOfItemHandlerContainingTool((IItemHandler)this.getInventory(), ToolType.BOW, 0, ((BuildingArchery)this.building).getMaxToolLevel());
        this.worker.getCitizenItemHandler().setHeldItem(InteractionHand.MAIN_HAND, bowSlot);
        return true;
    }

    @Override
    public Class<BuildingArchery> getExpectedBuildingClass() {
        return BuildingArchery.class;
    }
}

