/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.crafting;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.VisibleCitizenStatus;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.core.Network;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.CraftingWorkerBuildingModule;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.entity.ai.workers.AbstractEntityAIInteract;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.network.messages.client.BlockParticleEffectMessage;
import com.minecolonies.core.network.messages.client.LocalizedParticleEffectMessage;
import com.minecolonies.core.util.WorkerUtil;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEntityAICrafting<J extends AbstractJobCrafter<?, J>, B extends AbstractBuilding>
extends AbstractEntityAIInteract<J, B> {
    protected static final int HIT_DELAY = 10;
    public static final int PROGRESS_MULTIPLIER = 10;
    protected static final int MAX_LEVEL = 50;
    private static final int HITTING_TIME = 3;
    public IRequest<? extends PublicCrafting> currentRequest;
    protected IRecipeStorage currentRecipeStorage;
    private DamageSource playerDamageSource;
    private boolean dumped = false;

    protected int getActionRewardForCraftingSuccess() {
        return 1;
    }

    public AbstractEntityAICrafting(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.IDLE, () -> AIWorkerState.START_WORKING, 1), new AITarget<Object>(AIWorkerState.START_WORKING, this::decide, 5), new AITarget<Object>(AIWorkerState.QUERY_ITEMS, this::queryItems, 5), new AITarget<Object>(AIWorkerState.GET_RECIPE, this::getRecipe, 5), new AITarget<Object>(AIWorkerState.CRAFT, this::craft, 10));
        this.worker.m_21553_(true);
    }

    @Override
    protected void updateRenderMetaData() {
        this.worker.setRenderMetadata(this.getState() == AIWorkerState.CRAFT ? "working" : "");
    }

    protected IAIState decide() {
        this.worker.getCitizenData().setVisibleStatus(VisibleCitizenStatus.WORKING);
        if (((AbstractJobCrafter)this.job).getTaskQueue().isEmpty()) {
            if (this.worker.getNavigation().m_26571_()) {
                if (this.building.isInBuilding(this.worker.m_20183_()) && ColonyConstants.rand.nextInt(20) != 0) {
                    this.setDelay(400);
                    this.worker.getNavigation().moveToRandomPos(10, 0.6, this.building.getCorners());
                } else {
                    this.walkToBuilding();
                }
            }
            return AIWorkerState.IDLE;
        }
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return AIWorkerState.IDLE;
        }
        if (this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getActionsDone() >= this.getActionsDoneUntilDumping()) {
            return this.getState();
        }
        return this.getNextCraftingState();
    }

    protected IAIState getNextCraftingState() {
        if (((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return this.getState();
        }
        if (this.currentRecipeStorage != null && !this.dumped && WorkerUtil.hasTooManyExternalItemsInInv(this.currentRecipeStorage, this.worker.getInventoryCitizen())) {
            this.dumped = true;
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRequest != null && this.currentRecipeStorage != null) {
            return AIWorkerState.QUERY_ITEMS;
        }
        return AIWorkerState.GET_RECIPE;
    }

    protected IAIState getRecipe() {
        IRequest currentTask = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (currentTask == null) {
            return AIWorkerState.START_WORKING;
        }
        ICraftingBuildingModule module = this.building.getCraftingModuleForRecipe(((PublicCrafting)currentTask.getRequest()).getRecipeID());
        if (module == null) {
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        this.currentRecipeStorage = module.getFirstFulfillableRecipe(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, ((PublicCrafting)currentTask.getRequest()).getStack()), 1, false);
        if (this.currentRecipeStorage == null) {
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        if (!this.dumped && WorkerUtil.hasTooManyExternalItemsInInv(this.currentRecipeStorage, this.worker.getInventoryCitizen())) {
            this.dumped = true;
            this.currentRecipeStorage = null;
            return AIWorkerState.INVENTORY_FULL;
        }
        if (this.currentRecipeStorage.getRequiredTool() != ToolType.NONE && this.checkForToolOrWeapon(this.currentRecipeStorage.getRequiredTool())) {
            this.currentRecipeStorage = null;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        this.currentRequest = currentTask;
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(this.currentRequest.getRequest().getCount());
        int currentCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack, this.currentRecipeStorage.getPrimaryOutput()));
        int inProgressCount = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
        int countPerIteration = this.currentRecipeStorage.getPrimaryOutput().m_41613_();
        int doneOpsCount = currentCount / countPerIteration;
        int progressOpsCount = inProgressCount / countPerIteration;
        int remainingOpsCount = this.currentRequest.getRequest().getCount() - doneOpsCount - progressOpsCount;
        List<ItemStorage> input = this.currentRecipeStorage.getCleanedInput();
        for (ItemStorage inputStorage : input) {
            ItemStack container = inputStorage.getItemStack().getCraftingRemainingItem();
            int remaining = !this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs().isEmpty() && ItemStackUtils.compareItemStackListIgnoreStackSize(this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs(), inputStorage.getItemStack(), false, true) ? inputStorage.getAmount() : (!ItemStackUtils.isEmpty(container) && ItemStackUtils.compareItemStacksIgnoreStackSize(inputStorage.getItemStack(), container, false, true) ? inputStorage.getAmount() : inputStorage.getAmount() * remainingOpsCount);
            if (InventoryUtils.getCountFromBuilding((IBuilding)this.building, itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, inputStorage.getItemStack(), false, true)) + InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), itemStack -> ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, inputStorage.getItemStack(), false, true)) + this.getExtendedCount(inputStorage.getItemStack()) >= remaining) continue;
            this.currentRecipeStorage = null;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            return AIWorkerState.START_WORKING;
        }
        ((AbstractJobCrafter)this.job).setCraftCounter(doneOpsCount);
        return AIWorkerState.QUERY_ITEMS;
    }

    protected int getExtendedCount(ItemStack stack) {
        return 0;
    }

    @Override
    public IAIState getStateAfterPickUp() {
        return AIWorkerState.GET_RECIPE;
    }

    private IAIState queryItems() {
        if (this.currentRecipeStorage == null) {
            return AIWorkerState.START_WORKING;
        }
        return this.checkForItems(this.currentRecipeStorage);
    }

    protected IAIState checkForItems(@NotNull IRecipeStorage storage) {
        int inProgressCount = this.getExtendedCount(this.currentRecipeStorage.getPrimaryOutput());
        int countPerIteration = this.currentRecipeStorage.getPrimaryOutput().m_41613_();
        int progressOpsCount = inProgressCount / Math.max(countPerIteration, 1);
        List<ItemStorage> input = storage.getCleanedInput();
        for (ItemStorage inputStorage : input) {
            Predicate<ItemStack> predicate = stack -> !ItemStackUtils.isEmpty(stack) && new Stack((ItemStack)stack, false).matches(inputStorage.getItemStack());
            int invCount = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), predicate);
            ItemStack container = inputStorage.getItemStack().getCraftingRemainingItem();
            int remaining = !this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs().isEmpty() && ItemStackUtils.compareItemStackListIgnoreStackSize(this.currentRecipeStorage.getCraftingToolsAndSecondaryOutputs(), inputStorage.getItemStack(), false, true) ? inputStorage.getAmount() : (!ItemStackUtils.isEmpty(container) && ItemStackUtils.compareItemStacksIgnoreStackSize(inputStorage.getItemStack(), container, false, true) ? inputStorage.getAmount() : inputStorage.getAmount() * Math.max(((AbstractJobCrafter)this.job).getMaxCraftingCount(), 1));
            if (invCount + inProgressCount > 0 && invCount + (((AbstractJobCrafter)this.job).getCraftCounter() + progressOpsCount) * inputStorage.getAmount() >= remaining) continue;
            if (InventoryUtils.hasItemInProvider((ICapabilityProvider)this.building, predicate)) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(predicate, remaining);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.currentRecipeStorage = null;
            this.currentRequest = null;
            return AIWorkerState.GET_RECIPE;
        }
        return AIWorkerState.CRAFT;
    }

    protected IAIState craft() {
        if (this.currentRecipeStorage == null || ((AbstractJobCrafter)this.job).getCurrentTask() == null) {
            return AIWorkerState.START_WORKING;
        }
        if (this.currentRequest == null && ((AbstractJobCrafter)this.job).getCurrentTask() != null) {
            return AIWorkerState.GET_RECIPE;
        }
        if (this.walkToBuilding()) {
            return this.getState();
        }
        ((AbstractJobCrafter)this.job).setProgress(((AbstractJobCrafter)this.job).getProgress() + 1);
        int toolSlot = -1;
        if (this.currentRecipeStorage.getRequiredTool() != ToolType.NONE) {
            toolSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), stack -> ItemStackUtils.isTool(stack, this.currentRecipeStorage.getRequiredTool()));
        }
        if (toolSlot >= 0) {
            this.worker.getInventoryCitizen().setHeldItem(InteractionHand.MAIN_HAND, toolSlot);
            this.worker.m_21008_(InteractionHand.MAIN_HAND, this.worker.getInventoryCitizen().getStackInSlot(toolSlot));
            this.worker.m_21008_(InteractionHand.OFF_HAND, this.currentRecipeStorage.getCleanedInput().get(this.worker.m_217043_().m_188503_(this.currentRecipeStorage.getCleanedInput().size())).getItemStack().m_41777_());
        } else {
            this.worker.m_21008_(InteractionHand.MAIN_HAND, this.currentRecipeStorage.getCleanedInput().get(this.worker.m_217043_().m_188503_(this.currentRecipeStorage.getCleanedInput().size())).getItemStack().m_41777_());
            this.worker.m_21008_(InteractionHand.OFF_HAND, this.currentRecipeStorage.getPrimaryOutput().m_41777_());
        }
        this.hitBlockWithToolInHand(this.building.getPosition());
        Network.getNetwork().sendToTrackingEntity(new LocalizedParticleEffectMessage(this.worker.m_21205_(), this.building.getPosition().m_7494_()), (Entity)this.worker);
        this.currentRequest = ((AbstractJobCrafter)this.job).getCurrentTask();
        if (this.currentRequest != null && (this.currentRequest.getState() == RequestState.CANCELLED || this.currentRequest.getState() == RequestState.FAILED)) {
            this.currentRequest = null;
            this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
            this.currentRecipeStorage = null;
            return AIWorkerState.START_WORKING;
        }
        if (((AbstractJobCrafter)this.job).getProgress() >= this.getRequiredProgressForMakingRawMaterial()) {
            IAIState check = this.checkForItems(this.currentRecipeStorage);
            if (check == AIWorkerState.CRAFT) {
                if (!this.currentRecipeStorage.fullfillRecipe(this.getLootContext(), (List<IItemHandler>)ImmutableList.of((Object)this.worker.getItemHandlerCitizen()))) {
                    this.currentRequest = null;
                    this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
                    ((AbstractJobCrafter)this.job).finishRequest(false);
                    this.resetValues();
                    return AIWorkerState.START_WORKING;
                }
                this.currentRequest.addDelivery(this.currentRecipeStorage.getPrimaryOutput());
                ((AbstractJobCrafter)this.job).setCraftCounter(((AbstractJobCrafter)this.job).getCraftCounter() + 1);
                if (toolSlot != -1) {
                    this.worker.getCitizenItemHandler().damageItemInHand(InteractionHand.MAIN_HAND, 1);
                }
                if (((AbstractJobCrafter)this.job).getCraftCounter() >= ((AbstractJobCrafter)this.job).getMaxCraftingCount()) {
                    this.incrementActionsDone(this.getActionRewardForCraftingSuccess());
                    ICraftingBuildingModule module = this.building.getCraftingModuleForRecipe(this.currentRecipeStorage.getToken());
                    if (module != null) {
                        module.improveRecipe(this.currentRecipeStorage, ((AbstractJobCrafter)this.job).getCraftCounter(), this.worker.getCitizenData());
                    }
                    this.currentRecipeStorage = null;
                    this.resetValues();
                    if (this.inventoryNeedsDump() && ((AbstractJobCrafter)this.job).getMaxCraftingCount() == 0 && ((AbstractJobCrafter)this.job).getProgress() == 0 && ((AbstractJobCrafter)this.job).getCraftCounter() == 0 && this.currentRequest != null) {
                        this.worker.getCitizenExperienceHandler().addExperience((double)this.currentRequest.getRequest().getCount() / 2.0);
                    }
                    return AIWorkerState.INVENTORY_FULL;
                }
                if (toolSlot >= 0 && this.worker.getInventoryCitizen().getHeldItem(InteractionHand.MAIN_HAND).m_41619_()) {
                    this.currentRequest = null;
                    ((AbstractJobCrafter)this.job).finishRequest(false);
                    this.incrementActionsDoneAndDecSaturation();
                    this.resetValues();
                    return AIWorkerState.START_WORKING;
                }
                ((AbstractJobCrafter)this.job).setProgress(0);
                return AIWorkerState.GET_RECIPE;
            }
            this.currentRequest = null;
            ((AbstractJobCrafter)this.job).finishRequest(false);
            this.incrementActionsDoneAndDecSaturation();
            this.resetValues();
            return AIWorkerState.START_WORKING;
        }
        return this.getState();
    }

    public void hitBlockWithToolInHand(@Nullable BlockPos blockPos) {
        this.worker.m_21563_().m_24950_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 10.0f, (float)this.worker.m_8132_());
        this.worker.m_6674_(this.worker.m_7655_());
        BlockState blockState = this.worker.m_9236_().m_8055_(blockPos);
        BlockPos vector = blockPos.m_121996_((Vec3i)this.worker.m_20183_());
        Direction facing = BlockPosUtil.directionFromDelta(vector.m_123341_(), vector.m_123342_(), vector.m_123343_()).m_122424_();
        Network.getNetwork().sendToPosition(new BlockParticleEffectMessage(blockPos, blockState, facing.ordinal()), new PacketDistributor.TargetPoint((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 16.0, this.worker.m_9236_().m_46472_()));
        ((AbstractJobCrafter)this.job).playSound(blockPos, (EntityCitizen)this.worker);
    }

    public void resetValues() {
        ((AbstractJobCrafter)this.job).setMaxCraftingCount(0);
        ((AbstractJobCrafter)this.job).setProgress(0);
        ((AbstractJobCrafter)this.job).setCraftCounter(0);
        this.worker.m_21008_(InteractionHand.MAIN_HAND, ItemStackUtils.EMPTY);
        this.worker.m_21008_(InteractionHand.OFF_HAND, ItemStackUtils.EMPTY);
        this.dumped = false;
    }

    @Override
    public IAIState afterDump() {
        if (((AbstractJobCrafter)this.job).getMaxCraftingCount() == 0 && ((AbstractJobCrafter)this.job).getProgress() == 0 && ((AbstractJobCrafter)this.job).getCraftCounter() == 0 && this.currentRequest != null) {
            if (this.currentRequest.getState() == RequestState.IN_PROGRESS) {
                this.worker.getCitizenColonyHandler().getColony().getStatisticsManager().incrementBy("items_crafted", this.currentRequest.getRequest().getCount(), this.worker.getCitizenColonyHandler().getColony().getDay());
                ((AbstractJobCrafter)this.job).finishRequest(true);
                this.worker.getCitizenExperienceHandler().addExperience((double)this.currentRequest.getRequest().getCount() / 2.0);
            }
            this.currentRequest = null;
            this.resetValues();
        }
        return super.afterDump();
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private int getRequiredProgressForMakingRawMaterial() {
        int jobModifier = this.worker.getCitizenData().getCitizenSkillHandler().getLevel(((CraftingWorkerBuildingModule)this.getModuleForJob()).getCraftSpeedSkill()) / 2;
        return 10 / Math.min(jobModifier + 1, 50) * 3;
    }

    @Override
    public boolean isAfterDumpPickupAllowed() {
        return this.currentRequest == null;
    }

    protected LootParams getLootContext() {
        return this.getLootContext(false);
    }

    protected LootParams getLootContext(boolean includeKiller) {
        if (this.playerDamageSource == null) {
            this.playerDamageSource = this.world.m_269111_().m_269075_((Player)this.getFakePlayer());
        }
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.world).m_287286_(LootContextParams.f_81460_, (Object)this.worker.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this.worker).m_287286_(LootContextParams.f_81463_, (Object)this.worker.m_21205_()).m_287239_((float)AbstractEntityAICrafting.getEffectiveSkillLevel(this.getPrimarySkillLevel()));
        if (includeKiller) {
            builder = builder.m_287286_(LootContextParams.f_81457_, (Object)this.playerDamageSource).m_287286_(LootContextParams.f_81458_, (Object)this.playerDamageSource.m_7639_()).m_287286_(LootContextParams.f_81459_, (Object)this.playerDamageSource.m_7640_());
        }
        return builder.m_287235_(RecipeStorage.recipeLootParameters);
    }
}

