/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.workorders;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.colony.workorders.WorkManager;
import com.minecolonies.core.colony.workorders.WorkOrderBuilding;
import com.minecolonies.core.colony.workorders.WorkOrderDecoration;
import com.minecolonies.core.colony.workorders.WorkOrderMiner;
import com.minecolonies.core.colony.workorders.WorkOrderPlantationField;
import com.minecolonies.core.colony.workorders.view.AbstractWorkOrderView;
import com.minecolonies.core.colony.workorders.view.WorkOrderBuildingView;
import com.minecolonies.core.colony.workorders.view.WorkOrderDecorationView;
import com.minecolonies.core.colony.workorders.view.WorkOrderMinerView;
import com.minecolonies.core.colony.workorders.view.WorkOrderPlantationFieldView;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWorkOrder
implements IWorkOrder {
    private static final String TAG_TYPE = "type";
    private static final String TAG_ID = "id";
    private static final String TAG_TH_PRIORITY = "priority";
    private static final String TAG_CLAIMED_BY = "claimedBy";
    private static final String TAG_CLAIMED_BY_BUILDING = "claimedByBuilding";
    private static final String TAG_STRUCTURE_PACK = "structurePack";
    private static final String TAG_STRUCTURE_PATH = "structurePath";
    private static final String TAG_TRANSLATION_KEY = "translationKey";
    private static final String TAG_WO_TYPE = "workOrderType";
    private static final String TAG_LOCATION = "location";
    private static final String TAG_ROTATION = "rotation";
    private static final String TAG_IS_MIRRORED = "isMirrored";
    private static final String TAG_CURRENT_LEVEL = "currentLevel";
    private static final String TAG_TARGET_LEVEL = "targetLevel";
    private static final String TAG_AMOUNT_OF_RESOURCES = "amountOfResources";
    private static final String TAG_ITERATOR = "iterator";
    private static final String TAG_IS_CLEARED = "cleared";
    private static final String TAG_IS_REQUESTED = "requested";
    @NotNull
    private static final BiMap<String, Tuple<Class<? extends IWorkOrder>, Class<? extends IWorkOrderView>>> nameToClassBiMap = HashBiMap.create();
    private String translationKey;
    private int id;
    private int priority;
    private BlockPos claimedBy;
    protected String packName;
    private String path;
    private WorkOrderType workOrderType;
    private BlockPos location;
    private int rotation;
    private boolean isMirrored;
    private int currentLevel;
    private int targetLevel;
    private int amountOfResources;
    private String iteratorType = "";
    private boolean cleared;
    private boolean requested;
    protected boolean changed = false;

    private static void addMapping(String name, @NotNull Class<? extends IWorkOrder> orderClass, @NotNull Class<? extends IWorkOrderView> viewClass) {
        if (nameToClassBiMap.containsKey((Object)name)) {
            throw new IllegalArgumentException("Duplicate type '" + name + "' when adding Work Order class mapping");
        }
        try {
            if (orderClass.getDeclaredConstructor(new Class[0]) != null) {
                nameToClassBiMap.put((Object)name, new Tuple<Class<? extends IWorkOrder>, Class<? extends IWorkOrderView>>(orderClass, viewClass));
                nameToClassBiMap.inverse().put(new Tuple<Class<? extends IWorkOrder>, Class<? extends IWorkOrderView>>(orderClass, viewClass), (Object)name);
            }
        }
        catch (NoSuchMethodException exception) {
            throw new IllegalArgumentException("Missing constructor for type '" + name + "' when adding Work Order class mapping", exception);
        }
    }

    public static IWorkOrder createFromNBT(@NotNull CompoundTag compound, WorkManager manager) {
        @Nullable IWorkOrder order = null;
        @Nullable Class oclass = null;
        try {
            String type = compound.m_128461_(TAG_TYPE);
            oclass = type.equals("removal") ? WorkOrderBuilding.class : (Class)((Tuple)nameToClassBiMap.get((Object)type)).getA();
            if (oclass != null) {
                Constructor constructor = oclass.getDeclaredConstructor(new Class[0]);
                order = (IWorkOrder)constructor.newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.getLogger().trace((Object)e);
        }
        if (order == null) {
            Log.getLogger().warn(String.format("Unknown WorkOrder type '%s' or missing constructor of proper format.", compound.m_128461_(TAG_TYPE)));
            return null;
        }
        try {
            order.read(compound, manager);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A WorkOrder %s(%s) has thrown an exception during loading, its state cannot be restored. Report this to the mod author", compound.m_128461_(TAG_TYPE), oclass.getName()), (Throwable)ex);
            return null;
        }
        return order;
    }

    @Nullable
    public static IWorkOrderView createWorkOrderView(FriendlyByteBuf buf) {
        @Nullable AbstractWorkOrderView orderView = null;
        String mappingName = buf.m_130136_(Short.MAX_VALUE);
        try {
            @Nullable Class oclass = (Class)((Tuple)nameToClassBiMap.get((Object)mappingName)).getB();
            if (oclass != null) {
                Constructor constructor = oclass.getDeclaredConstructor(new Class[0]);
                orderView = (AbstractWorkOrderView)constructor.newInstance(new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.getLogger().trace((Object)e);
        }
        if (orderView == null) {
            Log.getLogger().warn(String.format("Unknown WorkOrder type '%s' or missing constructor of proper format.", mappingName));
            return null;
        }
        try {
            orderView.deserialize(buf);
        }
        catch (RuntimeException ex) {
            Log.getLogger().error(String.format("A WorkOrder.View for #%d has thrown an exception during loading, its state cannot be restored. Report this to the mod author", orderView.getId()), (Throwable)ex);
            return null;
        }
        return orderView;
    }

    public AbstractWorkOrder() {
    }

    protected AbstractWorkOrder(String packName, String path, String translationKey, WorkOrderType workOrderType, BlockPos location, int rotation, boolean isMirrored, int currentLevel, int targetLevel) {
        this();
        this.packName = packName;
        this.path = path;
        this.translationKey = translationKey;
        this.workOrderType = workOrderType;
        this.location = location;
        this.rotation = rotation;
        this.isMirrored = isMirrored;
        this.currentLevel = currentLevel;
        this.targetLevel = targetLevel;
    }

    @Override
    public final int getID() {
        return this.id;
    }

    @Override
    public final void setID(int id) {
        this.id = id;
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    @Override
    public final void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public final BlockPos getClaimedBy() {
        return this.claimedBy;
    }

    @Override
    public final void setClaimedBy(BlockPos claimedBy) {
        this.claimedBy = claimedBy;
    }

    @Override
    public final void setClaimedBy(@Nullable ICitizenData citizen) {
        this.changed = true;
        this.claimedBy = citizen != null && citizen.getWorkBuilding() != null ? citizen.getWorkBuilding().getPosition() : null;
    }

    @Override
    public final boolean isClaimed() {
        return this.claimedBy != null;
    }

    @Override
    public final boolean isClaimedBy(@NotNull ICitizenData citizen) {
        if (citizen.getWorkBuilding() != null) {
            return citizen.getWorkBuilding().getPosition().equals((Object)this.claimedBy);
        }
        return false;
    }

    @Override
    public final void clearClaimedBy() {
        this.changed = true;
        this.claimedBy = null;
    }

    @Override
    public final String getStructurePath() {
        return this.path;
    }

    @Override
    public String getStructurePack() {
        return this.packName;
    }

    @Override
    public Future<Blueprint> getBlueprintFuture() {
        return StructurePacks.getBlueprintFuture((String)this.getStructurePack(), (String)this.getStructurePath());
    }

    @Override
    public final String getTranslationKey() {
        return this.translationKey;
    }

    @Override
    public final WorkOrderType getWorkOrderType() {
        return this.workOrderType;
    }

    @Override
    public final BlockPos getLocation() {
        return this.location;
    }

    @Override
    public final int getRotation() {
        return this.rotation;
    }

    @Override
    public final boolean isMirrored() {
        return this.isMirrored;
    }

    @Override
    public final int getCurrentLevel() {
        return this.currentLevel;
    }

    @Override
    public final int getTargetLevel() {
        return this.targetLevel;
    }

    @Override
    public final int getAmountOfResources() {
        return this.amountOfResources;
    }

    @Override
    public final void setAmountOfResources(int newQuantity) {
        this.changed = true;
        this.amountOfResources = newQuantity;
    }

    @Override
    public final String getIteratorType() {
        return this.iteratorType;
    }

    @Override
    public final void setIteratorType(String iteratorType) {
        this.changed = true;
        this.iteratorType = iteratorType;
    }

    @Override
    public final boolean isCleared() {
        return this.cleared;
    }

    @Override
    public final void setCleared(boolean cleared) {
        this.changed = true;
        this.cleared = cleared;
    }

    @Override
    public final boolean isRequested() {
        return this.requested;
    }

    @Override
    public final void setRequested(boolean requested) {
        this.changed = true;
        this.requested = requested;
    }

    @Override
    public final boolean isDirty() {
        return this.changed;
    }

    @Override
    public final void resetChange() {
        this.changed = false;
    }

    @Override
    public Component getDisplayName() {
        return Component.m_237115_((String)this.getTranslationKey());
    }

    @Override
    public abstract boolean canBeMadeBy(IJob<?> var1);

    @Override
    public abstract boolean canBuild(@NotNull ICitizenData var1);

    @Override
    public boolean isValid(IColony colony) {
        return true;
    }

    @Override
    public void read(@NotNull CompoundTag compound, IWorkManager manager) {
        this.id = compound.m_128451_(TAG_ID);
        if (compound.m_128441_(TAG_TH_PRIORITY)) {
            this.priority = compound.m_128451_(TAG_TH_PRIORITY);
        }
        if (compound.m_128441_(TAG_CLAIMED_BY)) {
            ICitizenData data;
            int citizenId = compound.m_128451_(TAG_CLAIMED_BY);
            if (manager.getColony() != null && (data = manager.getColony().getCitizenManager().getCivilian(citizenId)) != null && data.getWorkBuilding() != null) {
                this.claimedBy = data.getWorkBuilding().getPosition();
            }
        } else if (compound.m_128441_(TAG_CLAIMED_BY_BUILDING)) {
            this.claimedBy = BlockPosUtil.read(compound, TAG_CLAIMED_BY_BUILDING);
        }
        this.packName = compound.m_128461_(TAG_STRUCTURE_PACK);
        this.path = compound.m_128461_(TAG_STRUCTURE_PATH);
        this.translationKey = compound.m_128461_(TAG_TRANSLATION_KEY);
        this.workOrderType = WorkOrderType.values()[compound.m_128451_(TAG_WO_TYPE)];
        this.location = BlockPosUtil.read(compound, TAG_LOCATION);
        this.rotation = compound.m_128451_(TAG_ROTATION);
        this.isMirrored = compound.m_128471_(TAG_IS_MIRRORED);
        this.currentLevel = compound.m_128451_(TAG_CURRENT_LEVEL);
        this.targetLevel = compound.m_128451_(TAG_TARGET_LEVEL);
        this.amountOfResources = compound.m_128451_(TAG_AMOUNT_OF_RESOURCES);
        this.iteratorType = compound.m_128461_(TAG_ITERATOR);
        this.cleared = compound.m_128471_(TAG_IS_CLEARED);
        this.requested = compound.m_128471_(TAG_IS_REQUESTED);
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        compound.m_128405_(TAG_TH_PRIORITY, this.priority);
        compound.m_128359_(TAG_TYPE, this.getMappingName());
        compound.m_128405_(TAG_ID, this.id);
        if (this.claimedBy != null) {
            BlockPosUtil.write(compound, TAG_CLAIMED_BY_BUILDING, this.claimedBy);
        }
        compound.m_128359_(TAG_STRUCTURE_PACK, this.packName);
        compound.m_128359_(TAG_STRUCTURE_PATH, this.path);
        compound.m_128359_(TAG_TRANSLATION_KEY, this.translationKey);
        compound.m_128405_(TAG_WO_TYPE, this.workOrderType.ordinal());
        BlockPosUtil.write(compound, TAG_LOCATION, this.location);
        compound.m_128405_(TAG_ROTATION, this.rotation);
        compound.m_128379_(TAG_IS_MIRRORED, this.isMirrored);
        compound.m_128405_(TAG_CURRENT_LEVEL, this.currentLevel);
        compound.m_128405_(TAG_TARGET_LEVEL, this.targetLevel);
        compound.m_128405_(TAG_AMOUNT_OF_RESOURCES, this.amountOfResources);
        compound.m_128359_(TAG_ITERATOR, this.iteratorType);
        compound.m_128379_(TAG_IS_CLEARED, this.cleared);
        compound.m_128379_(TAG_IS_REQUESTED, this.requested);
    }

    @Override
    public void serializeViewNetworkData(@NotNull FriendlyByteBuf buf) {
        buf.m_130070_(this.getMappingName());
        buf.writeInt(this.id);
        buf.writeInt(this.priority);
        buf.m_130064_(this.claimedBy == null ? BlockPos.f_121853_ : this.claimedBy);
        buf.m_130070_(this.packName);
        buf.m_130070_(this.path);
        buf.m_130070_(this.translationKey);
        buf.writeInt(this.workOrderType.ordinal());
        buf.m_130064_(this.location);
        buf.writeInt(this.rotation);
        buf.writeBoolean(this.isMirrored);
        buf.writeInt(this.currentLevel);
        buf.writeInt(this.targetLevel);
        buf.writeInt(this.amountOfResources);
        buf.m_130070_(this.iteratorType);
        buf.writeBoolean(this.cleared);
        buf.writeBoolean(this.requested);
    }

    private String getMappingName() {
        Optional<String> s = nameToClassBiMap.entrySet().stream().filter(f -> this.getClass().equals(((Tuple)f.getValue()).getA())).map(Map.Entry::getKey).findFirst();
        if (!s.isPresent()) {
            throw new IllegalStateException(this.getClass() + " is missing a mapping! This is a bug!");
        }
        return s.get();
    }

    @Override
    public void onAdded(IColony colony, boolean readingFromNbt) {
    }

    @Override
    public void onCompleted(IColony colony, ICitizenData citizen) {
    }

    @Override
    public void onRemoved(IColony colony) {
    }

    @Override
    public boolean canBeResolved(IColony colony, int level) {
        return colony.getBuildingManager().getBuildings().values().stream().anyMatch(building -> building instanceof BuildingBuilder && !building.getAllAssignedCitizen().isEmpty() && building.getBuildingLevel() >= level);
    }

    @Override
    public boolean tooFarFromAnyBuilder(IColony colony, int level) {
        return false;
    }

    static {
        AbstractWorkOrder.addMapping("building", WorkOrderBuilding.class, WorkOrderBuildingView.class);
        AbstractWorkOrder.addMapping("decoration", WorkOrderDecoration.class, WorkOrderDecorationView.class);
        AbstractWorkOrder.addMapping("plantation_field", WorkOrderPlantationField.class, WorkOrderPlantationFieldView.class);
        AbstractWorkOrder.addMapping("miner", WorkOrderMiner.class, WorkOrderMinerView.class);
    }
}

