/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.requests;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.IRequestFactory;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.Burnable;
import com.minecolonies.api.colony.requestsystem.requestable.Food;
import com.minecolonies.api.colony.requestsystem.requestable.IRequestable;
import com.minecolonies.api.colony.requestsystem.requestable.RequestTag;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.requestable.StackList;
import com.minecolonies.api.colony.requestsystem.requestable.Tool;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.AbstractCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PrivateCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.crafting.PublicCrafting;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Delivery;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.Pickup;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.requestable.SmeltableOre;
import com.minecolonies.core.colony.requestsystem.requests.StandardRequests;
import java.util.ArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class StandardRequestFactories {
    private static final String NBT_REQUESTER = "Requester";
    private static final String NBT_TOKEN = "Token";
    private static final String NBT_STATE = "State";
    private static final String NBT_REQUESTED = "Requested";
    private static final String NBT_RESULT = "Result";
    private static final String NBT_PARENT = "Parent";
    private static final String NBT_CHILDREN = "Children";
    private static final String NBT_DELIVERIES = "Deliveries";

    private StandardRequestFactories() {
    }

    public static <T extends IRequestable> CompoundTag serializeToNBT(IFactoryController controller, IRequest<T> request, IObjectToNBTConverter<T> typeSerialization) {
        CompoundTag compound = new CompoundTag();
        CompoundTag requesterCompound = controller.serialize(request.getRequester());
        CompoundTag tokenCompound = controller.serialize(request.getId());
        IntTag stateCompound = request.getState().serialize();
        CompoundTag requestedCompound = typeSerialization.apply(controller, request.getRequest());
        ListTag childrenCompound = new ListTag();
        for (IToken token : request.getChildren()) {
            childrenCompound.add((Object)controller.serialize(token));
        }
        compound.m_128365_(NBT_REQUESTER, (Tag)requesterCompound);
        compound.m_128365_(NBT_TOKEN, (Tag)tokenCompound);
        compound.m_128365_(NBT_STATE, (Tag)stateCompound);
        compound.m_128365_(NBT_REQUESTED, (Tag)requestedCompound);
        if (request.hasResult()) {
            compound.m_128365_(NBT_RESULT, (Tag)typeSerialization.apply(controller, request.getResult()));
        }
        if (request.hasParent()) {
            compound.m_128365_(NBT_PARENT, (Tag)controller.serialize(request.getParent()));
        }
        compound.m_128365_(NBT_CHILDREN, (Tag)childrenCompound);
        ListTag deliveriesList = new ListTag();
        request.getDeliveries().forEach(itemStack -> deliveriesList.add((Object)itemStack.m_41739_(new CompoundTag())));
        compound.m_128365_(NBT_DELIVERIES, (Tag)deliveriesList);
        return compound;
    }

    public static <T extends IRequestable> void serializeToFriendlyByteBuf(IFactoryController controller, IRequest<T> request, FriendlyByteBuf packetBuffer, IObjectToPackBufferWriter<T> typeSerialization) {
        controller.serialize(packetBuffer, request.getRequester());
        controller.serialize(packetBuffer, request.getId());
        request.getState().serialize(packetBuffer);
        typeSerialization.apply(controller, packetBuffer, request.getRequest());
        packetBuffer.writeInt(request.getChildren().size());
        for (IToken token : request.getChildren()) {
            controller.serialize(packetBuffer, token);
        }
        packetBuffer.writeBoolean(request.hasResult());
        if (request.hasResult()) {
            typeSerialization.apply(controller, packetBuffer, request.getResult());
        }
        packetBuffer.writeBoolean(request.hasParent());
        if (request.hasParent()) {
            controller.serialize(packetBuffer, request.getParent());
        }
        packetBuffer.writeInt(request.getDeliveries().size());
        request.getDeliveries().forEach(arg_0 -> ((FriendlyByteBuf)packetBuffer).m_130055_(arg_0));
    }

    public static <T extends IRequestable, R extends IRequest<T>> R deserializeFromNBT(IFactoryController controller, CompoundTag compound, INBTToObjectConverter<T> typeDeserialization, IObjectConstructor<T, R> objectConstructor) {
        IRequester requester = (IRequester)controller.deserialize(compound.m_128469_(NBT_REQUESTER));
        IToken token = (IToken)controller.deserialize(compound.m_128469_(NBT_TOKEN));
        RequestState state = RequestState.deserialize((IntTag)compound.m_128423_(NBT_STATE));
        IRequestable requested = (IRequestable)typeDeserialization.apply(controller, compound.m_128469_(NBT_REQUESTED));
        ArrayList<IToken> childTokens = new ArrayList<IToken>();
        ListTag childCompound = compound.m_128437_(NBT_CHILDREN, 10);
        for (int i = 0; i < childCompound.size(); ++i) {
            childTokens.add((IToken)controller.deserialize(childCompound.m_128728_(i)));
        }
        IRequest request = (IRequest)objectConstructor.construct(requested, token, requester, state);
        request.addChildren(childTokens);
        if (compound.m_128441_(NBT_PARENT)) {
            request.setParent((IToken)controller.deserialize(compound.m_128469_(NBT_PARENT)));
        }
        if (compound.m_128441_(NBT_RESULT)) {
            request.setResult((IRequestable)typeDeserialization.apply(controller, compound.m_128469_(NBT_RESULT)));
        }
        if (compound.m_128441_(NBT_DELIVERIES)) {
            ImmutableList.Builder stackBuilder = ImmutableList.builder();
            ListTag deliveriesList = compound.m_128437_(NBT_DELIVERIES, 10);
            NBTUtils.streamCompound(deliveriesList).forEach(itemStackCompound -> stackBuilder.add((Object)ItemStack.m_41712_((CompoundTag)itemStackCompound)));
            request.overrideCurrentDeliveries((ImmutableList<ItemStack>)stackBuilder.build());
        }
        return (R)request;
    }

    public static <T extends IRequestable, R extends IRequest<T>> R deserializeFromFriendlyByteBuf(IFactoryController controller, FriendlyByteBuf buffer, IFriendlyByteBufToObjectReader<T> typeDeserialization, IObjectConstructor<T, R> objectConstructor) {
        IRequester requester = (IRequester)controller.deserialize(buffer);
        IToken token = (IToken)controller.deserialize(buffer);
        RequestState state = RequestState.deserialize(buffer);
        IRequestable requested = (IRequestable)typeDeserialization.apply(controller, buffer);
        ArrayList<IToken> childTokens = new ArrayList<IToken>();
        int size = buffer.readInt();
        for (int i = 0; i < size; ++i) {
            childTokens.add((IToken)controller.deserialize(buffer));
        }
        IRequest request = (IRequest)objectConstructor.construct(requested, token, requester, state);
        request.addChildren(childTokens);
        if (buffer.readBoolean()) {
            request.setResult((IRequestable)typeDeserialization.apply(controller, buffer));
        }
        if (buffer.readBoolean()) {
            request.setParent((IToken)controller.deserialize(buffer));
        }
        ArrayList<ItemStack> deliveries = new ArrayList<ItemStack>();
        int size2 = buffer.readInt();
        for (int i = 0; i < size2; ++i) {
            deliveries.add(buffer.m_130267_());
        }
        request.overrideCurrentDeliveries((ImmutableList<ItemStack>)ImmutableList.copyOf(deliveries));
        return (R)request;
    }

    @FunctionalInterface
    public static interface IObjectToNBTConverter<O> {
        public CompoundTag apply(IFactoryController var1, O var2);
    }

    @FunctionalInterface
    public static interface IObjectToPackBufferWriter<O> {
        public void apply(IFactoryController var1, FriendlyByteBuf var2, O var3);
    }

    @FunctionalInterface
    public static interface INBTToObjectConverter<O> {
        public O apply(IFactoryController var1, CompoundTag var2);
    }

    @FunctionalInterface
    public static interface IObjectConstructor<T, O> {
        public O construct(@NotNull T var1, @NotNull IToken<?> var2, @NotNull IRequester var3, @NotNull RequestState var4);
    }

    @FunctionalInterface
    public static interface IFriendlyByteBufToObjectReader<O> {
        public O apply(IFactoryController var1, FriendlyByteBuf var2);
    }

    public static final class BurnableRequestFactory
    implements IRequestFactory<Burnable, StandardRequests.BurnableRequest> {
        @Override
        public StandardRequests.BurnableRequest getNewInstance(@NotNull Burnable input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.BurnableRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.BurnableRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.BurnableRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Burnable> getFactoryInputType() {
            return TypeToken.of(Burnable.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.BurnableRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Burnable::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.BurnableRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Burnable::deserialize, (requested, token, requester, requestState) -> (StandardRequests.BurnableRequest)controller.getNewInstance(TypeToken.of(StandardRequests.BurnableRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.BurnableRequest input, FriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToFriendlyByteBuf(controller, input, packetBuffer, Burnable::serialize);
        }

        @Override
        public StandardRequests.BurnableRequest deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromFriendlyByteBuf(controller, buffer, Burnable::deserialize, (requested, token, requester, requestState) -> (StandardRequests.BurnableRequest)controller.getNewInstance(TypeToken.of(StandardRequests.BurnableRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 13;
        }
    }

    public static final class SmeltableOreRequestFactory
    implements IRequestFactory<SmeltableOre, StandardRequests.SmeltAbleOreRequest> {
        @Override
        public StandardRequests.SmeltAbleOreRequest getNewInstance(@NotNull SmeltableOre input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.SmeltAbleOreRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.SmeltAbleOreRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.SmeltAbleOreRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends SmeltableOre> getFactoryInputType() {
            return TypeToken.of(SmeltableOre.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.SmeltAbleOreRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, SmeltableOre::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.SmeltAbleOreRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, SmeltableOre::deserialize, (requested, token, requester, requestState) -> (StandardRequests.SmeltAbleOreRequest)controller.getNewInstance(TypeToken.of(StandardRequests.SmeltAbleOreRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.SmeltAbleOreRequest input, FriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToFriendlyByteBuf(controller, input, packetBuffer, SmeltableOre::serialize);
        }

        @Override
        public StandardRequests.SmeltAbleOreRequest deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromFriendlyByteBuf(controller, buffer, SmeltableOre::deserialize, (requested, token, requester, requestState) -> (StandardRequests.SmeltAbleOreRequest)controller.getNewInstance(TypeToken.of(StandardRequests.SmeltAbleOreRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 12;
        }
    }

    public static final class FoodRequestFactory
    implements IRequestFactory<Food, StandardRequests.FoodRequest> {
        @Override
        public StandardRequests.FoodRequest getNewInstance(@NotNull Food input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.FoodRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.FoodRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.FoodRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Food> getFactoryInputType() {
            return TypeToken.of(Food.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.FoodRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Food::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.FoodRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Food::deserialize, (requested, token, requester, requestState) -> (StandardRequests.FoodRequest)controller.getNewInstance(TypeToken.of(StandardRequests.FoodRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.FoodRequest input, FriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToFriendlyByteBuf(controller, input, packetBuffer, Food::serialize);
        }

        @Override
        public StandardRequests.FoodRequest deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromFriendlyByteBuf(controller, buffer, Food::deserialize, (requested, token, requester, requestState) -> (StandardRequests.FoodRequest)controller.getNewInstance(TypeToken.of(StandardRequests.FoodRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 11;
        }
    }

    public static final class ToolRequestFactory
    implements IRequestFactory<Tool, StandardRequests.ToolRequest> {
        @Override
        public StandardRequests.ToolRequest getNewInstance(@NotNull Tool input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ToolRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<? extends StandardRequests.ToolRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ToolRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends Tool> getFactoryInputType() {
            return TypeToken.of(Tool.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ToolRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Tool::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ToolRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Tool::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ToolRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ToolRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.ToolRequest input, FriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToFriendlyByteBuf(controller, input, packetBuffer, Tool::serialize);
        }

        @Override
        public StandardRequests.ToolRequest deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromFriendlyByteBuf(controller, buffer, Tool::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ToolRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ToolRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 10;
        }
    }

    public static final class PublicCraftingRequestFactory
    extends AbstractCraftingRequestFactory<PublicCrafting, StandardRequests.PublicCraftingRequest> {
        public PublicCraftingRequestFactory() {
            super((requested, token, requester, requestState) -> new StandardRequests.PublicCraftingRequest(requester, (IToken<?>)token, requestState, (PublicCrafting)requested), PublicCrafting.class, StandardRequests.PublicCraftingRequest.class, PublicCrafting::serialize, PublicCrafting::deserialize, PublicCrafting::serialize, PublicCrafting::deserialize);
        }

        @Override
        public short getSerializationId() {
            return 41;
        }
    }

    public static final class PrivateCraftingRequestFactory
    extends AbstractCraftingRequestFactory<PrivateCrafting, StandardRequests.PrivateCraftingRequest> {
        public PrivateCraftingRequestFactory() {
            super((requested, token, requester, requestState) -> new StandardRequests.PrivateCraftingRequest(requester, (IToken<?>)token, requestState, (PrivateCrafting)requested), PrivateCrafting.class, StandardRequests.PrivateCraftingRequest.class, PrivateCrafting::serialize, PrivateCrafting::deserialize, PrivateCrafting::serialize, PrivateCrafting::deserialize);
        }

        @Override
        public short getSerializationId() {
            return 42;
        }
    }

    public static abstract class AbstractCraftingRequestFactory<C extends AbstractCrafting, R extends StandardRequests.AbstractCraftingRequest<C>>
    implements IRequestFactory<C, R> {
        private final IObjectConstructor<C, R> constructor;
        private final Class<C> cClass;
        private final Class<R> rClass;
        private final IObjectToNBTConverter<C> nbtSerializer;
        private final INBTToObjectConverter<C> nbtDeserializer;
        private final IObjectToPackBufferWriter<C> packetSerializer;
        private final IFriendlyByteBufToObjectReader<C> packetDeserializer;

        protected AbstractCraftingRequestFactory(IObjectConstructor<C, R> constructor, Class<C> cClass, Class<R> rClass, IObjectToNBTConverter<C> nbtSerializer, INBTToObjectConverter<C> nbtDeserializer, IObjectToPackBufferWriter<C> packetSerializer, IFriendlyByteBufToObjectReader<C> packetDeserializer) {
            this.constructor = constructor;
            this.cClass = cClass;
            this.rClass = rClass;
            this.nbtSerializer = nbtSerializer;
            this.nbtDeserializer = nbtDeserializer;
            this.packetSerializer = packetSerializer;
            this.packetDeserializer = packetDeserializer;
        }

        @Override
        public R getNewInstance(@NotNull C input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return (R)((StandardRequests.AbstractCraftingRequest)this.constructor.construct(input, token, location, initialState));
        }

        @Override
        @NotNull
        public TypeToken<? extends R> getFactoryOutputType() {
            return TypeToken.of(this.rClass);
        }

        @Override
        @NotNull
        public TypeToken<? extends C> getFactoryInputType() {
            return TypeToken.of(this.cClass);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull R r) {
            return StandardRequestFactories.serializeToNBT(controller, r, this.nbtSerializer);
        }

        @Override
        @NotNull
        public R deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) throws Throwable {
            return (R)StandardRequestFactories.deserializeFromNBT(controller, nbt, this.nbtDeserializer, (requested, token, requester, requestState) -> (StandardRequests.AbstractCraftingRequest)controller.getNewInstance(TypeToken.of(this.rClass), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, R input, FriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToFriendlyByteBuf(controller, input, packetBuffer, this.packetSerializer);
        }

        @Override
        public R deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            return (R)StandardRequestFactories.deserializeFromFriendlyByteBuf(controller, buffer, this.packetDeserializer, (requested, token, requester, requestState) -> (StandardRequests.AbstractCraftingRequest)controller.getNewInstance(TypeToken.of(this.rClass), requested, new Object[]{token, requester, requestState}));
        }
    }

    public static final class PickupRequestFactory
    implements IRequestFactory<Pickup, StandardRequests.PickupRequest> {
        @Override
        @NotNull
        public TypeToken<StandardRequests.PickupRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.PickupRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Pickup> getFactoryInputType() {
            return TypeConstants.PICKUP;
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.PickupRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Pickup::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.PickupRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Pickup::deserialize, (requested, token, requester, requestState) -> (StandardRequests.PickupRequest)controller.getNewInstance(TypeToken.of(StandardRequests.PickupRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public StandardRequests.PickupRequest getNewInstance(@NotNull Pickup input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.PickupRequest(location, token, initialState, input);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.PickupRequest input, FriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToFriendlyByteBuf(controller, input, packetBuffer, Pickup::serialize);
        }

        @Override
        public StandardRequests.PickupRequest deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromFriendlyByteBuf(controller, buffer, Pickup::deserialize, (requested, token, requester, requestState) -> (StandardRequests.PickupRequest)controller.getNewInstance(TypeToken.of(StandardRequests.PickupRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 9;
        }
    }

    public static final class DeliveryRequestFactory
    implements IRequestFactory<Delivery, StandardRequests.DeliveryRequest> {
        @Override
        @NotNull
        public TypeToken<StandardRequests.DeliveryRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.DeliveryRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Delivery> getFactoryInputType() {
            return TypeConstants.DELIVERY;
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.DeliveryRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Delivery::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.DeliveryRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Delivery::deserialize, (requested, token, requester, requestState) -> (StandardRequests.DeliveryRequest)controller.getNewInstance(TypeToken.of(StandardRequests.DeliveryRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public StandardRequests.DeliveryRequest getNewInstance(@NotNull Delivery input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.DeliveryRequest(location, token, initialState, input);
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.DeliveryRequest input, FriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToFriendlyByteBuf(controller, input, packetBuffer, Delivery::serialize);
        }

        @Override
        public StandardRequests.DeliveryRequest deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromFriendlyByteBuf(controller, buffer, Delivery::deserialize, (requested, token, requester, requestState) -> (StandardRequests.DeliveryRequest)controller.getNewInstance(TypeToken.of(StandardRequests.DeliveryRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 8;
        }
    }

    public static final class ItemTagRequestFactory
    implements IRequestFactory<RequestTag, StandardRequests.ItemTagRequest> {
        @Override
        public StandardRequests.ItemTagRequest getNewInstance(@NotNull RequestTag input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ItemTagRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.ItemTagRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ItemTagRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<RequestTag> getFactoryInputType() {
            return TypeToken.of(RequestTag.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemTagRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, RequestTag::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemTagRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, RequestTag::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemTagRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemTagRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        @NotNull
        public void serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemTagRequest itemTagRequest, FriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToFriendlyByteBuf(controller, itemTagRequest, packetBuffer, RequestTag::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemTagRequest deserialize(@NotNull IFactoryController controller, @NotNull FriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromFriendlyByteBuf(controller, buffer, RequestTag::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemTagRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemTagRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 7;
        }
    }

    public static final class ItemStackListRequestFactory
    implements IRequestFactory<StackList, StandardRequests.ItemStackListRequest> {
        @Override
        public StandardRequests.ItemStackListRequest getNewInstance(@NotNull StackList input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ItemStackListRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.ItemStackListRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ItemStackListRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<StackList> getFactoryInputType() {
            return TypeToken.of(StackList.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemStackListRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, StackList::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemStackListRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, StackList::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackListRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackListRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public void serialize(IFactoryController controller, StandardRequests.ItemStackListRequest input, FriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToFriendlyByteBuf(controller, input, packetBuffer, StackList::serialize);
        }

        @Override
        public StandardRequests.ItemStackListRequest deserialize(IFactoryController controller, FriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromFriendlyByteBuf(controller, buffer, StackList::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackListRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackListRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 6;
        }
    }

    public static final class ItemStackRequestFactory
    implements IRequestFactory<Stack, StandardRequests.ItemStackRequest> {
        @Override
        public StandardRequests.ItemStackRequest getNewInstance(@NotNull Stack input, @NotNull IRequester location, @NotNull IToken<?> token, @NotNull RequestState initialState) {
            return new StandardRequests.ItemStackRequest(location, token, initialState, input);
        }

        @Override
        @NotNull
        public TypeToken<StandardRequests.ItemStackRequest> getFactoryOutputType() {
            return TypeToken.of(StandardRequests.ItemStackRequest.class);
        }

        @Override
        @NotNull
        public TypeToken<Stack> getFactoryInputType() {
            return TypeToken.of(Stack.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemStackRequest request) {
            return StandardRequestFactories.serializeToNBT(controller, request, Stack::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemStackRequest deserialize(@NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            return StandardRequestFactories.deserializeFromNBT(controller, nbt, Stack::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        @NotNull
        public void serialize(@NotNull IFactoryController controller, @NotNull StandardRequests.ItemStackRequest input, FriendlyByteBuf packetBuffer) {
            StandardRequestFactories.serializeToFriendlyByteBuf(controller, input, packetBuffer, Stack::serialize);
        }

        @Override
        @NotNull
        public StandardRequests.ItemStackRequest deserialize(@NotNull IFactoryController controller, @NotNull FriendlyByteBuf buffer) throws Throwable {
            return StandardRequestFactories.deserializeFromFriendlyByteBuf(controller, buffer, Stack::deserialize, (requested, token, requester, requestState) -> (StandardRequests.ItemStackRequest)controller.getNewInstance(TypeToken.of(StandardRequests.ItemStackRequest.class), requested, new Object[]{token, requester, requestState}));
        }

        @Override
        public short getSerializationId() {
            return 5;
        }
    }
}

