/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.permissions;

import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.permissions.Rank;
import com.minecolonies.api.network.PacketUtils;
import com.minecolonies.api.util.Utils;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PermissionsView
implements IPermissions {
    private static final Rank MISSINGNO_RANK = new Rank(-1, "missingno", false, true);
    @NotNull
    private final Map<UUID, ColonyPlayer> players = new HashMap<UUID, ColonyPlayer>();
    private Rank userRank;
    private final Map<Integer, Rank> ranks = new LinkedHashMap<Integer, Rank>();
    private UUID colonyOwner;
    private String ownerName = "";

    public Rank getUserRank() {
        return this.userRank;
    }

    @Override
    @NotNull
    public Set<ColonyPlayer> getPlayersByRank(Rank rank) {
        return Collections.unmodifiableSet(this.players.values().stream().filter(player -> player.getRank() == rank).collect(Collectors.toSet()));
    }

    @Override
    @NotNull
    public Map<UUID, ColonyPlayer> getPlayers() {
        return Collections.unmodifiableMap(this.players);
    }

    @Override
    public boolean setPlayerRank(UUID id, Rank rank, Level world) {
        return false;
    }

    @Override
    public boolean addPlayer(@NotNull GameProfile gameprofile, Rank rank) {
        return false;
    }

    @Override
    @NotNull
    public Set<ColonyPlayer> getPlayersByRank(@NotNull Set<Rank> ranks) {
        return Collections.unmodifiableSet(this.players.values().stream().filter(player -> ranks.contains(player.getRank())).collect(Collectors.toSet()));
    }

    @Override
    public Set<ColonyPlayer> getFilteredPlayers(@NotNull Predicate<Rank> predicate) {
        return Collections.unmodifiableSet(this.players.values().stream().filter(player -> predicate.test(player.getRank())).collect(Collectors.toSet()));
    }

    public boolean hasPermission(UUID id, @NotNull Action action) {
        return this.hasPermission(this.getRank(id), action);
    }

    @Override
    public boolean hasPermission(Rank rank, @NotNull Action action) {
        return Utils.testFlag(rank.getPermissions(), action.getFlag());
    }

    @Override
    public boolean setPermission(Rank rank, @NotNull Action action, boolean enable) {
        boolean changed = enable ? rank.addPermission(action) : rank.removePermission(action);
        return changed;
    }

    @Override
    public boolean removePlayer(UUID playerID) {
        return false;
    }

    @Override
    public boolean alterPermission(Rank actor, Rank rank, @NotNull Action action, boolean enable) {
        if (!this.canAlterPermission(actor, rank, action)) {
            return false;
        }
        return this.setPermission(rank, action, enable);
    }

    @Override
    public boolean canAlterPermission(Rank actor, Rank rank, @NotNull Action action) {
        if (rank == this.getRankOwner() && actor != this.getRankOwner()) {
            return false;
        }
        return this.hasPermission(actor, Action.EDIT_PERMISSIONS) && (actor != rank || action != Action.EDIT_PERMISSIONS && action != Action.MANAGE_HUTS && action != Action.ACCESS_HUTS);
    }

    @Override
    @Nullable
    public Map.Entry<UUID, ColonyPlayer> getOwnerEntry() {
        for (Map.Entry<UUID, ColonyPlayer> entry : this.players.entrySet()) {
            if (!entry.getValue().getRank().equals(this.getRanks().get(0))) continue;
            return entry;
        }
        return null;
    }

    @Override
    public boolean setOwner(Player player) {
        return false;
    }

    @Override
    public void setOwnerAbandoned() {
    }

    @Override
    @NotNull
    public UUID getOwner() {
        if (this.colonyOwner == null) {
            Map.Entry<UUID, ColonyPlayer> owner = this.getOwnerEntry();
            if (owner != null) {
                this.colonyOwner = owner.getKey();
            } else {
                this.restoreOwnerIfNull();
            }
        }
        return this.colonyOwner;
    }

    public void deserialize(@NotNull FriendlyByteBuf buf) {
        int ranksSize = buf.m_130242_();
        for (int i = 0; i < ranksSize; ++i) {
            int id = buf.m_130242_();
            Rank rank = new Rank(id, buf.readLong(), buf.m_130136_(Short.MAX_VALUE), buf.readBoolean(), buf.readBoolean(), buf.readBoolean(), buf.readBoolean());
            this.ranks.put(id, rank);
        }
        this.userRank = this.ranks.get(buf.m_130242_());
        this.players.clear();
        int numOwners = buf.m_130242_();
        for (int i = 0; i < numOwners; ++i) {
            UUID id = PacketUtils.readUUID(buf);
            String name = buf.m_130136_(Short.MAX_VALUE);
            Rank rank = this.ranks.get(buf.m_130242_());
            if (rank.getId() == 0) {
                this.colonyOwner = id;
            }
            this.players.put(id, new ColonyPlayer(id, name, rank));
        }
    }

    @Override
    public Rank getRank(@NotNull Player player) {
        return this.getRank(player.m_20148_());
    }

    @Override
    public Rank getRank(int id) {
        return this.ranks.get(id);
    }

    @Override
    public void restoreOwnerIfNull() {
    }

    @Override
    @NotNull
    public Rank getRank(UUID id) {
        ColonyPlayer player = this.players.get(id);
        return player == null ? this.ranks.getOrDefault(3, MISSINGNO_RANK) : player.getRank();
    }

    @Override
    public boolean hasPermission(@NotNull Player player, @NotNull Action action) {
        return this.hasPermission(this.getRank(player), action);
    }

    @Override
    public boolean addPlayer(@NotNull String player, Rank rank, Level world) {
        return false;
    }

    @Override
    public boolean addPlayer(@NotNull UUID id, String name, Rank rank) {
        return false;
    }

    @Override
    @Nullable
    public String getOwnerName() {
        Map.Entry<UUID, ColonyPlayer> owner;
        if (this.ownerName.isEmpty() && (owner = this.getOwnerEntry()) != null) {
            this.ownerName = owner.getValue().getName();
        }
        return this.ownerName;
    }

    @Override
    public boolean isSubscriber(@NotNull Player player) {
        return false;
    }

    @Override
    public boolean isColonyMember(@NotNull Player player) {
        return this.players.containsKey(player.m_20148_());
    }

    @Override
    public Map<Integer, Rank> getRanks() {
        return this.ranks;
    }

    @Override
    public Rank getRankOwner() {
        return this.ranks.get(0);
    }

    @Override
    public Rank getRankOfficer() {
        return this.ranks.get(1);
    }

    @Override
    public Rank getRankFriend() {
        return this.ranks.get(2);
    }

    @Override
    public Rank getRankNeutral() {
        return this.ranks.get(3);
    }

    @Override
    public Rank getRankHostile() {
        return this.ranks.get(4);
    }

    @Override
    public void addRank(String name) {
    }

    @Override
    public void removeRank(Rank rank) {
        if (!rank.isInitial()) {
            this.ranks.remove(rank.getId());
        }
    }
}

