/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Image;
import com.ldtteam.blockui.controls.Text;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.Network;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.network.messages.server.GetColonyInfoMessage;
import com.minecolonies.core.network.messages.server.PickupBlockMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyAbandonOwnMessage;
import com.minecolonies.core.network.messages.server.colony.ColonyDeleteOwnMessage;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class WindowTownHallDeleteAbandonColony
extends AbstractWindowSkeleton {
    private static final String DELETE_PROCEED = "com.minecolonies.core.gui.colony.delete.proceed";
    private static final String ABANDON_PROCEED = "com.minecolonies.core.gui.colony.abandon.proceed";
    private static final String DELETE_WARNING = "com.minecolonies.core.gui.colony.delete.warning";
    private static final String ABANDON_WARNING = "com.minecolonies.core.gui.colony.abandon.warning";
    private final BlockPos pos;

    public WindowTownHallDeleteAbandonColony(BlockPos pos, String oldColonyName, BlockPos oldColonyPos, int oldColonyId) {
        super("minecolonies:gui/townhall/windowdeleteabandoncolony.xml");
        this.pos = pos;
        this.mc.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        this.registerButton("cancel", this::close);
        this.registerButton("pickup", this::pickup);
        this.registerButton("delete", this::deleteColony);
        this.registerButton("abandon", this::abandonColony);
        this.registerButton("cancelaction", this::cancel);
        this.registerButton("confirmdelete", this::confirmDeleteColony);
        this.registerButton("confirmabandon", this::confirmAbandonColony);
        if (((Boolean)MineColonies.getConfig().getServer().allowInfiniteColonies.get()).booleanValue()) {
            ((ButtonImage)this.findPaneOfTypeByID("abandon", ButtonImage.class)).show();
            ((Text)this.findPaneOfTypeByID("warningtext", Text.class)).setText(Component.m_237110_((String)ABANDON_WARNING, (Object[])new Object[]{oldColonyPos.m_123341_(), oldColonyPos.m_123342_(), oldColonyPos.m_123343_(), Component.m_237113_((String)oldColonyName).m_130940_(ChatFormatting.DARK_RED)}));
        } else {
            ((ButtonImage)this.findPaneOfTypeByID("abandon", ButtonImage.class)).hide();
            ((Text)this.findPaneOfTypeByID("warningtext", Text.class)).setText(Component.m_237110_((String)DELETE_WARNING, (Object[])new Object[]{oldColonyPos.m_123341_(), oldColonyPos.m_123342_(), oldColonyPos.m_123343_(), Component.m_237113_((String)oldColonyName).m_130940_(ChatFormatting.DARK_RED)}));
        }
    }

    private void confirmAbandonColony() {
        Network.getNetwork().sendToServer(new ColonyAbandonOwnMessage());
        Network.getNetwork().sendToServer(new GetColonyInfoMessage(this.pos));
        this.close();
    }

    private void confirmDeleteColony() {
        Network.getNetwork().sendToServer(new ColonyDeleteOwnMessage());
        Network.getNetwork().sendToServer(new GetColonyInfoMessage(this.pos));
        this.close();
    }

    private void abandonColony() {
        ((Image)this.findPaneOfTypeByID("dialog", Image.class)).show();
        Text confirmText = (Text)this.findPaneOfTypeByID("confirmtext", Text.class);
        confirmText.show();
        confirmText.setText(Component.m_237115_((String)ABANDON_PROCEED));
        ((ButtonImage)this.findPaneOfTypeByID("confirmdelete", ButtonImage.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID("confirmabandon", ButtonImage.class)).show();
        ((ButtonImage)this.findPaneOfTypeByID("cancelaction", ButtonImage.class)).show();
    }

    private void deleteColony() {
        ((Image)this.findPaneOfTypeByID("dialog", Image.class)).show();
        Text confirmText = (Text)this.findPaneOfTypeByID("confirmtext", Text.class);
        confirmText.show();
        confirmText.setText(Component.m_237115_((String)DELETE_PROCEED));
        ((ButtonImage)this.findPaneOfTypeByID("confirmdelete", ButtonImage.class)).show();
        ((ButtonImage)this.findPaneOfTypeByID("confirmabandon", ButtonImage.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID("cancelaction", ButtonImage.class)).show();
    }

    private void cancel() {
        ((Image)this.findPaneOfTypeByID("dialog", Image.class)).hide();
        ((Text)this.findPaneOfTypeByID("confirmtext", Text.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID("confirmdelete", ButtonImage.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID("confirmabandon", ButtonImage.class)).hide();
        ((ButtonImage)this.findPaneOfTypeByID("cancelaction", ButtonImage.class)).hide();
    }

    private void pickup() {
        Network.getNetwork().sendToServer(new PickupBlockMessage(this.pos));
        this.close();
    }
}

