/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.structurize.storage.ClientFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.WindowBuildDecoration;
import com.minecolonies.core.network.messages.server.DecorationBuildRequestMessage;
import com.minecolonies.core.tileentities.TileEntityDecorationController;
import java.nio.file.Path;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class WindowDecorationController
extends AbstractWindowSkeleton {
    private static final String HUT_NAME_RESOURCE_SUFFIX = ":gui/windowdecorationcontroller.xml";
    private final TileEntityDecorationController controller;
    private final Level world;

    public WindowDecorationController(BlockPos b) {
        super("minecolonies:gui/windowdecorationcontroller.xml");
        this.world = Minecraft.m_91087_().f_91073_;
        this.controller = (TileEntityDecorationController)this.world.m_7702_(b);
        this.registerButton("build", this::buildClicked);
        this.registerButton("repair", this::repairClicked);
        this.registerButton("cancel", this::cancelClicked);
        ((Text)this.findPaneOfTypeByID("name", Text.class)).setText(Component.m_237113_((String)this.controller.getBlueprintPath()));
        IColonyView view = IColonyManager.getInstance().getClosestColonyView(this.world, this.controller.m_58899_());
        Button buttonBuild = (Button)this.findPaneOfTypeByID("build", Button.class);
        this.findPaneByID("repair").hide();
        this.findPaneByID("build").hide();
        if (view != null) {
            Optional<IWorkOrderView> wo = view.getWorkOrders().stream().filter(w -> w.getLocation().equals((Object)this.controller.m_58899_())).findFirst();
            int level = Utils.getBlueprintLevel(this.controller.getBlueprintPath());
            if (wo.isPresent()) {
                this.findPaneByID("build").show();
                buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.cancelbuild"));
                if (wo.get().getWorkOrderType() == WorkOrderType.REPAIR) {
                    buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.cancelrepair"));
                }
            } else {
                buttonBuild.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.upgrade"));
                try {
                    String cleanedPackName = this.controller.getPackName().replace(Minecraft.m_91087_().f_91074_.m_20148_().toString(), "");
                    ClientFutureProcessor.queueBlueprint((ClientFutureProcessor.BlueprintProcessingData)new ClientFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)cleanedPackName, (Path)StructurePacks.getStructurePack((String)cleanedPackName).getPath().resolve(this.controller.getBlueprintPath())), blueprint -> {
                        BlockState blockState;
                        if (blueprint != null && (blockState = blueprint.m_8055_(blueprint.getPrimaryBlockOffset())).m_60734_() == ModBlocks.blockDecorationPlaceholder) {
                            this.findPaneByID("repair").show();
                        }
                    }));
                    if (level != -1) {
                        String path = this.controller.getBlueprintPath().replace(level + ".blueprint", level + 1 + ".blueprint");
                        ClientFutureProcessor.queueBlueprint((ClientFutureProcessor.BlueprintProcessingData)new ClientFutureProcessor.BlueprintProcessingData(StructurePacks.getBlueprintFuture((String)cleanedPackName, (Path)StructurePacks.getStructurePack((String)cleanedPackName).getPath().resolve(path)), blueprint -> {
                            BlockState blockState;
                            if (blueprint != null && (blockState = blueprint.m_8055_(blueprint.getPrimaryBlockOffset())).m_60734_() == ModBlocks.blockDecorationPlaceholder) {
                                this.findPaneByID("build").show();
                            }
                        }));
                    }
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Unable to retrieve blueprint");
                }
            }
        }
    }

    private void cancelClicked() {
        this.close();
    }

    private void buildClicked() {
        int level = Utils.getBlueprintLevel(this.controller.getBlueprintPath());
        String path = this.controller.getBlueprintPath().replace(level + ".blueprint", level + 1 + ".blueprint");
        this.close();
        new WindowBuildDecoration(this.controller.m_58899_(), this.controller.getPackName(), path, this.controller.getRotation(), this.controller.getMirror(), builder -> new DecorationBuildRequestMessage(WorkOrderType.BUILD, this.controller.m_58899_(), this.controller.getPackName(), path, (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_(), this.controller.getRotation(), this.controller.getMirror(), (BlockPos)builder)).open();
    }

    private void repairClicked() {
        this.close();
        new WindowBuildDecoration(this.controller.m_58899_(), this.controller.getPackName(), this.controller.getBlueprintPath(), this.controller.getRotation(), this.controller.getMirror(), builder -> new DecorationBuildRequestMessage(WorkOrderType.REPAIR, this.controller.m_58899_(), this.controller.getPackName(), this.controller.getBlueprintPath(), (ResourceKey<Level>)Minecraft.m_91087_().f_91073_.m_46472_(), this.controller.getRotation(), this.controller.getMirror(), (BlockPos)builder)).open();
    }
}

