/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.minecolonies.api.blocks.AbstractBlockMinecoloniesHorizontal;
import com.minecolonies.api.blocks.interfaces.IBuildingBrowsableBlock;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.api.entity.ai.workers.util.IBuilderUndestroyable;
import com.minecolonies.core.client.gui.WindowPlantationField;
import com.minecolonies.core.colony.fields.PlantationField;
import com.minecolonies.core.tileentities.TileEntityPlantationField;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockPlantationField
extends AbstractBlockMinecoloniesHorizontal<BlockPlantationField>
implements IBuilderUndestroyable,
IAnchorBlock,
IBuildingBrowsableBlock,
EntityBlock {
    public static final BooleanProperty MIRROR = BooleanProperty.m_61465_((String)"mirror");
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "blockhutplantationfield";
    private static final float RESISTANCE = 1.0f;
    private static final Map<Direction, VoxelShape> SHAPES = new EnumMap<Direction, VoxelShape>(Direction.class);

    public BlockPlantationField() {
        super(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283825_).m_60918_(SoundType.f_56736_).m_60913_(5.0f, 1.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)MIRROR, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityPlantationField(blockPos, blockState);
    }

    @NotNull
    public BlockState m_6843_(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)f_54117_, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)f_54117_)));
    }

    @NotNull
    public BlockState m_6943_(@NotNull BlockState state, Mirror mirrorIn) {
        return (BlockState)state.m_61124_((Property)MIRROR, (Comparable)Boolean.valueOf(mirrorIn != Mirror.NONE));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (worldIn.f_46443_) {
            if (hand == InteractionHand.OFF_HAND) {
                return InteractionResult.FAIL;
            }
            BlockEntity tileEntity = worldIn.m_7702_(pos);
            if (tileEntity instanceof TileEntityPlantationField) {
                TileEntityPlantationField plantationField = (TileEntityPlantationField)tileEntity;
                new WindowPlantationField(plantationField).open();
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)f_54117_);
        if (SHAPES.containsKey(dir)) {
            return SHAPES.get(dir);
        }
        VoxelShape shape = Shapes.m_83048_((double)(0.0 + (dir.m_122429_() > 0 ? 0.5 : 0.0)), (double)0.0, (double)(0.0 + (dir.m_122431_() > 0 ? 0.5 : 0.0)), (double)(1.0 - (dir.m_122429_() < 0 ? 0.5 : 0.0)), (double)0.625, (double)(1.0 - (dir.m_122431_() < 0 ? 0.5 : 0.0)));
        SHAPES.put(dir, shape);
        return shape;
    }

    public void m_7592_(Level worldIn, BlockPos pos, Explosion explosionIn) {
        this.notifyColonyAboutDestruction(worldIn, pos);
        super.m_7592_(worldIn, pos, explosionIn);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)f_54117_, (Comparable)context.m_8125_());
    }

    public void m_6402_(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        if (worldIn.f_46443_) {
            return;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (tileEntity instanceof TileEntityPlantationField) {
            TileEntityPlantationField tileEntityPlantationField = (TileEntityPlantationField)tileEntity;
            IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos);
            if (colony != null) {
                for (FieldRegistries.FieldEntry plantationFieldType : tileEntityPlantationField.getPlantationFieldTypes()) {
                    PlantationField plantationField = PlantationField.create(plantationFieldType, pos);
                    List<BlockPos> workingPositions = tileEntityPlantationField.getWorkingPositions(plantationField.getModule().getWorkTag());
                    List<BlockPos> validPositions = plantationField.getModule().getValidWorkingPositions(worldIn, workingPositions);
                    if (validPositions.isEmpty()) continue;
                    plantationField.setWorkingPositions(validPositions);
                    colony.getBuildingManager().addField(plantationField);
                    colony.getBuildingManager().addLeisureSite(pos);
                }
            }
        }
    }

    public void m_5707_(Level worldIn, @NotNull BlockPos pos, BlockState state, @NotNull Player player) {
        this.notifyColonyAboutDestruction(worldIn, pos);
        super.m_5707_(worldIn, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, MIRROR});
    }

    private void notifyColonyAboutDestruction(Level worldIn, BlockPos pos) {
        BlockEntity blockEntity;
        IColony colony;
        if (!worldIn.m_5776_() && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos)) != null && (blockEntity = worldIn.m_7702_(pos)) instanceof TileEntityPlantationField) {
            TileEntityPlantationField plantationField = (TileEntityPlantationField)blockEntity;
            for (FieldRegistries.FieldEntry plantationFieldType : plantationField.getPlantationFieldTypes()) {
                colony.getBuildingManager().removeField(field -> field.getFieldType().equals(plantationFieldType) && field.getPosition().equals((Object)pos));
                colony.getBuildingManager().removeLeisureSite(pos);
            }
        }
    }
}

