/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.citizen.happiness;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.entity.citizen.happiness.AbstractHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.HappinessRegistry;
import com.minecolonies.api.entity.citizen.happiness.IHappinessSupplierWrapper;
import com.minecolonies.api.entity.citizen.happiness.ITimeBasedHappinessModifier;
import net.minecraft.nbt.CompoundTag;

public final class ExpirationBasedHappinessModifier
extends AbstractHappinessModifier
implements ITimeBasedHappinessModifier {
    private int days = 0;
    private int period;
    private boolean inverted;

    public ExpirationBasedHappinessModifier(String id, double weight, IHappinessSupplierWrapper supplier, int period) {
        super(id, weight, supplier);
        this.period = period;
    }

    public ExpirationBasedHappinessModifier(String id, double weight, IHappinessSupplierWrapper supplier, int period, boolean inverted) {
        this(id, weight, supplier, period);
        this.inverted = inverted;
    }

    public ExpirationBasedHappinessModifier() {
    }

    @Override
    public double getFactor(ICitizenData data) {
        if (this.inverted) {
            if (this.days <= this.period) {
                return 1.0;
            }
            return super.getFactor(data);
        }
        if (this.days < this.period) {
            return super.getFactor(data);
        }
        return 1.0;
    }

    @Override
    public void reset() {
        this.days = this.period;
    }

    @Override
    public void dayEnd(ICitizenData data) {
        if (this.days > 0) {
            --this.days;
        }
    }

    @Override
    public int getDays() {
        return this.days;
    }

    @Override
    public void read(CompoundTag compoundNBT) {
        super.read(compoundNBT);
        this.days = compoundNBT.m_128451_("day");
        this.inverted = compoundNBT.m_128471_("inverted");
        this.period = compoundNBT.m_128451_("period");
    }

    @Override
    public void write(CompoundTag compoundNBT) {
        super.write(compoundNBT);
        compoundNBT.m_128359_("modifier", HappinessRegistry.EXPIRATION_MODIFIER.toString());
        compoundNBT.m_128405_("day", this.days);
        compoundNBT.m_128379_("inverted", this.inverted);
        compoundNBT.m_128405_("period", this.period);
    }
}

