/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.Tome;

public class RevertMessage {
    public static RevertMessage decode(FriendlyByteBuf buffer) {
        buffer.readByte();
        return new RevertMessage();
    }

    public static void encode(RevertMessage message, FriendlyByteBuf buffer) {
        buffer.writeByte(0);
    }

    public static void handle(RevertMessage message, Supplier<NetworkEvent.Context> context) {
        EccentricTome.LOGGER.debug("Received revert message.");
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            NetworkDirection direction = ((NetworkEvent.Context)context.get()).getDirection();
            InteractionHand hand = Tome.inHand((Player)player);
            if (hand != null) {
                ItemStack stack = player.m_21120_(hand);
                ItemStack tome = Tome.revert(stack);
                player.m_21008_(hand, Tome.attach(tome, stack));
                if (direction.getReceptionSide().isClient()) {
                    Minecraft.m_91087_().f_91063_.f_109055_.m_109320_(hand);
                }
            }
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }
}

