/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.concurrent.Executor;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ServerBoundSetSpeakerBlockPacket
implements Message {
    private final BlockPos pos;
    private final String str;
    private final SpeakerBlockTile.Mode mode;
    private final double volume;

    public ServerBoundSetSpeakerBlockPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.str = buf.m_130277_();
        this.mode = SpeakerBlockTile.Mode.values()[buf.readByte()];
        this.volume = buf.readDouble();
    }

    public ServerBoundSetSpeakerBlockPacket(BlockPos pos, String str, SpeakerBlockTile.Mode mode, double volume) {
        this.pos = pos;
        this.str = str;
        this.mode = mode;
        this.volume = volume;
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.str);
        buf.writeByte(this.mode.ordinal());
        buf.writeDouble(this.volume);
    }

    public void handle(ChannelHandler.Context context) {
        BlockEntity blockEntity;
        BlockPos pos;
        ServerPlayer sender = (ServerPlayer)context.getSender();
        Level level = sender.m_9236_();
        if (level.m_46805_(pos = this.pos) && (blockEntity = level.m_7702_(pos)) instanceof SpeakerBlockTile) {
            SpeakerBlockTile speaker = (SpeakerBlockTile)blockEntity;
            speaker.setVolume(this.volume);
            speaker.setMode(this.mode);
            sender.f_8906_.m_243132_(this.str).thenAcceptAsync(l -> this.updateSpeakerText(sender, (FilteredText)l), (Executor)sender.f_8924_);
        }
    }

    private void updateSpeakerText(ServerPlayer player, FilteredText filteredText) {
        SpeakerBlockTile be;
        BlockEntity blockEntity;
        player.m_9243_();
        Level level = player.m_9236_();
        if (level.m_46805_(this.pos) && (blockEntity = level.m_7702_(this.pos)) instanceof SpeakerBlockTile && (be = (SpeakerBlockTile)blockEntity).tryAcceptingClientText(player, filteredText)) {
            level.m_7260_(be.m_58899_(), be.m_58900_(), be.m_58900_(), 3);
            be.m_6596_();
        }
    }
}

