/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.fluids;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.supplementaries.common.block.blocks.GunpowderBlock;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteLiquidBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FlammableLiquidBlock
extends FiniteLiquidBlock
implements ILightable {
    public static final IntegerProperty AGE = BlockStateProperties.f_61410_;
    public final VoxelShape[] interactionShapes = (VoxelShape[])IntStream.range(0, 16).mapToObj(i -> FlammableLiquidBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)Math.max(0.0f, 15.0f * (1.0f - (float)i / (float)this.maxLevel)), (double)16.0)).toArray(VoxelShape[]::new);

    public FlammableLiquidBlock(Supplier<? extends FiniteFluid> supplier, BlockBehaviour.Properties arg) {
        super(supplier, arg.m_60953_(state -> (Integer)state.m_61143_((Property)AGE) > 0 ? 15 : 0));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE});
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 300;
    }

    public void onCaughtFire(BlockState state, Level world, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        BlockState newState = super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
        if (GunpowderBlock.isFireSource(neighborState)) {
            newState = (BlockState)newState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(1));
        }
        return newState;
    }

    @Override
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (!level.f_46443_) {
            level.m_186460_(pos, (Block)this, this.getReactToFireDelay());
        }
    }

    @Override
    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.m_6807_(state, world, pos, oldState, moving);
        if (!oldState.m_60713_(state.m_60734_()) && !world.f_46443_) {
            world.m_186460_(pos, (Block)this, this.getReactToFireDelay());
        }
    }

    private int getReactToFireDelay() {
        return 2;
    }

    private int getFireTickDelay(RandomSource random) {
        return 30 + random.m_188503_(10);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return this.interactWithPlayer(state, worldIn, pos, player, handIn);
    }

    public boolean lightUp(@Nullable Entity player, BlockState state, BlockPos pos, LevelAccessor world, ILightable.FireSourceType fireSourceType) {
        if ((Integer)state.m_61143_((Property)LEVEL) < 10 || world.m_6425_(pos.m_7494_()).m_76152_().m_6212_(state.m_60819_().m_76152_())) {
            return false;
        }
        return super.lightUp(player, state, pos, world, fireSourceType);
    }

    public boolean isLitUp(BlockState state, LevelAccessor level, BlockPos pos) {
        return FlammableLiquidBlock.isOnFire(state);
    }

    public static boolean isOnFire(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) > 0;
    }

    public void setLitUp(BlockState state, LevelAccessor world, BlockPos pos, boolean lit) {
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(lit ? 1 : 0)), 3);
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return FlammableLiquidBlock.isOnFire(state) ? this.interactionShapes[(Integer)state.m_61143_((Property)LEVEL)] : super.m_5940_(state, level, pos, context);
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.interactionShapes[(Integer)state.m_61143_((Property)LEVEL)];
    }

    public void m_5581_(Level level, BlockState state, BlockHitResult pHit, Projectile projectile) {
        BlockPos pos = pHit.m_82425_();
        this.interactWithProjectile(level, state, projectile, pos);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        boolean shouldBeOnFire = false;
        for (Direction direction : context.m_6232_()) {
            if (!GunpowderBlock.isFireSource((LevelAccessor)level, pos.m_121945_(direction))) continue;
            shouldBeOnFire = true;
            break;
        }
        return (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(shouldBeOnFire ? 1 : 0));
    }

    @Override
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (!FlammableLiquidBlock.isOnFire(state)) {
            return;
        }
        if (random.m_188503_(24) == 0) {
            level.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11936_, SoundSource.BLOCKS, 1.0f + random.m_188501_(), random.m_188501_() * 0.7f + 0.3f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double d = (double)pos.m_123341_() + random.m_188500_();
            double e = (double)pos.m_123342_() + random.m_188500_() * 0.5 + 0.5;
            double f = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            this.interactWithProjectile(level, state, projectile, pos);
        }
        if (FlammableLiquidBlock.isOnFire(state)) {
            if (!entity.m_5825_()) {
                entity.m_7311_(entity.m_20094_() + 1);
                if (entity.m_20094_() == 0) {
                    entity.m_20254_(8);
                }
            }
            entity.m_6469_(level.m_269111_().m_269387_(), 1.0f);
        }
        super.m_7892_(state, level, pos, entity);
    }

    protected void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.m_5776_() && FlammableLiquidBlock.isOnFire(state)) {
            level.m_5898_(null, 1009, pos, 0);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_186460_(pos, (Block)this, this.getFireTickDelay(level.f_46441_));
        if (level.m_46469_().m_46207_(GameRules.f_46131_) && FlammableLiquidBlock.isOnFire(state)) {
            boolean burnout;
            int age = (Integer)state.m_61143_((Property)AGE);
            int layers = (Integer)state.m_61143_((Property)LEVEL);
            int ageAdd = random.m_188503_(3) / 2;
            int ageIncrease = Math.min(15, age + ageAdd);
            if (age != ageIncrease) {
                state = (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(ageIncrease));
                level.m_7731_(pos, state, 4);
            }
            int k = (burnout = level.m_204166_(pos).m_203656_(BiomeTags.f_263839_)) ? -50 : 0;
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        }
    }

    @Override
    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        super.m_213898_(state, level, pos, random);
        if (FlammableLiquidBlock.isOnFire(state)) {
            Blocks.f_49991_.m_213898_(Blocks.f_49991_.m_49966_(), level, pos, random);
        }
    }

    @Override
    public boolean m_6724_(BlockState state) {
        return true;
    }
}

