/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.fluids;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.fluids.FiniteFluid;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class FiniteLiquidBlock
extends Block
implements BucketPickup {
    public static final VoxelShape STABLE_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61422_;
    private final List<FluidState> stateCache;
    private final FiniteFluid fluid;
    public final int maxLevel;
    private boolean fluidStateCacheInitialized = false;

    public FiniteLiquidBlock(Supplier<? extends FiniteFluid> supplier, BlockBehaviour.Properties arg) {
        super(arg);
        this.fluid = supplier.get();
        this.maxLevel = this.fluid.maxLayers;
        assert (this.maxLevel <= 16);
        this.stateCache = Lists.newArrayList();
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(state, level, pos, random);
    }

    public FluidState m_5888_(BlockState state) {
        int i = (Integer)state.m_61143_((Property)LEVEL);
        if (!this.fluidStateCacheInitialized) {
            this.initFluidStateCache();
        }
        return this.stateCache.get(Math.min(i, this.maxLevel));
    }

    protected synchronized void initFluidStateCache() {
        if (!this.fluidStateCacheInitialized) {
            this.stateCache.add(this.fluid.makeState(this.maxLevel));
            for (int i = 1; i < this.maxLevel; ++i) {
                this.stateCache.add(this.fluid.makeState(this.maxLevel - i));
            }
            this.fluidStateCacheInitialized = true;
        }
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return context.m_6513_(STABLE_SHAPE, pos, true) && (Integer)state.m_61143_((Property)LEVEL) == 0 && context.m_203682_(level.m_6425_(pos.m_7494_()), state.m_60819_()) ? STABLE_SHAPE : Shapes.m_83040_();
    }

    public boolean m_6724_(BlockState state) {
        return state.m_60819_().m_76187_();
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        state.m_60819_().m_230562_((Level)level, pos, random);
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return true;
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction direction) {
        return adjacentBlockState.m_60819_().m_76152_().m_6212_((Fluid)this.fluid);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public List<ItemStack> m_49635_(BlockState arg, LootParams.Builder arg2) {
        return Collections.emptyList();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.m_186469_(pos, state.m_60819_().m_76152_(), this.fluid.m_6718_((LevelReader)level));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (state.m_60819_().m_76170_() || neighborState.m_60819_().m_76170_()) {
            level.m_186469_(currentPos, state.m_60819_().m_76152_(), this.fluid.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        level.m_186469_(pos, state.m_60819_().m_76152_(), this.fluid.m_6718_((LevelReader)level));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{LEVEL});
    }

    public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        AtomicInteger currentLevel = new AtomicInteger(state.m_60819_().m_76186_());
        HashMap<BlockPos, Integer> posList = new HashMap<BlockPos, Integer>();
        posList.put(pos, 0);
        this.findConnectedFluids(level, pos, posList, currentLevel);
        if (currentLevel.get() < this.maxLevel) {
            return ItemStack.f_41583_;
        }
        for (Map.Entry entry : posList.entrySet()) {
            BlockPos p = (BlockPos)entry.getKey();
            Integer value = (Integer)entry.getValue();
            if (value == 0) {
                level.m_7731_(p, Blocks.f_50016_.m_49966_(), 11);
                continue;
            }
            level.m_7731_(p, this.fluid.makeState(value).m_76188_(), 11);
        }
        return new ItemStack((ItemLike)this.fluid.m_6859_());
    }

    private void findConnectedFluids(LevelAccessor level, BlockPos pos, Map<BlockPos, Integer> remainders, AtomicInteger currentLevel) {
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.offer(pos);
        while (!queue.isEmpty()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                int l;
                BlockState state;
                if (currentLevel.get() >= this.maxLevel) {
                    return;
                }
                BlockPos newPos = currentPos.m_121945_(direction);
                if (remainders.containsKey(newPos) || !((state = level.m_8055_(newPos)).m_60734_() instanceof FiniteLiquidBlock) || (l = state.m_60819_().m_76186_()) <= 0) continue;
                currentLevel.addAndGet(l);
                remainders.put(newPos, Math.max(0, currentLevel.get() - this.maxLevel));
                queue.offer(newPos);
            }
        }
    }

    public Optional<SoundEvent> m_142298_() {
        return this.fluid.m_142520_();
    }
}

