/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.hourglass;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.misc.RegistryAccessJsonReloadListener;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.hourglass.HourglassTimeData;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncHourglassPacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class HourglassTimesManager
extends RegistryAccessJsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final HourglassTimesManager RELOAD_INSTANCE = new HourglassTimesManager();
    private final Map<Item, HourglassTimeData> dustsMap = new Object2ObjectOpenHashMap();
    private final Set<HourglassTimeData> dusts = new HashSet<HourglassTimeData>();

    public HourglassTimesManager() {
        super(GSON, "hourglass_dusts");
    }

    public void parse(Map<ResourceLocation, JsonElement> jsonMap, RegistryAccess access) {
        this.dusts.clear();
        this.dustsMap.clear();
        ArrayList<HourglassTimeData> list = new ArrayList<HourglassTimeData>();
        jsonMap.forEach((key, json) -> {
            try {
                DataResult result = HourglassTimeData.REGISTRY_CODEC.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)access), json);
                HourglassTimeData data = (HourglassTimeData)result.getOrThrow(false, e -> Supplementaries.LOGGER.error("Failed to parse hourglass data: {}", e));
                list.add(data);
            }
            catch (Exception e2) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for hourglass data " + key);
            }
        });
        list.sort(Comparator.comparing(HourglassTimeData::getOrdering));
        list.forEach(HourglassTimesManager::addData);
    }

    public static void addData(HourglassTimeData data) {
        HourglassTimesManager.RELOAD_INSTANCE.dusts.add(data);
        data.getItems().forEach(i -> {
            if (i.m_203334_() == Items.f_41852_) {
                boolean bl = true;
            } else {
                HourglassTimesManager.RELOAD_INSTANCE.dustsMap.put((Item)i.m_203334_(), data);
            }
        });
    }

    public static HourglassTimeData getData(Item item) {
        return HourglassTimesManager.RELOAD_INSTANCE.dustsMap.getOrDefault(item, HourglassTimeData.EMPTY);
    }

    public static void acceptClientData(List<HourglassTimeData> hourglass) {
        HourglassTimesManager.RELOAD_INSTANCE.dusts.clear();
        HourglassTimesManager.RELOAD_INSTANCE.dustsMap.clear();
        hourglass.forEach(HourglassTimesManager::addData);
    }

    public static void sendDataToClient(ServerPlayer player) {
        ModNetwork.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncHourglassPacket(HourglassTimesManager.RELOAD_INSTANCE.dusts));
    }
}

