/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens;

import com.mojang.blaze3d.platform.Lighting;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.client.screens.widgets.BlackBoardButton;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.network.ServerBoundSetBlackboardPacket;
import net.mehvahdjukaar.supplementaries.common.utils.CircularList;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.ImmediatelyFastCompat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class BlackBoardScreen
extends Screen {
    private static final MutableComponent CLEAR = Component.m_237115_((String)"gui.supplementaries.blackboard.clear");
    private static final MutableComponent UNDO = Component.m_237115_((String)"gui.supplementaries.blackboard.undo");
    private static final MutableComponent EDIT = Component.m_237115_((String)"gui.supplementaries.blackboard.edit");
    private final BlackboardBlockTile tile;
    private final BlackBoardButton[][] buttons = new BlackBoardButton[16][16];
    private final Deque<List<Entry>> history = new CircularList<List<Entry>>(20);
    private List<Entry> currentHistoryStep = new ArrayList<Entry>();
    private Button historyButton;

    private BlackBoardScreen(BlackboardBlockTile teBoard) {
        super((Component)EDIT);
        this.tile = teBoard;
    }

    public static void open(BlackboardBlockTile sign) {
        Minecraft.m_91087_().m_91152_((Screen)new BlackBoardScreen(sign));
    }

    public void m_86600_() {
        if (!this.isValid()) {
            this.m_7379_();
        } else if (!(this.m_7222_() instanceof BlackBoardButton)) {
            this.m_7522_(null);
        }
    }

    private boolean isValid() {
        return this.f_96541_ != null && this.f_96541_.f_91074_ != null && !this.tile.m_58901_() && !this.tile.playerIsTooFarAwayToEdit(this.tile.m_58904_(), this.tile.m_58899_(), this.f_96541_.f_91074_.m_20148_());
    }

    public void m_7379_() {
        this.tile.m_6596_();
        super.m_7379_();
    }

    public void m_7861_() {
        byte[][] pixels = new byte[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].getColor();
            }
        }
        ModNetwork.CHANNEL.sendToServer((Message)new ServerBoundSetBlackboardPacket(this.tile.m_58899_(), pixels));
    }

    public void updateBlackboard(int x, int y, byte newColor) {
        this.tile.setPixel(x, y, newColor);
    }

    public void addHistory(int x, int y, byte oldColor) {
        this.currentHistoryStep.add(new Entry(x, y, oldColor));
    }

    public void saveHistoryStep() {
        if (!this.currentHistoryStep.isEmpty()) {
            this.history.add(this.currentHistoryStep);
            this.currentHistoryStep = new ArrayList<Entry>();
            this.historyButton.f_93623_ = true;
        }
    }

    public void onButtonDragged(double mx, double my, byte buttonValue) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                BlackBoardButton b = this.buttons[xx][yy];
                if (!b.m_5953_(mx, my) || b.getColor() == buttonValue) continue;
                b.setColor(buttonValue);
            }
        }
    }

    private void clearPressed(Button button) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy].setColor((byte)0);
            }
        }
        this.saveHistoryStep();
    }

    private void undoPressed(Button button) {
        if (!this.history.isEmpty()) {
            for (Entry v : this.history.pollLast()) {
                this.buttons[v.x()][v.y()].setColor(v.color());
            }
            this.currentHistoryStep.clear();
        }
        if (this.history.isEmpty()) {
            this.historyButton.f_93623_ = false;
        }
    }

    protected void m_7856_() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                byte pixel = this.tile.getPixel(xx, yy);
                BlackBoardButton widget = new BlackBoardButton(this.f_96543_ / 2, 65, xx, yy, this, pixel);
                this.buttons[xx][yy] = (BlackBoardButton)this.m_142416_(widget);
            }
        }
        int buttonW = 56;
        int sep = 4;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CLEAR, this::clearPressed).m_252987_(this.f_96543_ / 2 - buttonW / 2 - buttonW + sep / 2, this.f_96544_ / 4 + 120, buttonW - sep, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, button -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - buttonW / 2 + sep / 2, this.f_96544_ / 4 + 120, buttonW - sep, 20).m_253136_());
        this.historyButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)UNDO, this::undoPressed).m_252987_(this.f_96543_ / 2 + buttonW / 2 + sep / 2, this.f_96544_ / 4 + 120, buttonW - sep, 20).m_253136_());
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (CompatHandler.IMMEDIATELY_FAST) {
            ImmediatelyFastCompat.startBatching();
        }
        Lighting.m_84930_();
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        graphics.m_280168_().m_85836_();
        int ut = -1;
        int vt = -1;
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                if (this.buttons[xx][yy].isHovered()) {
                    ut = xx;
                    vt = yy;
                }
                this.buttons[xx][yy].m_88315_(graphics, mouseX, mouseY, partialTicks);
            }
        }
        if (ut != -1) {
            this.buttons[ut][vt].renderTooltip(graphics);
        }
        graphics.m_280168_().m_85849_();
        Lighting.m_84931_();
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (CompatHandler.IMMEDIATELY_FAST) {
            ImmediatelyFastCompat.endBatching();
        }
    }

    private record Entry(int x, int y, byte color) {
    }
}

