/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.mehvahdjukaar.supplementaries.client.renderers.color.ColorHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class VertexUtils {
    public static int setColorForAge(float age, float phase) {
        float a = (age + phase) % 1.0f;
        float[] col = ColorHelper.getBubbleColor(a);
        return FastColor.ARGB32.m_13660_((int)255, (int)((int)(col[0] * 255.0f)), (int)((int)(col[1] * 255.0f)), (int)((int)(col[2] * 255.0f)));
    }

    public static void renderBubble(VertexConsumer builder, PoseStack poseStack, float w, TextureAtlasSprite sprite, int combinedLightIn, BlockPos pos, Level level, float partialTicks) {
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasScaleU = sprite.m_118410_() - sprite.m_118409_();
        float atlasScaleV = sprite.m_118412_() - sprite.m_118411_();
        float minU = sprite.m_118409_();
        float minV = sprite.m_118411_();
        float maxU = minU + atlasScaleU * w;
        float maxV = minV + atlasScaleV * w;
        float maxV2 = minV + atlasScaleV * w;
        long t = level == null ? System.currentTimeMillis() / 50L : level.m_46467_();
        float time = ((float)Math.floorMod((long)pos.m_123341_() * 7L + (long)pos.m_123342_() * 9L + (long)pos.m_123343_() * 13L + t, 100L) + partialTicks) / 100.0f;
        int cUnw = VertexUtils.setColorForAge(time, 0.0f);
        int cUne = VertexUtils.setColorForAge(time, 0.15f);
        int cUse = VertexUtils.setColorForAge(time, 0.55f);
        int cUsw = VertexUtils.setColorForAge(time, 0.35f);
        int cDnw = VertexUtils.setColorForAge(time, 0.45f);
        int cDne = VertexUtils.setColorForAge(time, 0.85f);
        int cDse = VertexUtils.setColorForAge(time, 1.0f);
        int cDsw = VertexUtils.setColorForAge(time, 0.65f);
        float amp = (float)(ClientConfigs.Blocks.BUBBLE_BLOCK_WOBBLE.get() / 10.0);
        w -= 2.0f * amp;
        float unw = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.0f)));
        float une = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.25f)));
        float use = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.5f)));
        float usw = amp * Mth.m_14089_((float)((float)Math.PI * 2 * (time + 0.75f)));
        float dnw = use;
        float dne = usw;
        float dse = unw;
        float dsw = une;
        float l = w / 2.0f;
        VertexUtils.vert(builder, poseStack, -l - usw, l + usw, l + usw, minU, maxV2, cUsw, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, l + use, l + use, l + use, maxU, maxV2, cUse, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, l + une, l + une, -l - une, maxU, minV, cUne, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, -l - unw, l + unw, -l - unw, minU, minV, cUnw, lu, lv, 0.0f, 1.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, -l - dnw, -l - dnw, -l - dnw, minU, maxV2, cDnw, lu, lv, 0.0f, -1.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, l + dne, -l - dne, -l - dne, maxU, maxV2, cDne, lu, lv, 0.0f, -1.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, l + dse, -l - dse, l + dse, maxU, minV, cDse, lu, lv, 0.0f, -1.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, -l - dsw, -l - dsw, l + dsw, minU, minV, cDsw, lu, lv, 0.0f, -1.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, l + dne, -l - dne, -l - dne, minU, maxV, cDne, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexUtils.vert(builder, poseStack, -l - dnw, -l - dnw, -l - dnw, maxU, maxV, cDnw, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexUtils.vert(builder, poseStack, -l - unw, l + unw, -l - unw, maxU, minV, cUnw, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexUtils.vert(builder, poseStack, l + une, l + une, -l - une, minU, minV, cUne, lu, lv, 0.0f, 0.0f, 1.0f);
        VertexUtils.vert(builder, poseStack, -l - dnw, -l - dnw, -l - dnw, minU, maxV, cDnw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, -l - dsw, -l - dsw, l + dsw, maxU, maxV, cDsw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, -l - usw, l + usw, l + usw, maxU, minV, cUsw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, -l - unw, l + unw, -l - unw, minU, minV, cUnw, lu, lv, -1.0f, 0.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, -l - dsw, -l - dsw, l + dsw, minU, maxV, cDsw, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexUtils.vert(builder, poseStack, l + dse, -l - dse, l + dse, maxU, maxV, cDse, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexUtils.vert(builder, poseStack, l + use, l + use, l + use, maxU, minV, cUse, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexUtils.vert(builder, poseStack, -l - usw, l + usw, l + usw, minU, minV, cUsw, lu, lv, 0.0f, 0.0f, -1.0f);
        VertexUtils.vert(builder, poseStack, l + dse, -l - dse, l + dse, minU, maxV, cDse, lu, lv, 1.0f, 0.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, l + dne, -l - dne, -l - dne, maxU, maxV, cDne, lu, lv, 1.0f, 0.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, l + une, l + une, -l - une, maxU, minV, cUne, lu, lv, 1.0f, 0.0f, 0.0f);
        VertexUtils.vert(builder, poseStack, l + use, l + use, l + use, minU, minV, cUse, lu, lv, 1.0f, 0.0f, 0.0f);
    }

    public static void vert(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int color, int lu, int lv, float nx, float ny, float nz) {
        builder.m_252986_(poseStack.m_85850_().m_252922_(), x, y, z);
        builder.m_193479_(color);
        builder.m_7421_(u, v);
        builder.m_7122_(0, 10);
        builder.m_7120_(lu, lv);
        builder.m_5601_(nx, ny, nz);
        builder.m_5752_();
    }

    public static void renderFish(VertexConsumer builder, PoseStack poseStack, float wo, float ho, int fishType, int combinedLightIn) {
        int textW = 64;
        int textH = 32;
        int fishW = 5;
        int fishH = 4;
        int fishv = --fishType % (textH / fishH);
        int fishu = fishType / (textH / fishH);
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(ModTextures.FISHIES_TEXTURE);
        float w = (float)fishW / (float)textW;
        float h = (float)fishH / (float)textH;
        float hw = 4.0f * w / 2.0f;
        float hh = 2.0f * h / 2.0f;
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasscaleU = sprite.m_118410_() - sprite.m_118409_();
        float atlasscaleV = sprite.m_118412_() - sprite.m_118411_();
        float minu = sprite.m_118409_() + atlasscaleU * (float)fishu * w;
        float minv = sprite.m_118411_() + atlasscaleV * (float)fishv * h;
        float maxu = atlasscaleU * w + minu;
        float maxv = atlasscaleV * h + minv;
        for (int k = 0; k < 2; ++k) {
            for (int j = 0; j < 2; ++j) {
                VertexUtil.vert((VertexConsumer)builder, (PoseStack)poseStack, (float)(hw - Math.abs(wo / 2.0f)), (float)(-hh + ho), (float)wo, (float)minu, (float)maxv, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
                VertexUtil.vert((VertexConsumer)builder, (PoseStack)poseStack, (float)(-hw + Math.abs(wo / 2.0f)), (float)(-hh + ho), (float)(-wo), (float)maxu, (float)maxv, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
                VertexUtil.vert((VertexConsumer)builder, (PoseStack)poseStack, (float)(-hw + Math.abs(wo / 2.0f)), (float)(hh + ho), (float)(-wo), (float)maxu, (float)minv, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
                VertexUtil.vert((VertexConsumer)builder, (PoseStack)poseStack, (float)(hw - Math.abs(wo / 2.0f)), (float)(hh + ho), (float)wo, (float)minu, (float)minv, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (int)lu, (int)lv, (float)0.0f, (float)1.0f, (float)0.0f);
                poseStack.m_252781_(RotHlpr.Y180);
                float temp = minu;
                minu = maxu;
                maxu = temp;
            }
            lu = 240;
            minu += atlasscaleU / 2.0f;
            maxu += atlasscaleU / 2.0f;
        }
    }
}

