/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialProcessingTile;
import com.buuz135.industrial.config.machine.resourceproduction.ResourcefulFurnaceConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.tile.BasicTile;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.component.IComponentBundle;
import com.hrznstudio.titanium.component.bundle.LockableInventoryBundle;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.util.InventoryUtil;
import com.hrznstudio.titanium.util.ItemHandlerUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.ItemHandlerHelper;

public class PotionBrewerTile
extends IndustrialProcessingTile<PotionBrewerTile> {
    @Save
    private SidedFluidTankComponent<PotionBrewerTile> water;
    @Save
    private ProgressBarComponent<PotionBrewerTile> blaze;
    @Save
    private SidedInventoryComponent<PotionBrewerTile> blazeInput;
    @Save
    private SidedInventoryComponent<PotionBrewerTile> bottleInput;
    @Save
    private LockableInventoryBundle<PotionBrewerTile> brewingItems = new LockableInventoryBundle((BasicTile)this, new SidedInventoryComponent("brewingInput", 55, 19, 6, 3).setColor(DyeColor.BLUE).setInputFilter((stack, integer) -> true).setOutputFilter((stack, integer) -> false), 148, 40, false);
    @Save
    private SidedInventoryComponent<PotionBrewerTile> output;
    @Save
    private int state = 0;

    public PotionBrewerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.POTION_BREWER, 100, 38, blockPos, blockState);
        this.addBundle((IComponentBundle)this.brewingItems);
        this.water = (SidedFluidTankComponent)new SidedFluidTankComponent("water", 1000, 75, 40, 0).setColor(DyeColor.CYAN).setTankAction(FluidTankComponent.Action.FILL).setTankType(FluidTankComponent.Type.SMALL).setValidator(fluidStack -> fluidStack.getFluid().m_6212_((Fluid)Fluids.f_76193_));
        this.addTank(this.water);
        this.blaze = new ProgressBarComponent<PotionBrewerTile>(30, 20, 100){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<PotionBrewerTile>(30, 20, (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GOLD + "Blaze Fuel: " + ChatFormatting.WHITE + new DecimalFormat().format(PotionBrewerTile.this.blaze.getProgress()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(PotionBrewerTile.this.blaze.getMaxProgress()))));
                        return tooltip;
                    }
                });
            }
        }.setBarDirection(ProgressBarComponent.BarDirection.VERTICAL_UP).setColor(DyeColor.ORANGE).setCanReset(potionBrewerTile -> false).setCanIncrease(iComponentHarness -> false);
        this.addProgressBar(this.blaze);
        this.blazeInput = (SidedInventoryComponent)new SidedInventoryComponent("blazeInput", 45, 61, 1, 2).setColor(DyeColor.ORANGE).setInputFilter((stack, integer) -> stack.m_41720_().equals(Items.f_42593_)).setOutputFilter((stack, integer) -> false).setSlotToItemStackRender(0, new ItemStack((ItemLike)Items.f_42593_));
        this.addInventory((InventoryComponent)this.blazeInput);
        this.bottleInput = (SidedInventoryComponent)new SidedInventoryComponent("bottleInput", 123, 42, 1, 1).setColor(DyeColor.YELLOW).setInputFilter((stack, integer) -> stack.m_41720_().equals(Items.f_42590_)).setOutputFilter((stack, integer) -> false).setSlotToItemStackRender(0, new ItemStack((ItemLike)Items.f_42590_));
        this.addInventory((InventoryComponent)this.bottleInput);
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 82, 64, 3, 4).setColor(DyeColor.MAGENTA).setSlotLimit(1).setInputFilter((stack, integer) -> false).setOutputFilter((stack, integer) -> true);
        this.addInventory((InventoryComponent)this.output);
    }

    @Override
    public boolean canIncrease() {
        if (this.blaze.getProgress() + 20 <= this.blaze.getMaxProgress() && !this.blazeInput.getStackInSlot(0).m_41619_()) {
            this.blazeInput.getStackInSlot(0).m_41774_(1);
            this.blaze.setProgress(this.blaze.getProgress() + 20);
        }
        if (ItemHandlerUtil.isEmpty(this.output)) {
            this.state = 0;
        }
        if (this.state == 0) {
            return this.water.getFluidAmount() == 1000 && !this.bottleInput.getStackInSlot(0).m_41619_();
        }
        if (this.state >= 7) {
            this.state = 1;
        }
        return this.canBrew(this.state - 1) && this.blaze.getProgress() > 0;
    }

    @Override
    public Runnable onFinish() {
        return () -> {
            if (this.state == 0) {
                int bottleAmount = Math.min(3, this.bottleInput.getStackInSlot(0).m_41613_());
                for (int i = 0; i < bottleAmount; ++i) {
                    ItemHandlerHelper.insertItem(this.output, (ItemStack)PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_), (boolean)false);
                    this.bottleInput.getStackInSlot(0).m_41774_(1);
                }
                ++this.state;
            } else {
                this.brewPotions(this.state - 1);
                this.blaze.setProgress(this.blaze.getProgress() - 1);
                ++this.state;
                if (this.state >= 7) {
                    this.state = 1;
                }
            }
        };
    }

    @Override
    public ProgressBarComponent.BarDirection getBarDirection() {
        return ProgressBarComponent.BarDirection.ARROW_DOWN;
    }

    @Override
    protected int getTickPower() {
        return 80;
    }

    public PotionBrewerTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<PotionBrewerTile> createEnergyStorage() {
        return new EnergyStorageComponent(ResourcefulFurnaceConfig.maxStoredPower, 10, 20);
    }

    private boolean canBrew(int slot) {
        int i;
        ItemStack ingredient = this.brewingItems.getInventory().getStackInSlot(slot);
        NonNullList input = NonNullList.m_122779_();
        input.addAll((Collection)InventoryUtil.getStacks(this.output));
        int[] indices = new int[input.size()];
        for (i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        if (!ingredient.m_41619_()) {
            return BrewingRecipeRegistry.canBrew((NonNullList)input, (ItemStack)ingredient, (int[])indices);
        }
        if (ingredient.m_41619_()) {
            return false;
        }
        if (!PotionBrewing.m_43506_((ItemStack)ingredient)) {
            return false;
        }
        for (i = 0; i < 3; ++i) {
            ItemStack itemstack1 = this.output.getStackInSlot(i);
            if (itemstack1.m_41619_() || !PotionBrewing.m_43508_((ItemStack)itemstack1, (ItemStack)ingredient)) continue;
            return true;
        }
        return false;
    }

    private void brewPotions(int slot) {
        NonNullList input = NonNullList.m_122779_();
        input.addAll((Collection)InventoryUtil.getStacks(this.output));
        int[] indices = new int[input.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        ItemStack ingredient = this.brewingItems.getInventory().getStackInSlot(slot);
        input.add((Object)ingredient);
        if (ForgeEventFactory.onPotionAttemptBrew((NonNullList)input)) {
            return;
        }
        BrewingRecipeRegistry.brewPotions((NonNullList)input, (ItemStack)ingredient, (int[])indices);
        ingredient.m_41774_(1);
        ForgeEventFactory.onPotionBrewed((NonNullList)input);
        for (int i : indices) {
            this.output.setStackInSlot(i, (ItemStack)input.get(i));
        }
    }
}

