/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.network;

import java.lang.reflect.InvocationTargetException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import team.tnt.collectoralbum.network.api.IPacket;
import team.tnt.collectoralbum.network.packet.OpenCardScreenPacket;
import team.tnt.collectoralbum.network.packet.RequestAlbumPagePacket;
import team.tnt.collectoralbum.network.packet.RequestCardPackDropPacket;
import team.tnt.collectoralbum.network.packet.SendAlbumBoostsPacket;

public class Networking {
    private static final String VERSION = "1";
    private static final SimpleChannel NETWORK_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("collectorsalbum", "network")).networkProtocolVersion(() -> "1").clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).simpleChannel();
    private static int packetDescriptor;

    public static void dispatchServerPacket(IPacket<?> packet) {
        NETWORK_CHANNEL.send(PacketDistributor.SERVER.noArg(), packet);
    }

    public static void dispatchClientPacket(ServerPlayer serverPlayerRef, IPacket<?> packet) {
        NETWORK_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayerRef), packet);
    }

    public static void registerPackets() {
        Networking.registerPacket(OpenCardScreenPacket.class);
        Networking.registerPacket(RequestAlbumPagePacket.class);
        Networking.registerPacket(RequestCardPackDropPacket.class);
        Networking.registerPacket(SendAlbumBoostsPacket.class);
    }

    private static <T extends IPacket<T>> void registerPacket(Class<T> packetClass) {
        IPacket instance;
        try {
            instance = (IPacket)packetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        NETWORK_CHANNEL.messageBuilder(packetClass, packetDescriptor++).encoder(IPacket::encode).decoder(instance::decode).consumerNetworkThread(IPacket::handle).add();
    }
}

