/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.packs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectoralbum.CollectorsAlbum;
import team.tnt.collectoralbum.data.packs.ICardDropProvider;
import team.tnt.collectoralbum.data.packs.ICardDropSerializer;
import team.tnt.collectoralbum.util.JsonHelper;

public class TagCardProvider
implements ICardDropProvider {
    private final TagKey<Item> tag;

    private TagCardProvider(TagKey<Item> tag) {
        this.tag = tag;
    }

    @Override
    public List<ItemStack> provideDrops() {
        Random random = new Random();
        ArrayList holders = new ArrayList();
        BuiltInRegistries.f_257033_.m_206058_(this.tag).forEach(holders::add);
        if (holders.isEmpty()) {
            CollectorsAlbum.LOGGER.error("Attempted to provide items from empty or undefined tag {}", (Object)this.tag.f_203868_());
            return Collections.emptyList();
        }
        Holder holderRef = (Holder)holders.get(random.nextInt(holders.size()));
        ItemStack itemStack = new ItemStack(holderRef);
        return Collections.singletonList(itemStack);
    }

    public static class Serializer
    implements ICardDropSerializer<TagCardProvider> {
        @Override
        public TagCardProvider fromJson(JsonElement data) throws JsonParseException {
            JsonObject object = JsonHelper.asObject(data);
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"tag"));
            TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)id);
            return new TagCardProvider((TagKey<Item>)tagKey);
        }
    }
}

