/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.packs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import team.tnt.collectoralbum.data.packs.CardDropProviderType;
import team.tnt.collectoralbum.data.packs.ICardDropProvider;
import team.tnt.collectoralbum.data.packs.ICardDropSerializer;
import team.tnt.collectoralbum.util.JsonHelper;

public class RepeatedDropProvider
implements ICardDropProvider {
    private final int minRuns;
    private final int maxRuns;
    private final ICardDropProvider provider;

    private RepeatedDropProvider(int minRuns, int maxRuns, ICardDropProvider provider) {
        this.minRuns = minRuns;
        this.maxRuns = maxRuns;
        this.provider = provider;
    }

    @Override
    public List<ItemStack> provideDrops() {
        Random random = new Random();
        int count = this.minRuns + random.nextInt(this.maxRuns - this.minRuns + 1);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < count; ++i) {
            items.addAll(this.provider.provideDrops());
        }
        return items;
    }

    public static final class Serializer
    implements ICardDropSerializer<RepeatedDropProvider> {
        @Override
        public RepeatedDropProvider fromJson(JsonElement data) throws JsonParseException {
            JsonObject object = JsonHelper.asObject(data);
            int min = GsonHelper.m_13824_((JsonObject)object, (String)"min", (int)1);
            int max = GsonHelper.m_13824_((JsonObject)object, (String)"max", (int)min);
            JsonObject providerJson = GsonHelper.m_13930_((JsonObject)object, (String)"provider");
            Object provider = CardDropProviderType.fromJson((JsonElement)providerJson);
            if (min <= 0) {
                throw new JsonSyntaxException("Min run count cannot be smaller or equal to 0. Got " + min);
            }
            if (max <= 0) {
                throw new JsonSyntaxException("Max run count cannot be smaller or equal to 0. Got " + max);
            }
            if (min > max) {
                throw new JsonSyntaxException("Min count cannot be higher than max count! Got min: " + min + ", max: " + max);
            }
            return new RepeatedDropProvider(min, max, (ICardDropProvider)provider);
        }
    }
}

