/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.packs;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import team.tnt.collectoralbum.data.packs.ICardDropProvider;
import team.tnt.collectoralbum.data.packs.ICardDropSerializer;
import team.tnt.collectoralbum.util.JsonHelper;

public class ItemCardProvider
implements ICardDropProvider {
    private final Item item;

    private ItemCardProvider(Item item) {
        this.item = item;
    }

    @Override
    public List<ItemStack> provideDrops() {
        ItemStack itemStack = new ItemStack((ItemLike)this.item);
        return Collections.singletonList(itemStack);
    }

    public static class Serializer
    implements ICardDropSerializer<ItemCardProvider> {
        @Override
        public ItemCardProvider fromJson(JsonElement data) throws JsonParseException {
            JsonObject object = JsonHelper.asObject(data);
            ResourceLocation identifier = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"item"));
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(identifier);
            if (item == Items.f_41852_) {
                throw new JsonSyntaxException("Unknown item: " + identifier);
            }
            return new ItemCardProvider(item);
        }
    }
}

