/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.data.boosts;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;
import team.tnt.collectoralbum.common.init.ActionTypeRegistry;
import team.tnt.collectoralbum.data.boosts.ActionType;
import team.tnt.collectoralbum.data.boosts.IAction;
import team.tnt.collectoralbum.data.boosts.IActionSerializer;
import team.tnt.collectoralbum.data.boosts.IBoostContext;
import team.tnt.collectoralbum.data.boosts.OpType;
import team.tnt.collectoralbum.util.JsonHelper;
import team.tnt.collectoralbum.util.TextHelper;

public class GiveEffectsAction
implements IAction {
    private final IEffectFactory[] effects;
    private final Component[] description;

    private GiveEffectsAction(IEffectFactory[] effects) {
        this.effects = effects;
        this.description = GiveEffectsAction.generateDescriptionForEffects(effects);
    }

    @Override
    public ActionType<?> getType() {
        return ActionTypeRegistry.GIVE_EFFECTS;
    }

    public static Component[] generateDescriptionForEffects(IEffectFactory[] factories) {
        Component[] res = new Component[factories.length];
        int index = 0;
        for (IEffectFactory factory : factories) {
            MobEffectInstance instance = factory.makeEffect();
            Component displayText = instance.m_19544_().m_19482_();
            String amplifier = TextHelper.toRomanNumberString(instance.m_19564_() + 1);
            MutableComponent effectValue = Component.m_237113_((String)(displayText.getString() + " " + amplifier)).m_130940_(ChatFormatting.GREEN);
            res[index++] = Component.m_237110_((String)"text.collectorsalbum.album.boost.effect_instance", (Object[])new Object[]{effectValue}).m_130940_(ChatFormatting.YELLOW);
        }
        return res;
    }

    @Override
    public void apply(IBoostContext context) {
        Player player = context.get("player", Player.class);
        for (IEffectFactory factory : this.effects) {
            MobEffectInstance instance = factory.makeEffect();
            player.m_7292_(instance);
        }
    }

    @Override
    public Component[] getDescription() {
        return this.description;
    }

    public static void encodeEffectFactory(IEffectFactory factory, FriendlyByteBuf buffer) {
        MobEffectInstance instance = factory.makeEffect();
        MobEffect type = instance.m_19544_();
        ResourceLocation effectId = ForgeRegistries.MOB_EFFECTS.getKey((Object)type);
        buffer.m_130085_(effectId);
        buffer.writeInt(instance.m_19557_());
        buffer.writeInt(instance.m_19564_());
        buffer.writeBoolean(instance.m_19571_());
        buffer.writeBoolean(instance.m_19572_());
        buffer.writeBoolean(instance.m_19575_());
    }

    public static IEffectFactory decodeEffectFactory(FriendlyByteBuf buffer) {
        ResourceLocation effectId = buffer.m_130281_();
        MobEffect type = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectId);
        int duration = buffer.readInt();
        int amplifier = buffer.readInt();
        boolean ambient = buffer.readBoolean();
        boolean visible = buffer.readBoolean();
        boolean icon = buffer.readBoolean();
        return () -> new MobEffectInstance(type, duration, amplifier, ambient, visible, icon);
    }

    @FunctionalInterface
    static interface IEffectFactory {
        public MobEffectInstance makeEffect();
    }

    public static final class Serializer
    implements IActionSerializer<GiveEffectsAction> {
        @Override
        public GiveEffectsAction fromJson(JsonObject data, OpType opType) throws JsonParseException {
            JsonArray array = GsonHelper.m_13933_((JsonObject)data, (String)"effects");
            IEffectFactory[] factories = new IEffectFactory[array.size()];
            int i = 0;
            for (JsonElement element : array) {
                JsonObject effectJson = JsonHelper.asObject(element);
                ResourceLocation effectId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)effectJson, (String)"effect"));
                MobEffect effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId);
                if (effect == null) {
                    throw new JsonSyntaxException("Unknown effect: " + effectId);
                }
                int duration = Math.max(GsonHelper.m_13824_((JsonObject)effectJson, (String)"duration", (int)20), 0);
                int amplifier = Mth.m_14045_((int)GsonHelper.m_13824_((JsonObject)effectJson, (String)"amplifier", (int)0), (int)0, (int)255);
                boolean ambient = GsonHelper.m_13855_((JsonObject)effectJson, (String)"ambient", (boolean)false);
                boolean visible = GsonHelper.m_13855_((JsonObject)effectJson, (String)"visible", (boolean)true);
                boolean showIcon = GsonHelper.m_13855_((JsonObject)effectJson, (String)"showIcon", (boolean)true);
                factories[i++] = () -> new MobEffectInstance(effect, duration, amplifier, ambient, visible, showIcon);
            }
            return new GiveEffectsAction(factories);
        }

        @Override
        public void networkEncode(GiveEffectsAction action, FriendlyByteBuf buffer) {
            buffer.writeInt(action.effects.length);
            for (IEffectFactory factory : action.effects) {
                GiveEffectsAction.encodeEffectFactory(factory, buffer);
            }
        }

        @Override
        public GiveEffectsAction networkDecode(ActionType<GiveEffectsAction> type, FriendlyByteBuf buffer) {
            IEffectFactory[] factories = new IEffectFactory[buffer.readInt()];
            for (int i = 0; i < factories.length; ++i) {
                factories[i] = GiveEffectsAction.decodeEffectFactory(buffer);
            }
            return new GiveEffectsAction(factories);
        }
    }
}

