/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common.menu;

import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import team.tnt.collectoralbum.api.CardSlotDefinition;
import team.tnt.collectoralbum.api.ICategorySlotDistributor;
import team.tnt.collectoralbum.api.ISlotAppender;
import team.tnt.collectoralbum.common.CardCategory;
import team.tnt.collectoralbum.common.CardCategoryIndexPool;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.container.AlbumContainer;
import team.tnt.collectoralbum.common.init.MenuTypes;
import team.tnt.collectoralbum.common.item.CardRarity;
import team.tnt.collectoralbum.common.item.ICard;

public class AlbumMenu
extends AbstractContainerMenu {
    private final AlbumContainer container;
    @Nullable
    private final ICardCategory category;

    public AlbumMenu(AlbumContainer container, Inventory playerInventory, int id) {
        this(container, playerInventory, id, null);
    }

    public AlbumMenu(AlbumContainer container, Inventory playerInventory, int id, @Nullable ICardCategory category) {
        super((MenuType)MenuTypes.ALBUM.get(), id);
        this.container = container;
        this.category = category;
        final SimpleContainer categoryContainer = container.forCategory(category);
        ICategorySlotDistributor slotDistributor = category != null ? category.getMenuSlotDistributor() : CardCategory.DISTRIBUTOR;
        ISlotAppender<Slot> playerSlotAppender = x$0 -> this.m_38897_((Slot)x$0);
        slotDistributor.addPlayerSlots(playerSlotAppender, playerInventory);
        if (category == null) {
            return;
        }
        int offset = 1 + container.getCategoryIndexOffset(category);
        ISlotAppender<CardSlotDefinition> appender = definition -> this.m_38897_(new CardSlot((Container)categoryContainer, definition.slotIndex(), definition.slotX(), definition.slotY(), definition.cardNumber()));
        for (int i = 0; i < category.getCapacity(); ++i) {
            slotDistributor.distributeSlot(appender, i, offset);
        }
        this.m_38893_(new ContainerListener(){

            public void m_7934_(AbstractContainerMenu containerToSend, int dataSlotIndex, ItemStack stack) {
                categoryContainer.m_6596_();
            }

            public void m_142153_(AbstractContainerMenu containerMenu, int dataSlotIndex, int value) {
            }
        });
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotItem = slot.m_7993_();
            itemStack = slotItem.m_41777_();
            if (this.category != null) {
                int categorySize = this.category.getCapacity();
                if (index >= 0 && index < 36) {
                    if (this.isValidCard(slotItem)) {
                        ICard card = (ICard)slotItem.m_41720_();
                        int targetSlotIndex = card.getCard().cardNumber() + 35;
                        Slot targetSlot = (Slot)this.f_38839_.get(targetSlotIndex);
                        if (slot != null) {
                            ItemStack stack = targetSlot.m_7993_();
                            if (stack.m_41619_()) {
                                if (!this.m_38903_(slotItem, targetSlotIndex, targetSlotIndex + 1, false)) {
                                    return ItemStack.f_41583_;
                                }
                            } else {
                                Item item = stack.m_41720_();
                                if (!(item instanceof ICard)) {
                                    return ItemStack.f_41583_;
                                }
                                ICard targetCard = (ICard)item;
                                CardRarity usedRarity = targetCard.getCardRarity();
                                CardRarity newRarity = card.getCardRarity();
                                if (newRarity.ordinal() <= usedRarity.ordinal()) {
                                    return ItemStack.f_41583_;
                                }
                                ItemStack temp = stack.m_41777_();
                                targetSlot.m_5852_(itemStack);
                                slot.m_5852_(temp);
                            }
                        }
                    }
                } else if (index >= 36 && index < 36 + categorySize && !this.m_38903_(slotItem, 0, 36, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 0 && index < 27 ? this.m_38903_(slotItem, 27, 36, false) : index >= 27 && index < 36 && this.m_38903_(slotItem, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
        }
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public boolean isTitle() {
        return this.category == null;
    }

    public int getCategoryIndex() {
        return this.category.getIndex() + 1;
    }

    public AlbumContainer getContainer() {
        return this.container;
    }

    public ICardCategory getCategory() {
        return this.category;
    }

    private boolean isValidCard(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof ICard) {
            ICard card = (ICard)item;
            return card.getCard().category().equals(this.category);
        }
        return false;
    }

    public static class CardSlot
    extends Slot {
        private final int cardNumber;

        public CardSlot(Container container, int slotIndex, int slotX, int slotY, int cardNumber) {
            super(container, slotIndex, slotX, slotY);
            this.cardNumber = cardNumber;
        }

        public int getCardNumber() {
            return this.cardNumber;
        }

        public int m_6641_() {
            return 1;
        }

        public boolean m_5857_(ItemStack stack) {
            Item item = stack.m_41720_();
            if (item instanceof ICard) {
                ICard card = (ICard)item;
                int offset = CardCategoryIndexPool.getIndexOffset(card.getCard().category());
                return card.getCard().cardNumber() == this.cardNumber - offset;
            }
            return false;
        }

        public void m_6654_() {
            super.m_6654_();
        }
    }
}

