/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common.item;

import java.util.Arrays;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import team.tnt.collectoralbum.CollectorsAlbum;
import team.tnt.collectoralbum.client.CollectorsAlbumClient;
import team.tnt.collectoralbum.common.container.AlbumContainer;
import team.tnt.collectoralbum.common.item.IDeathPersistableItem;
import team.tnt.collectoralbum.common.menu.AlbumMenu;

public class AlbumItem
extends Item
implements IDeathPersistableItem {
    private static final Component SHOW_BOOSTS = Component.m_237115_((String)"text.collectorsalbum.album.boost.show").m_130940_(ChatFormatting.GRAY);
    private static final String PAGE_INFO_TRANSLATION_KEY = "text.collectorsalbum.album.boost.paging";

    public AlbumItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Override
    public boolean shouldKeepItem(Player player, ItemStack stack) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        if (!level.f_46443_) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider((id, inv, owner) -> new AlbumMenu(new AlbumContainer(itemStack), inv, id), CommonComponents.f_237098_), buffer -> {
                buffer.m_130055_(itemStack);
                buffer.writeInt(0);
            });
        }
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        if (Screen.m_96637_()) {
            CollectorsAlbumClient client = CollectorsAlbumClient.getClient();
            int pageIndex = client.getAlbumPageIndex();
            int pageSize = client.getPageCount();
            Component[] pagedText = CollectorsAlbum.ALBUM_CARD_BOOST_MANAGER.getBoosts().map(coll -> coll.getPagedDescription(pageIndex)).orElse(new Component[0]);
            if (pagedText.length == 0) {
                return;
            }
            tooltipComponents.addAll(Arrays.asList(pagedText));
            tooltipComponents.add((Component)Component.m_237110_((String)PAGE_INFO_TRANSLATION_KEY, (Object[])new Object[]{pageIndex + 1, pageSize}).m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            tooltipComponents.add(SHOW_BOOSTS);
        }
    }
}

