/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.common;

import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import team.tnt.collectoralbum.CollectorsAlbum;
import team.tnt.collectoralbum.common.AlbumStats;
import team.tnt.collectoralbum.common.init.ItemRegistry;
import team.tnt.collectoralbum.data.boosts.ActiveBoostContext;
import team.tnt.collectoralbum.data.boosts.AlbumCardBoostCollection;
import team.tnt.collectoralbum.data.boosts.OpType;
import team.tnt.collectoralbum.data.boosts.SimpleBoostContext;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="collectorsalbum")
public class AlbumBoostHandler {
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player entity = event.player;
        if (event.phase == TickEvent.Phase.START || entity.m_9236_().f_46443_) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        AlbumBoostHandler.tickPlayer(serverPlayer);
    }

    private static void tickPlayer(ServerPlayer player) {
        if (player.m_9236_().m_46467_() % 50L != 0L) {
            return;
        }
        AbstractContainerMenu inventory = player.f_36096_;
        Optional<AlbumCardBoostCollection> data = CollectorsAlbum.ALBUM_CARD_BOOST_MANAGER.getBoosts();
        data.ifPresent(ops -> {
            boolean hasAlbum = false;
            for (ItemStack stack : inventory.m_38927_()) {
                if (stack.m_41720_() != ItemRegistry.ALBUM.get()) continue;
                AlbumBoostHandler.applyBoosts(stack, player, ops);
                hasAlbum = true;
                break;
            }
            if (!hasAlbum) {
                SimpleBoostContext callCtx = new SimpleBoostContext((Player)player);
                ops.processOp(OpType.CLEANUP, callCtx);
            }
        });
    }

    private static void applyBoosts(ItemStack album, ServerPlayer player, AlbumCardBoostCollection ops) {
        AlbumStats stats = AlbumStats.createSimplifiedWithoutContainer(album);
        ActiveBoostContext ctx = new ActiveBoostContext((Player)player, stats);
        ops.processOp(OpType.ACTIVE, ctx);
    }
}

