/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectoralbum.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.event.TickEvent;
import team.tnt.collectoralbum.CollectorsAlbum;
import team.tnt.collectoralbum.api.IAlbumScreenFactory;
import team.tnt.collectoralbum.client.screen.AlbumScreen;
import team.tnt.collectoralbum.common.ICardCategory;
import team.tnt.collectoralbum.common.init.MenuTypes;
import team.tnt.collectoralbum.common.menu.AlbumMenu;
import team.tnt.collectoralbum.data.boosts.OpType;

public final class CollectorsAlbumClient {
    private static final CollectorsAlbumClient INSTANCE = new CollectorsAlbumClient();
    private int timer;
    private int albumPageIndex;
    private int pageCount;

    public static CollectorsAlbumClient getClient() {
        return INSTANCE;
    }

    public void synchInit() {
        MenuScreens.m_96206_((MenuType)((MenuType)MenuTypes.ALBUM.get()), (menu, inventory, title) -> {
            ICardCategory category = menu.getCategory();
            if (category == null) {
                return new AlbumScreen((AlbumMenu)menu, inventory, title);
            }
            IAlbumScreenFactory factory = category.getAlbumScreenFactory();
            return factory.createAlbumScreen((AlbumMenu)menu, inventory, title);
        });
    }

    public void handleClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == null) {
            this.timer = 0;
            return;
        }
        ++this.timer;
        CollectorsAlbum.ALBUM_CARD_BOOST_MANAGER.getBoosts().ifPresent(collection -> {
            this.pageCount = collection.getActionsCount(OpType.ACTIVE);
            if (this.pageCount > 0) {
                this.albumPageIndex = this.timer / 60 % this.pageCount;
            }
        });
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getAlbumPageIndex() {
        return this.albumPageIndex;
    }
}

