/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.vacuum.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.ConcretePowderBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.GravelBlock;
import net.minecraft.world.level.block.SandBlock;
import snownee.fruits.util.ClientProxy;
import snownee.fruits.vacuum.client.ItemProjectileColor;

public class ItemProjectileColors {
    private static final Map<Item, ItemProjectileColor> COLORS = Maps.newIdentityHashMap();
    private static final DyeColor[] DYE_COLOR_ORDER;

    public static void register(Item item, ItemProjectileColor color) {
        COLORS.put(item, color);
    }

    public static ItemProjectileColor get(ItemStack itemStack) {
        if (!COLORS.containsKey(itemStack.m_41720_())) {
            ItemProjectileColors.guessColor(itemStack.m_41720_());
        }
        return COLORS.get(itemStack.m_41720_());
    }

    private static void guessColor(Item item) {
        FallingBlock block;
        BlockItem blockItem;
        DyeColor[] dyeColorArray;
        ItemProjectileColor color = ClientProxy.getItemProjectileColor(item);
        if (color != null) {
            ItemProjectileColors.register(item, color);
            return;
        }
        if (item instanceof BlockItem && (dyeColorArray = (blockItem = (BlockItem)item).m_40614_()) instanceof FallingBlock && ((block = (FallingBlock)dyeColorArray) instanceof SandBlock || block instanceof GravelBlock || block instanceof ConcretePowderBlock)) {
            ItemProjectileColors.register(item, new ItemProjectileColor.FallingBlock(block));
            return;
        }
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        String palette = null;
        for (DyeColor dyeColor : DYE_COLOR_ORDER) {
            if (!id.m_135815_().contains(dyeColor.m_41065_())) continue;
            palette = id.m_135815_().replace(dyeColor.m_41065_(), "%s");
            break;
        }
        if (palette == null) {
            return;
        }
        ArrayList list = Lists.newArrayListWithExpectedSize((int)DYE_COLOR_ORDER.length);
        for (DyeColor dyeColor : DYE_COLOR_ORDER) {
            item = (Item)BuiltInRegistries.f_257033_.m_7745_(id = id.m_247449_(String.format(palette, dyeColor.m_41065_())));
            if (item == Items.f_41852_) {
                return;
            }
            list.add(Pair.of((Object)item, (Object)dyeColor));
        }
        for (Pair pair : list) {
            ItemProjectileColors.register((Item)pair.getFirst(), ItemProjectileColor.ofDyeColor((DyeColor)pair.getSecond()));
        }
    }

    public static void invalidate() {
        COLORS.clear();
    }

    static {
        DyeColor[] values = DyeColor.values();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)values.length);
        list.add(DyeColor.LIGHT_GRAY);
        list.add(DyeColor.LIGHT_BLUE);
        for (DyeColor color : values) {
            if (color == DyeColor.LIGHT_GRAY || color == DyeColor.LIGHT_BLUE) continue;
            list.add(color);
        }
        DYE_COLOR_ORDER = (DyeColor[])list.toArray(DyeColor[]::new);
    }
}

