/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.vacuum.client;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface ItemProjectileColor {
    public static final Map<DyeColor, Constant> DYE_COLORS = Maps.newEnumMap(DyeColor.class);

    public int getColor(ItemStack var1, BlockAndTintGetter var2, Vec3 var3);

    @Nullable
    public static ItemProjectileColor ofDyeColor(@Nullable DyeColor color) {
        if (color == null) {
            return null;
        }
        return DYE_COLORS.computeIfAbsent(color, c -> new Constant(c.m_41070_()));
    }

    public record Constant(int color) implements ItemProjectileColor
    {
        @Override
        public int getColor(ItemStack itemStack, BlockAndTintGetter level, Vec3 pos) {
            return this.color;
        }
    }

    public record FallingBlock(net.minecraft.world.level.block.FallingBlock block) implements ItemProjectileColor
    {
        @Override
        public int getColor(ItemStack itemStack, BlockAndTintGetter level, Vec3 pos) {
            return this.block.m_6248_(this.block.m_49966_(), (BlockGetter)level, BlockPos.f_121853_);
        }
    }
}

