/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.vacuum;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.util.CommonProxy;
import snownee.fruits.vacuum.VacGunItem;
import snownee.fruits.vacuum.client.ItemProjectileColor;
import snownee.fruits.vacuum.client.ItemProjectileColors;

public class VacItemProjectile
extends ThrowableItemProjectile {
    public final float bobOffs;
    private ItemProjectileColor colorProvider;

    public VacItemProjectile(EntityType<? extends VacItemProjectile> type, Level level) {
        super(type, level);
        this.bobOffs = this.f_19796_.m_188501_() * (float)Math.PI * 2.0f;
    }

    protected Item m_7881_() {
        return Items.f_41852_;
    }

    public ItemStack m_7846_() {
        return this.m_37454_();
    }

    public void m_7350_(EntityDataAccessor<?> entityDataAccessor) {
        super.m_7350_(entityDataAccessor);
        if (this.m_9236_().f_46443_ && f_37429_.equals(entityDataAccessor)) {
            this.colorProvider = ItemProjectileColors.get(this.m_7846_());
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        if (!(this.m_9236_().f_46443_ || this.m_7846_().m_41619_() || this.m_213877_())) {
            BlockHitResult blockHitResult;
            Vec3 location = hitResult.m_82450_();
            location = location.m_82549_(this.m_20184_().m_82541_().m_82490_(-0.25));
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), location.f_82479_, location.f_82480_, location.f_82481_, this.m_7846_());
            itemEntity.m_32010_(4);
            if (hitResult instanceof BlockHitResult && (blockHitResult = (BlockHitResult)hitResult).m_82434_().m_122434_().m_122478_()) {
                itemEntity.m_20256_(this.m_20184_().m_82542_(0.1, -0.1, 0.1));
            } else {
                itemEntity.m_20334_((this.f_19796_.m_188500_() - 0.5) * 0.05, 0.0, (this.f_19796_.m_188500_() - 0.5) * 0.05);
            }
            Entity owner = this.m_19749_();
            if (owner != null) {
                itemEntity.m_32052_(owner.m_20148_());
            }
            this.m_9236_().m_7967_((Entity)itemEntity);
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        ItemStack item = this.m_7846_();
        if (!(this.m_9236_().f_46443_ || item.m_41619_() || this.m_213877_())) {
            Block block;
            BlockPos pos = blockHitResult.m_82425_();
            BlockState blockState = this.m_9236_().m_8055_(pos);
            if (blockState.m_60734_() instanceof FarmBlock && (block = Block.m_49814_((Item)item.m_41720_())) != Blocks.f_50016_ && block.m_49966_().m_204336_(BlockTags.f_13073_)) {
                ItemStack itemCopy = item.m_41777_();
                BlockHitResult newHit = new BlockHitResult(blockHitResult.m_82450_(), Direction.UP, pos, false);
                item.m_41661_(new UseOnContext(this.m_9236_(), null, InteractionHand.MAIN_HAND, item, newHit));
                this.updateItem();
                Entity entity = this.m_19749_();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    CriteriaTriggers.f_10591_.m_285767_(player, pos, itemCopy);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)itemCopy.m_41720_()));
                }
                return;
            }
            BlockEntity blockEntity = this.m_9236_().m_7702_(pos);
            if (CommonProxy.insertItem(this.m_9236_(), pos, blockState, blockEntity, blockHitResult.m_82434_(), item)) {
                this.m_5496_(SoundEvents.f_12019_, 0.2f, ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
                VacGunItem.playContainerAnimation(blockEntity);
                this.updateItem();
            }
        }
    }

    private void updateItem() {
        if (this.m_7846_().m_41619_()) {
            this.m_146870_();
        } else {
            this.m_37446_(this.m_7846_());
        }
    }

    protected void m_5790_(EntityHitResult entityHitResult) {
        boolean enderman;
        DamageSource damageSource;
        super.m_5790_(entityHitResult);
        Entity owner = this.m_19749_();
        Entity entity = entityHitResult.m_82443_();
        if (owner == null) {
            damageSource = this.m_269291_().m_269390_((Entity)this, (Entity)this);
        } else {
            damageSource = this.m_269291_().m_269390_((Entity)this, owner);
            if (owner instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)owner;
                livingEntity.m_21335_(entity);
            }
        }
        boolean bl = enderman = entity.m_6095_() == EntityType.f_20566_;
        if (this.m_6060_() && !enderman) {
            entity.m_20254_(5);
        }
        if (!entity.m_6469_(damageSource, 1.0f) || enderman) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            double dx = 0.0;
            double dz = 0.0;
            if (livingEntity.m_20096_()) {
                dx = this.m_20184_().f_82479_ * 0.05;
                dz = this.m_20184_().f_82481_ * 0.05;
            }
            livingEntity.m_5997_(dx, 0.1, dz);
            if (!this.m_9236_().f_46443_ && owner instanceof LivingEntity) {
                EnchantmentHelper.m_44823_((LivingEntity)livingEntity, (Entity)owner);
                EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingEntity);
            }
            livingEntity.f_19802_ = 0;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_213877_()) {
            return;
        }
        if (this.m_9236_().f_46443_ && this.colorProvider != null) {
            int color = this.colorProvider.getColor(this.m_7846_(), (BlockAndTintGetter)this.m_9236_(), this.m_20182_());
            Vec3 deltaMovement = this.m_20184_();
            double x = deltaMovement.f_82479_;
            double y = deltaMovement.f_82480_;
            double z = deltaMovement.f_82481_;
            float l = Mth.m_14031_((float)((float)this.getAge() / 10.0f)) * 0.1f + 0.2f;
            DustParticleOptions particleOptions = new DustParticleOptions(Vec3.m_82501_((int)color).m_252839_(), 1.0f);
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)particleOptions, this.m_20185_() - x * (double)i / 4.0, this.m_20186_() + (double)l - y * (double)i / 4.0, this.m_20189_() - z * (double)i / 4.0, -x, -y + 0.2, -z);
            }
        }
    }

    public int getAge() {
        return this.f_19797_;
    }

    public float getSpin(float f) {
        return ((float)this.getAge() + f) / 20.0f + this.bobOffs;
    }

    public Component m_7755_() {
        Component component = this.m_7770_();
        if (component != null) {
            return component;
        }
        return Component.m_237115_((String)this.m_7846_().m_41778_());
    }

    @Nullable
    public ItemStack m_142340_() {
        return this.m_7846_();
    }

    public boolean m_7337_(Entity entity) {
        if (entity instanceof VacItemProjectile) {
            return false;
        }
        return super.m_7337_(entity);
    }
}

