/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.vacuum;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.pomegranate.PomegranateModule;
import snownee.fruits.util.CommonProxy;
import snownee.fruits.util.PreventUpdateAnimation;
import snownee.fruits.vacuum.ContainerOpenerFakePlayer;
import snownee.fruits.vacuum.VacGunContainer;
import snownee.fruits.vacuum.VacItemProjectile;
import snownee.fruits.vacuum.VacModule;
import snownee.fruits.vacuum.network.CGunShotPacket;
import snownee.kiwi.item.ModItem;

public class VacGunItem
extends ModItem
implements PreventUpdateAnimation {
    public static final int MAX_ITEM_COUNT = 16;
    private static final int ITEM_BAR_COLOR = Mth.m_14159_((float)0.4f, (float)1.0f, (float)0.4f);
    private static final ThreadLocal<ItemEntity> DUMMY_ITEM_ENTITY = new ThreadLocal();

    public VacGunItem() {
        super(new Item.Properties().m_41487_(1).m_41497_(Rarity.RARE));
    }

    public static void shoot(Player player, InteractionHand hand) {
        ItemStack gun = player.m_21120_(hand);
        if (player.m_36335_().m_41519_(gun.m_41720_())) {
            return;
        }
        String ammoType = VacGunItem.getAmmoType(gun);
        if (ammoType == null) {
            return;
        }
        if ("item".equals(ammoType)) {
            VacGunContainer container = VacGunItem.readItemContainer(gun);
            if (container == null || container.m_7983_()) {
                return;
            }
            VacItemProjectile projectile = VacGunItem.shootItem(player, gun, container);
            if (projectile != null && PomegranateModule.POMEGRANATE_ITEM.is(projectile.m_7846_())) {
                player.m_36335_().m_41524_(gun.m_41720_(), 10);
            } else {
                long gameTime = player.m_9236_().m_46467_();
                long lastShot = gun.m_41784_().m_128454_("LastShot");
                player.m_36335_().m_41524_(gun.m_41720_(), gameTime - lastShot < 8L ? 2 : 4);
            }
        } else if ("fluid".equals(ammoType)) {
            // empty if block
        }
        if (player.m_7578_()) {
            CGunShotPacket.I.sendToServer($ -> {});
        } else {
            gun.m_41784_().m_128356_("LastShot", player.m_9236_().m_46467_());
        }
    }

    @Nullable
    public static VacItemProjectile shootItem(Player player, ItemStack gun, VacGunContainer container) {
        if (player.m_9236_().f_46443_) {
            return null;
        }
        ItemStack itemStack = container.getLastItem();
        if (itemStack.m_41619_()) {
            return null;
        }
        ItemStack split = itemStack.m_41620_(1);
        Vec3 lookAngle = player.m_20154_();
        double d = player.m_20188_() - 0.6;
        VacItemProjectile projectile = Objects.requireNonNull((VacItemProjectile)((EntityType)VacModule.ITEM_PROJECTILE.get()).m_20615_(player.m_9236_()));
        projectile.m_6034_(player.m_20185_(), d, player.m_20189_());
        projectile.m_5602_((Entity)player);
        projectile.m_37446_(split);
        projectile.m_6686_(lookAngle.m_7096_(), lookAngle.m_7098_(), lookAngle.m_7094_(), 2.0f, 0.01f);
        player.m_9236_().m_7967_((Entity)projectile);
        container.m_6596_();
        VacGunItem.saveItemContainer(gun, container);
        RandomSource random = player.m_217043_();
        player.m_9236_().m_6269_(null, (Entity)player, (SoundEvent)VacModule.GUN_SHOOT_ITEM.get(), player.m_5720_(), 0.2f, ((random.m_188501_() - random.m_188501_()) * 0.7f + 1.0f) * 2.0f);
        return projectile;
    }

    public static int getItemCount(ItemStack gun) {
        if (gun.m_41783_() == null) {
            return 0;
        }
        return gun.m_41783_().m_128451_("ItemCount");
    }

    public static void collectItem(Player player, ItemEntity itemEntity, ItemStack gun, @Nullable VacGunContainer container) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        String ammoType = VacGunItem.getAmmoType(gun);
        if (ammoType != null && !"item".equals(ammoType)) {
            return;
        }
        if (gun.m_41783_() != null && VacGunItem.getItemCount(gun) >= 16) {
            return;
        }
        ItemStack itemStack = itemEntity.m_32055_();
        VacGunContainer container2 = container;
        if (container2 == null) {
            container2 = VacGunItem.readItemContainer(gun);
        }
        if (container2 == null) {
            return;
        }
        int count = itemStack.m_41613_();
        if ((count -= (itemStack = container2.m_19173_(itemStack)).m_41613_()) > 0) {
            player.m_7938_((Entity)itemEntity, count);
        }
        if (itemStack.m_41619_()) {
            itemEntity.m_146870_();
        } else {
            itemEntity.m_32045_(itemStack);
        }
        if (container == null) {
            VacGunItem.saveItemContainer(gun, container2);
        }
    }

    public static VacGunContainer readItemContainer(ItemStack gun) {
        String ammoType = VacGunItem.getAmmoType(gun);
        if (ammoType != null && !"item".equals(ammoType)) {
            return null;
        }
        VacGunContainer container = new VacGunContainer(16);
        if (gun.m_41783_() != null) {
            container.m_7797_(gun.m_41783_().m_128437_("Items", 10));
        }
        return container;
    }

    public static void saveItemContainer(ItemStack gun, VacGunContainer container) {
        CompoundTag tag = gun.m_41784_();
        if (container.m_7983_()) {
            tag.m_128473_("AmmoType");
            tag.m_128473_("Items");
            tag.m_128473_("ItemCount");
            return;
        }
        tag.m_128359_("AmmoType", "item");
        tag.m_128365_("Items", (Tag)container.m_7927_());
        tag.m_128405_("ItemCount", container.getItemCount());
    }

    @Nullable
    public static String getAmmoType(ItemStack gun) {
        if (gun.m_41783_() == null) {
            return null;
        }
        String ammoType = gun.m_41783_().m_128461_("AmmoType");
        return ammoType.isEmpty() ? null : ammoType;
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.SPYGLASS;
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack gun, int i) {
        if (living.m_9236_().f_46443_ || !(living instanceof Player)) {
            return;
        }
        Player player = (Player)living;
        Vec3 start = player.m_20299_(1.0f);
        if (level.f_46443_) {
            return;
        }
        Vec3 lookAngle = player.m_20252_(1.0f);
        double reach = Math.min(i / 2 + 2, 8);
        Vec3 end = start.m_82520_(lookAngle.f_82479_ * reach, lookAngle.f_82480_ * reach, lookAngle.f_82481_ * reach);
        ItemEntity dummy = DUMMY_ITEM_ENTITY.get();
        if (dummy == null) {
            dummy = new ItemEntity(level, 0.0, 0.0, 0.0, ItemStack.f_41583_);
            DUMMY_ITEM_ENTITY.set(dummy);
        }
        dummy.m_284535_(level);
        BlockHitResult hit = level.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)dummy));
        dummy.m_284535_(null);
        end = hit.m_82450_();
        start = start.m_82549_(lookAngle);
        AABB aabb = new AABB(start, end).m_82400_(1.0);
        VacGunItem.extractContainer(level, gun, lookAngle, start, (HitResult)hit, aabb);
        VacGunItem.processEntities(level, player, gun, lookAngle, start, end, aabb);
        if (i % 2 == 0) {
            VacGunItem.processBlocks(level, player, gun, lookAngle, start, end, aabb);
        }
    }

    private static void extractContainer(Level level, ItemStack gun, Vec3 lookAngle, Vec3 start, HitResult hit, AABB aabb) {
        Direction direction;
        BlockEntity blockEntity;
        BlockState state;
        if (hit.m_6662_() != HitResult.Type.BLOCK) {
            return;
        }
        String ammoType = VacGunItem.getAmmoType(gun);
        if (ammoType != null && !"item".equals(ammoType)) {
            return;
        }
        int count = VacGunItem.getItemCount(gun);
        if (count >= 16) {
            return;
        }
        if ((count += level.m_6443_(ItemEntity.class, aabb, e -> {
            if (e.f_19794_ || e.m_5833_() || !e.m_6084_()) {
                return false;
            }
            Vec3 center = e.m_20191_().m_82399_();
            return center.m_82546_(start).m_82526_(lookAngle) > 0.866;
        }).size()) >= 16) {
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hit;
        BlockPos pos = blockHitResult.m_82425_();
        ItemStack itemStack = CommonProxy.extractOneItem(level, pos, state = level.m_8055_(pos), blockEntity = level.m_7702_(pos), direction = blockHitResult.m_82434_());
        if (itemStack.m_41619_()) {
            return;
        }
        Vec3 end = hit.m_82450_().m_82520_((double)direction.m_122429_() * 0.2, (double)direction.m_122430_() * 0.2, (double)direction.m_122431_() * 0.2);
        ItemEntity itemEntity = new ItemEntity(level, end.f_82479_, end.f_82480_, end.f_82481_, itemStack);
        itemEntity.m_20334_(0.0, 0.1, 0.0);
        level.m_7967_((Entity)itemEntity);
    }

    private static void processEntities(Level level, Player player, ItemStack gun, Vec3 lookAngle, Vec3 start, Vec3 end, AABB aabb) {
        List entities = level.m_6443_(Entity.class, aabb, e -> {
            if (e == player || e.f_19794_ || e.m_5833_() || !e.m_6084_()) {
                return false;
            }
            AABB box = e.m_20191_();
            if (box.m_82362_() > 0.5 || box.m_82376_() > 0.9 || box.m_82385_() > 0.5) {
                return false;
            }
            Vec3 center = box.m_82399_();
            return center.m_82546_(start).m_82526_(lookAngle) > 0.866;
        });
        VacGunContainer container = null;
        boolean save = false;
        for (Entity entity : entities) {
            Vec3 center;
            Vec3 dist;
            double lengthSqr;
            if (entity.m_20159_()) {
                Vec3 position = entity.m_20182_();
                entity.m_8127_();
                entity.m_146884_(position);
            }
            if ((lengthSqr = (dist = start.m_82546_(center = entity.m_20191_().m_82399_())).m_82556_()) < 1.0 && entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                if (container == null) {
                    container = VacGunItem.readItemContainer(gun);
                }
                VacGunItem.collectItem(player, itemEntity, gun, container);
                save = true;
                entity.f_19812_ = true;
                continue;
            }
            if (lengthSqr < 4.0) {
                power = dist.m_82541_().m_82490_(Math.max(0.2, lengthSqr / 16.0));
                entity.m_20256_(power);
                entity.m_183634_();
            } else {
                power = dist.m_82541_().m_82490_(0.2);
                power = power.m_82490_(Math.max(0.1, 1.0 - lengthSqr / 64.0));
                Vec3 deltaMovement = entity.m_20184_().m_82549_(power);
                if (deltaMovement.m_82556_() > 0.5) {
                    deltaMovement = deltaMovement.m_82541_().m_82490_(0.5);
                }
                entity.m_20256_(deltaMovement);
            }
            entity.f_19812_ = true;
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            mob.m_21573_().m_26573_();
        }
        if (save && container != null) {
            VacGunItem.saveItemContainer(gun, container);
        }
    }

    private static void processBlocks(Level level, Player player, ItemStack gun, Vec3 lookAngle, Vec3 start, Vec3 end, AABB aabb) {
        BlockPos.m_121921_((AABB)aabb).forEach(pos -> {
            CropBlock cropBlock;
            Vec3 center = Vec3.m_82512_((Vec3i)pos);
            Vec3 dist = center.m_82546_(start);
            if (dist.m_82541_().m_82526_(lookAngle) < 0.866 && dist.m_82556_() > 0.9) {
                return;
            }
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_()) {
                return;
            }
            if (CommonProxy.isLitCandle(state)) {
                CommonProxy.extinguishCandle(player, state, (LevelAccessor)level, pos);
                return;
            }
            if (player != null && state.m_204336_(VacModule.VCD_PERFORM_USING)) {
                BlockHitResult blockHitResult = new BlockHitResult(center, player.m_6350_().m_122424_(), pos, false);
                state.m_60664_(level, player, player.m_7655_(), blockHitResult);
                return;
            }
            Block patt12361$temp = state.m_60734_();
            if (patt12361$temp instanceof CropBlock && (cropBlock = (CropBlock)patt12361$temp).m_52307_(state)) {
                level.m_46953_(pos, true, (Entity)player);
                return;
            }
            if (state.m_204336_(VacModule.VCD_PERFORM_BREAKING)) {
                level.m_46953_(pos, true, (Entity)player);
            }
        });
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        return ItemUtils.m_150959_((Level)level, (Player)player, (InteractionHand)hand);
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return false;
    }

    public int m_142158_(ItemStack itemStack) {
        String ammoType = VacGunItem.getAmmoType(itemStack);
        if ("item".equals(ammoType)) {
            int itemCount = VacGunItem.getItemCount(itemStack);
            return Mth.m_14167_((float)((float)itemCount / 16.0f * 13.0f));
        }
        if ("fluid".equals(ammoType)) {
            // empty if block
        }
        return 0;
    }

    public int m_142159_(ItemStack itemStack) {
        return ITEM_BAR_COLOR;
    }

    public boolean m_142522_(ItemStack itemStack) {
        String ammoType = VacGunItem.getAmmoType(itemStack);
        if ("item".equals(ammoType)) {
            return VacGunItem.getItemCount(itemStack) > 0;
        }
        if ("fluid".equals(ammoType)) {
            // empty if block
        }
        return false;
    }

    public boolean m_142305_(ItemStack gun, ItemStack itemStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (clickAction != ClickAction.SECONDARY || !slot.m_150651_(player) || itemStack.m_41619_()) {
            return false;
        }
        VacGunContainer container = VacGunItem.readItemContainer(gun);
        if (container == null) {
            return false;
        }
        ItemStack itemStack2 = container.m_19173_(itemStack);
        if (itemStack.m_41613_() == itemStack2.m_41613_()) {
            return false;
        }
        itemStack.m_41764_(itemStack2.m_41613_());
        VacGunItem.saveItemContainer(gun, container);
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        String ammoType = VacGunItem.getAmmoType(stack);
        if ("item".equals(ammoType)) {
            VacGunContainer container = VacGunItem.readItemContainer(stack);
            if (container != null) {
                int i = 0;
                int itemCount = 0;
                for (ItemStack itemStack2 : container.f_19147_) {
                    if (itemStack2.m_41619_()) continue;
                    if (++i > 4) break;
                    itemCount += itemStack2.m_41613_();
                    MutableComponent mutableComponent = itemStack2.m_41786_().m_6881_();
                    mutableComponent.m_130946_(" x").m_130946_(String.valueOf(itemStack2.m_41613_()));
                    tooltip.add((Component)mutableComponent);
                }
                if (container.getItemCount() > itemCount) {
                    tooltip.add((Component)Component.m_237110_((String)"container.shulkerBox.more", (Object[])new Object[]{container.getItemCount() - itemCount}).m_130940_(ChatFormatting.ITALIC));
                }
            }
        } else if ("fluid".equals(ammoType)) {
            // empty if block
        }
    }

    public static void playContainerAnimation(BlockEntity blockEntity) {
        if (blockEntity instanceof Container && blockEntity instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)blockEntity;
            ContainerOpenerFakePlayer player = ContainerOpenerFakePlayer.getOrCreate((ServerLevel)blockEntity.m_58904_(), blockEntity.m_58899_());
            player.m_5893_(menuProvider);
        }
    }
}

