/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.vacuum;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.function.BiFunction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;

public abstract class ArmBasedParticleOption
implements ParticleOptions {
    protected final int playerId;
    protected final boolean mainArm;

    protected ArmBasedParticleOption(int playerId, boolean mainArm) {
        this.playerId = playerId;
        this.mainArm = mainArm;
    }

    public void m_7711_(FriendlyByteBuf buf) {
        buf.m_130130_(this.playerId);
        buf.writeBoolean(this.mainArm);
    }

    public String m_5942_() {
        return String.format("%s %s %s", BuiltInRegistries.f_257034_.m_7981_((Object)this.m_6012_()), this.playerId, this.mainArm);
    }

    public int playerId() {
        return this.playerId;
    }

    public boolean mainArm() {
        return this.mainArm;
    }

    public static class Deserializer<T extends ArmBasedParticleOption>
    implements ParticleOptions.Deserializer<T> {
        private final BiFunction<Integer, Boolean, T> factory;

        public Deserializer(BiFunction<Integer, Boolean, T> factory) {
            this.factory = factory;
        }

        public T fromNetwork(ParticleType<T> particleType, FriendlyByteBuf buf) {
            int playerId = buf.m_130242_();
            boolean mainHand = buf.readBoolean();
            return (T)((ArmBasedParticleOption)this.factory.apply(playerId, mainHand));
        }

        public T fromCommand(ParticleType<T> particleType, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            int playerId = stringReader.readInt();
            stringReader.expect(' ');
            boolean mainArm = stringReader.readBoolean();
            return (T)((ArmBasedParticleOption)this.factory.apply(playerId, mainArm));
        }
    }
}

