/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.util;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.CoreFruitTypes;
import snownee.fruits.CoreModule;
import snownee.fruits.FFCommonConfig;
import snownee.fruits.FFRegistries;
import snownee.fruits.Hooks;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.genetics.GeneticData;
import snownee.fruits.cherry.item.FlowerCrownItem;
import snownee.fruits.compat.curios.CuriosCompat;
import snownee.fruits.compat.farmersdelight.FarmersDelightModule;
import snownee.fruits.duck.FFPlayer;
import snownee.fruits.util.ClientProxy;
import snownee.fruits.vacuum.VacGunItem;
import snownee.fruits.vacuum.VacModule;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.Util;

@Mod(value="fruitfulfun")
public class CommonProxy {
    public static final UUID FAKE_PLAYER_UUID = UUID.fromString("ae5efe90-eef0-4899-94fc-de4786c242e8");
    private static final GameProfile FAKE_PLAYER_PROFILE = new GameProfile(FAKE_PLAYER_UUID, "[FruitfulFun]");
    private static final TagKey<Item> KNIVES = AbstractModule.itemTag((String)"farmersdelight", (String)"tools/knives");

    public CommonProxy() {
        CoreFruitTypes.APPLE.getOrCreate();
    }

    public static void init() {
        CommonProxy.addFeature("citron");
        CommonProxy.addFeature("tangerine");
        CommonProxy.addFeature("lime");
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (!FFCommonConfig.wanderingTraderSapling) {
                return;
            }
            List trades = event.getGenericTrades();
            trades.add((entity, random) -> {
                ItemStack sapling = ((Block)net.minecraft.Util.m_214621_(FFRegistries.FRUIT_TYPE.m_123024_().filter($ -> $.tier == 0).map($ -> $.sapling.get()).toList(), (RandomSource)random)).m_5456_().m_7968_();
                ItemStack emeralds = new ItemStack((ItemLike)Items.f_42616_, 8);
                return new MerchantOffer(emeralds, sapling, 5, 1, 1.0f);
            });
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            MinecraftServer server = event.getServer();
            ServerLevel world = server.m_129783_();
            long seed = world.m_7328_();
            GeneticData geneticData = (GeneticData)world.m_8895_().m_164861_(GeneticData::load, GeneticData::new, "fruitfulfun_genetics");
            geneticData.initAlleles(seed);
        });
        if (Platform.isModLoaded((String)"leaves_us_in_peace")) {
            MinecraftForge.EVENT_BUS.addListener(event -> {
                Player player = event.getEntity();
                if (FFCommonConfig.leavesUsInPeaceIncompatibilityNotified || CommonProxy.isFakePlayer((Entity)player)) {
                    return;
                }
                MutableComponent msg = Component.m_237115_((String)"tip.fruitfulfun.leavesUsInPeace");
                if (player.m_20194_() != null) {
                    player.m_20194_().m_213846_((Component)msg);
                }
                player.m_213846_((Component)msg);
                FFCommonConfig.leavesUsInPeaceIncompatibilityNotified = true;
                KiwiConfigManager.getHandler(FFCommonConfig.class).save();
            });
        }
        if (Platform.isPhysicalClient()) {
            ClientProxy.init();
        }
        if (Hooks.curios) {
            CuriosCompat.init();
        }
    }

    public static boolean isCurativeItem(MobEffectInstance effectInstance, ItemStack stack) {
        return effectInstance.isCurativeItem(stack);
    }

    public static boolean isFakePlayer(Entity entity) {
        return entity instanceof FakePlayer;
    }

    public static Packet<ClientGamePacketListener> getAddEntityPacket(Entity entity) {
        return NetworkHooks.getEntitySpawningPacket((Entity)entity);
    }

    public static void maybeGrowCrops(ServerLevel world, BlockPos pos, BlockState state, boolean defaultResult, Runnable defaultAction) {
        if (ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)defaultResult)) {
            defaultAction.run();
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public static void addBuiltinPacks() {
        CommonProxy.init();
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer("fruitfulfun").orElseThrow();
        if (Hooks.food) {
            CommonProxy.addBuiltinPack(modContainer, "food");
        }
        if (Hooks.farmersdelight) {
            String mode = FarmersDelightModule.getMode();
            if ("vectorwing".equals(mode)) {
                CommonProxy.addBuiltinPack(modContainer, "farmersdelight");
            } else {
                CommonProxy.addBuiltinPack(modContainer, "farmersdelight_" + mode);
            }
        }
        if (FFCommonConfig.villageAppleTreeWorldGen) {
            CommonProxy.addBuiltinPack(modContainer, "apple_tree_in_village");
        }
    }

    private static void addBuiltinPack(ModContainer modContainer, String id) {
        ResourceManagerHelper.registerBuiltinResourcePack((ResourceLocation)new ResourceLocation("fruitfulfun", id), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.ALWAYS_ENABLED);
    }

    public static boolean isShears(ItemStack stack) {
        return stack.canPerformAction(ToolActions.SHEARS_HARVEST);
    }

    public static boolean isBookshelf(BlockState blockState) {
        return blockState.m_204336_(Tags.Blocks.BOOKSHELVES);
    }

    public static boolean insertItem(Level level, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, Direction direction, ItemStack item) {
        LazyOptional cap;
        if (item.m_41619_()) {
            return false;
        }
        if (blockEntity != null && (cap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction)).isPresent()) {
            IItemHandler itemHandler = (IItemHandler)cap.orElseThrow(NullPointerException::new);
            ItemStack ret = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)item.m_41777_(), (boolean)false);
            if (ret.m_41613_() == item.m_41613_()) {
                return false;
            }
            item.m_41764_(ret.m_41613_());
            return true;
        }
        Block ret = blockState.m_60734_();
        if (ret instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder containerHolder = (WorldlyContainerHolder)ret;
            WorldlyContainer container = containerHolder.m_5840_(blockState, (LevelAccessor)level, blockPos);
            if (container == null) {
                return false;
            }
            ItemStack ret2 = HopperBlockEntity.m_59326_(null, (Container)container, (ItemStack)item, (Direction)direction);
            if (ret2.m_41613_() == item.m_41613_()) {
                return false;
            }
            item.m_41764_(ret2.m_41613_());
            return true;
        }
        return false;
    }

    public static ItemStack extractOneItem(Level level, BlockPos blockPos, BlockState blockState, @Nullable BlockEntity blockEntity, Direction direction) {
        Block i2;
        LazyOptional cap;
        if (blockEntity != null && (cap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction)).isPresent()) {
            VacGunItem.playContainerAnimation(blockEntity);
            IItemHandler itemHandler = (IItemHandler)cap.orElseThrow(NullPointerException::new);
            for (int i2 = 0; i2 < itemHandler.getSlots(); ++i2) {
                ItemStack stack = itemHandler.extractItem(i2, 1, false);
                if (stack.m_41619_()) continue;
                return stack;
            }
        }
        if ((i2 = blockState.m_60734_()) instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder containerHolder = (WorldlyContainerHolder)i2;
            WorldlyContainer container = containerHolder.m_5840_(blockState, (LevelAccessor)level, blockPos);
            if (container == null || container.m_7983_()) {
                return ItemStack.f_41583_;
            }
            for (int slot : container.m_7071_(direction)) {
                ItemStack itemStack = container.m_8020_(slot);
                if (itemStack.m_41619_() || !container.m_7157_(slot, itemStack = itemStack.m_255036_(1), direction) || (itemStack = container.m_7407_(slot, 1)).m_41619_()) continue;
                container.m_6596_();
                return itemStack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getRecipeRemainder(ItemStack itemStack) {
        return itemStack.getCraftingRemainingItem();
    }

    public static void initBeeModule() {
        BeeModule.BEE_ONE_CM = Stats.m_13007_((String)BeeModule.BEE_ONE_CM.toString(), (StatFormatter)StatFormatter.f_12875_);
        BeeModule.BEES_BRED = Stats.m_13007_((String)BeeModule.BEES_BRED.toString(), (StatFormatter)StatFormatter.f_12873_);
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Player oldPlayer = event.getOriginal();
            Player newPlayer = event.getEntity();
            Map<String, FFPlayer.GeneName> map = FFPlayer.of(oldPlayer).fruits$getGeneNames();
            FFPlayer.of(newPlayer).fruits$setGeneNames(map);
        });
    }

    public static void initVacModule() {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (VacModule.VAC_GUN.is(event.getItemStack())) {
                event.getEntity().m_6672_(event.getHand());
                event.setCanceled(true);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (VacModule.VAC_GUN.is(event.getItemStack())) {
                event.setCanceled(true);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (VacModule.VAC_GUN.is(event.getItemStack())) {
                event.getEntity().m_6672_(event.getHand());
                event.setCanceled(true);
            }
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (VacModule.VAC_GUN.is(event.getEntity().m_21205_())) {
                event.setCanceled(true);
            }
        });
    }

    public static void addFeature(String id) {
        ResourceKey key = PlacementUtils.m_255070_((String)Objects.requireNonNull(Util.RL((String)id, (String)"fruitfulfun")).toString());
        BiomeModifications.addFeature(context -> context.hasTag(ConventionalBiomeTags.TREE_DECIDUOUS) || context.hasTag(ConventionalBiomeTags.TREE_JUNGLE) || context.hasFeature(VegetationFeatures.f_195166_), (GenerationStep.Decoration)GenerationStep.Decoration.VEGETAL_DECORATION, (ResourceKey)key);
    }

    public static FlowerCrownItem getFlowerCrown(LivingEntity entity) {
        ItemStack stack = entity.m_6844_(EquipmentSlot.HEAD);
        Item item = stack.m_41720_();
        if (item instanceof FlowerCrownItem) {
            FlowerCrownItem item2 = (FlowerCrownItem)item;
            return item2;
        }
        if (Hooks.curios) {
            return CuriosCompat.getFlowerCrown(entity);
        }
        return null;
    }

    public static boolean isLitCandle(BlockState blockState) {
        return blockState.m_61138_((Property)AbstractCandleBlock.f_151895_) && (Boolean)blockState.m_61143_((Property)AbstractCandleBlock.f_151895_) != false && blockState.m_204336_(CoreModule.CANDLES);
    }

    public static void extinguishCandle(@Nullable Player player, BlockState blockState, LevelAccessor level, BlockPos blockPos) {
        if (blockState.m_60734_() instanceof AbstractCandleBlock) {
            AbstractCandleBlock.m_151899_((Player)player, (BlockState)blockState, (LevelAccessor)level, (BlockPos)blockPos);
            return;
        }
        if (blockState.m_204336_(CoreModule.CANDLES) && ((Boolean)blockState.m_61143_((Property)AbstractCandleBlock.f_151895_)).booleanValue()) {
            level.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)AbstractCandleBlock.f_151895_, (Comparable)Boolean.valueOf(false)), 11);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.9, (double)blockPos.m_123343_() + 0.5, 0.0, 0.1, 0.0);
            level.m_5594_(null, blockPos, SoundEvents.f_144098_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
        }
    }

    public static ServerPlayer getFakePlayer(Level level) {
        return FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)FAKE_PLAYER_PROFILE);
    }

    public static boolean isKnife(ItemStack itemStack) {
        return itemStack.m_204117_(KNIVES);
    }
}

