/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import snownee.fruits.CoreModule;
import snownee.fruits.Hooks;
import snownee.fruits.bee.BeeModule;
import snownee.fruits.bee.InspectorClientHandler;
import snownee.fruits.bee.genetics.EditGeneNameScreen;
import snownee.fruits.cherry.CherryModule;
import snownee.fruits.client.SlidingDoorRenderer;
import snownee.fruits.client.particle.FoodSmokeParticle;
import snownee.fruits.client.particle.PetalParticle;
import snownee.fruits.compat.supplementaries.SupplementariesCompat;
import snownee.fruits.food.FoodModule;
import snownee.fruits.vacuum.AirVortexParticleOption;
import snownee.fruits.vacuum.VacModule;
import snownee.fruits.vacuum.client.ItemProjectileColor;
import snownee.fruits.vacuum.client.ItemProjectileRenderer;
import snownee.kiwi.util.ColorProviderUtil;

public class ClientProxy {
    public static void init() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(event -> event.registerEntityRenderer((EntityType)CoreModule.SLIDING_DOOR.getOrCreate(), SlidingDoorRenderer::new));
        eventBus.addListener(event -> {
            BlockColor oakBlockColor = ColorProviderUtil.delegate((Block)Blocks.f_50050_);
            event.register((state, world, pos, i) -> {
                if (i == 0) {
                    return oakBlockColor.m_92566_(Blocks.f_50050_.m_49966_(), world, pos, i);
                }
                if (i == 1) {
                    if (CoreModule.CITRON_LEAVES.is(state)) {
                        return 14535768;
                    }
                    if (CoreModule.GRAPEFRUIT_LEAVES.is(state)) {
                        return 16232772;
                    }
                    if (CoreModule.LEMON_LEAVES.is(state)) {
                        return 15452747;
                    }
                    if (CoreModule.LIME_LEAVES.is(state)) {
                        return 13294198;
                    }
                    if (CoreModule.TANGERINE_LEAVES.is(state)) {
                        return 15763993;
                    }
                    if (CoreModule.ORANGE_LEAVES.is(state)) {
                        return 15763993;
                    }
                    if (CoreModule.POMELO_LEAVES.is(state)) {
                        return 16250494;
                    }
                    if (CoreModule.APPLE_LEAVES.is(state)) {
                        return 16522282;
                    }
                }
                return -1;
            }, new Block[]{(Block)CoreModule.TANGERINE_LEAVES.getOrCreate(), (Block)CoreModule.LIME_LEAVES.getOrCreate(), (Block)CoreModule.CITRON_LEAVES.getOrCreate(), (Block)CoreModule.POMELO_LEAVES.getOrCreate(), (Block)CoreModule.ORANGE_LEAVES.getOrCreate(), (Block)CoreModule.LEMON_LEAVES.getOrCreate(), (Block)CoreModule.GRAPEFRUIT_LEAVES.getOrCreate(), (Block)CoreModule.APPLE_LEAVES.getOrCreate()});
        });
        eventBus.addListener(event -> {
            ItemStack oakLeaves = new ItemStack((ItemLike)Items.f_41896_);
            ItemColor itemColor = ColorProviderUtil.delegate((Item)Items.f_41896_);
            event.register((stack, i) -> itemColor.m_92671_(oakLeaves, i), new ItemLike[]{(ItemLike)CoreModule.TANGERINE_LEAVES.get(), (ItemLike)CoreModule.LIME_LEAVES.get(), (ItemLike)CoreModule.CITRON_LEAVES.get(), (ItemLike)CoreModule.POMELO_LEAVES.get(), (ItemLike)CoreModule.ORANGE_LEAVES.get(), (ItemLike)CoreModule.LEMON_LEAVES.get(), (ItemLike)CoreModule.GRAPEFRUIT_LEAVES.get(), (ItemLike)CoreModule.APPLE_LEAVES.get()});
        });
        eventBus.addListener(event -> {
            event.registerSpriteSet((ParticleType)CherryModule.PETAL_CHERRY.getOrCreate(), PetalParticle.Factory::new);
            event.registerSpriteSet((ParticleType)CherryModule.PETAL_REDLOVE.getOrCreate(), PetalParticle.Factory::new);
        });
        eventBus.addListener(event -> {
            BlockColor birchBlockColor = ColorProviderUtil.delegate((Block)Blocks.f_50052_);
            event.register((state, world, pos, i) -> {
                if (i == 1) {
                    return 0xC22626;
                }
                if (i == 2) {
                    return birchBlockColor.m_92566_(Blocks.f_50052_.m_49966_(), world, pos, i);
                }
                return -1;
            }, new Block[]{(Block)CherryModule.REDLOVE_LEAVES.getOrCreate()});
        });
        eventBus.addListener(event -> event.register((blockState, blockAndTintGetter, blockPos, i) -> {
            if (i != 0) {
                if (blockAndTintGetter == null || blockPos == null) {
                    return GrassColor.m_276205_();
                }
                return BiomeColors.m_108793_((BlockAndTintGetter)blockAndTintGetter, (BlockPos)blockPos);
            }
            return -1;
        }, new Block[]{(Block)CherryModule.PEACH_PINK_PETALS.getOrCreate()}));
        eventBus.addListener(event -> {
            event.register(new ResourceLocation("fruitfulfun", "block/cherry_crown"));
            event.register(new ResourceLocation("fruitfulfun", "block/redlove_crown"));
        });
        if (Hooks.bee) {
            eventBus.addListener(event -> event.register((stack, i) -> {
                if (i == 0) {
                    CompoundTag tag = stack.m_41783_();
                    return tag != null && tag.m_128441_("Color") ? tag.m_128451_("Color") : 15981803;
                }
                return -1;
            }, new ItemLike[]{(ItemLike)BeeModule.MUTAGEN.getOrCreate()}));
            MinecraftForge.EVENT_BUS.addListener(event -> {
                if (event.phase != TickEvent.Phase.START) {
                    return;
                }
                Minecraft client = Minecraft.m_91087_();
                if (client.f_91074_ != null && client.f_91074_.m_5833_()) {
                    return;
                }
                InspectorClientHandler.tick(client);
            });
        }
        if (Hooks.food) {
            eventBus.addListener(event -> event.registerSpriteSet((ParticleType)FoodModule.SMOKE.getOrCreate(), FoodSmokeParticle.Factory::new));
        }
        if (Hooks.vac) {
            eventBus.addListener(event -> event.registerEntityRenderer((EntityType)VacModule.ITEM_PROJECTILE.getOrCreate(), ItemProjectileRenderer::new));
        }
    }

    public static BakedModel getModel(ModelManager modelManager, ResourceLocation id) {
        return modelManager.getModel(id);
    }

    public static boolean poseArm(LivingEntity entity, ModelPart arm, ModelPart head, boolean rightArm) {
        ItemStack stack;
        if (!Hooks.bee && !Hooks.vac) {
            return false;
        }
        HumanoidArm mainArm = entity.m_5737_();
        boolean isMainArm = rightArm ? mainArm == HumanoidArm.RIGHT : mainArm == HumanoidArm.LEFT;
        ItemStack itemStack = stack = isMainArm ? entity.m_21205_() : entity.m_21206_();
        if (Hooks.bee && BeeModule.INSPECTOR.is(stack)) {
            arm.f_104203_ = Mth.m_14036_((float)(head.f_104203_ - 1.5198622f - (entity.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
            arm.f_104204_ = head.f_104204_ - 0.2617994f * (float)(rightArm ? 1 : -1);
            return true;
        }
        if (Hooks.vac && VacModule.VAC_GUN.is(stack)) {
            arm.f_104203_ = Mth.m_14036_((float)(head.f_104203_ - 1.5198622f - (entity.m_6047_() ? 0.2617994f : 0.0f)), (float)-2.4f, (float)3.3f);
            arm.f_104204_ = head.f_104204_ - 0.2617994f * (float)(rightArm ? 1 : -1);
            return true;
        }
        return false;
    }

    public static void openEditGeneNameScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new EditGeneNameScreen());
    }

    public static ItemProjectileColor getItemProjectileColor(Item item) {
        ItemProjectileColor color;
        if (Hooks.supplementaries && (color = SupplementariesCompat.getItemProjectileColor(item)) != null) {
            return color;
        }
        return null;
    }

    public static void renderVacGunInHand(LivingEntity livingEntity, ItemStack itemStack, ItemDisplayContext itemDisplayContext, boolean leftHand, PoseStack poseStack) {
        Vector3f vec = new Vector3f(0.0f, 0.0f, 0.0f);
        poseStack.m_85850_().m_252922_().transformPosition(vec);
        Matrix4f screenToWorld = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix()).invert();
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Matrix4f rotation = new Matrix4f((Matrix3fc)RenderSystem.getInverseViewRotationMatrix());
        screenToWorld = rotation.mul((Matrix4fc)screenToWorld);
        Vec3 cameraPos = camera.m_90583_();
        screenToWorld.transformPosition(vec);
        vec.add((float)cameraPos.f_82479_, (float)cameraPos.f_82480_, (float)cameraPos.f_82481_);
        boolean mainArm = livingEntity.m_5737_() == HumanoidArm.LEFT == leftHand;
        livingEntity.m_9236_().m_7106_((ParticleOptions)new AirVortexParticleOption(livingEntity.m_19879_(), mainArm), (double)vec.x(), (double)vec.y(), (double)vec.z(), 0.0, 0.0, 0.0);
    }
}

