/*
 * Decompiled with CFR 0.152.
 */
package snownee.fruits.ritual;

import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Interaction;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import snownee.fruits.Hooks;
import snownee.fruits.food.FoodModule;
import snownee.fruits.util.CommonProxy;
import snownee.fruits.vacuum.VacModule;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiGO;
import snownee.kiwi.KiwiModule;

@KiwiModule(value="ritual")
@KiwiModule.Optional
public class RitualModule
extends AbstractModule {
    public static final KiwiGO<SoundEvent> RITUAL_FINISH = RitualModule.go(() -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation("fruitfulfun", "block.ritual.finish")));
    public static final Supplier<BlockPattern> RITUAL = Suppliers.memoize(() -> BlockPatternBuilder.m_61243_().m_61247_(new String[]{" C C ", "C~~~C", " ~ ~ ", "C~~~C", " C C "}).m_61247_(new String[]{"C~~~C", "~~~~~", "~~~~~", "~~~~~", "C~~~C"}).m_61244_('C', BlockInWorld.m_61169_(CommonProxy::isLitCandle)).m_61244_('~', BlockInWorld.m_61169_(BlockBehaviour.BlockStateBase::m_60795_)).m_61249_());
    public static final UUID DUMMY_UUID = UUID.fromString("46fee2cc-dbea-4a2f-9768-afb958387795");
    public static final String INTERACTION_NAME = "@FruitfulFun";
    public static final int LIFETIME = 100;

    public RitualModule() {
        Hooks.ritual = true;
    }

    public static void tryStartRitual(Level level, BlockPos pos) {
        if (!level.m_142425_((EntityTypeTest)EntityType.f_271243_, new AABB(pos), RitualModule::isFFInteractionEntity).isEmpty()) {
            return;
        }
        List<BlockPos> heads = RitualModule.findRitual(level, pos);
        if (heads.isEmpty()) {
            return;
        }
        for (BlockPos head : heads) {
            level.m_5594_(null, head, SoundEvents.f_11890_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        Interaction interaction = Objects.requireNonNull((Interaction)EntityType.f_271243_.m_20615_(level));
        interaction.m_146884_(Vec3.m_82512_((Vec3i)pos));
        interaction.m_6593_((Component)Component.m_237113_((String)INTERACTION_NAME));
        level.m_7967_((Entity)interaction);
    }

    public static List<BlockPos> findRitual(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos mutable;
        BlockPattern pattern = RITUAL.get();
        BlockPattern.BlockPatternMatch match = pattern.m_155964_((LevelReader)level, (BlockPos)(mutable = pos.m_122032_().m_122175_(Direction.NORTH, 2).m_122175_(Direction.EAST, 2)), Direction.UP, Direction.NORTH);
        if (match == null) {
            return List.of();
        }
        ArrayList headPosList = Lists.newArrayListWithExpectedSize((int)4);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            Direction facing;
            mutable.m_122190_((Vec3i)pos).m_122173_(Direction.UP).m_122175_(direction, 4);
            BlockState head = level.m_8055_((BlockPos)mutable);
            if (!head.m_60713_(Blocks.f_50320_) && !head.m_60713_(Blocks.f_50321_) || (facing = RitualModule.getSkullFacing(head)) == null) continue;
            headPosList.add(mutable.m_7949_());
        }
        return headPosList;
    }

    @Nullable
    public static Direction getSkullFacing(BlockState state) {
        if (state.m_60734_() instanceof WallSkullBlock) {
            return (Direction)state.m_61143_((Property)WallSkullBlock.f_58097_);
        }
        if (state.m_60734_() instanceof SkullBlock) {
            return switch ((Integer)state.m_61143_((Property)SkullBlock.f_56314_)) {
                case 0 -> Direction.NORTH;
                case 4 -> Direction.EAST;
                case 8 -> Direction.SOUTH;
                case 12 -> Direction.WEST;
                default -> null;
            };
        }
        return null;
    }

    public static boolean tickDragonHead(Level level, BlockPos blockPos, BlockState blockState, SkullBlockEntity skullBlockEntity) {
        Direction facing = RitualModule.getSkullFacing(blockState);
        if (facing == null) {
            return false;
        }
        BlockPos.MutableBlockPos center = blockPos.m_122032_().m_122175_(facing, 4).m_122173_(Direction.DOWN);
        List entities = level.m_142425_((EntityTypeTest)EntityType.f_271243_, new AABB((BlockPos)center), RitualModule::isFFInteractionEntity);
        if (entities.isEmpty()) {
            return false;
        }
        Interaction interaction = (Interaction)entities.get(0);
        skullBlockEntity.f_260642_ = false;
        int n = skullBlockEntity.f_260504_ = interaction.f_19797_ >= 99 ? 0 : 2;
        if (!level.f_46443_) {
            return true;
        }
        if (interaction.f_19797_ % 2 != 0) {
            return true;
        }
        double x = (double)blockPos.m_123341_() + 0.5;
        double y = (double)blockPos.m_123342_() + (blockState.m_60713_(Blocks.f_50321_) ? 0.6 : 0.3);
        double z = (double)blockPos.m_123343_() + 0.5;
        Vec3 motion = interaction.m_20182_().m_82492_(x, y, z).m_82541_();
        motion = motion.m_82524_(-0.1f);
        double power = Mth.m_14008_((double)((double)(interaction.f_19797_ + 20) / 100.0), (double)0.25, (double)1.0);
        for (int i = 0; i < 3; ++i) {
            double dx = (motion.f_82479_ * 0.08 + level.f_46441_.m_188583_() * 0.005) * power;
            double dy = (motion.f_82480_ * 0.08 + level.f_46441_.m_188583_() * 0.005) * power;
            double dz = (motion.f_82481_ * 0.08 + level.f_46441_.m_188583_() * 0.005) * power;
            for (int k = 2; k < 6; ++k) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123799_, x, y, z, dx * (double)k, dy * (double)k, dz * (double)k);
            }
            motion = motion.m_82524_(0.1f);
        }
        return true;
    }

    public static boolean isFFInteractionEntity(Interaction interaction) {
        return interaction.m_7770_() != null && interaction.m_7770_().getString().equals(INTERACTION_NAME);
    }

    public static void tickInteraction(Interaction interaction) {
        List itemEntities;
        Level level = interaction.m_9236_();
        if (level.f_46443_) {
            if (interaction.f_19797_ == 55) {
                level.m_245747_(interaction.m_20183_(), (SoundEvent)RITUAL_FINISH.get(), SoundSource.AMBIENT, 1.0f, 1.0f, false);
            }
            if (interaction.f_19797_ == 99) {
                RitualModule.finishRitual(interaction);
            }
            return;
        }
        if (interaction.f_19797_ > 100) {
            interaction.m_146870_();
            return;
        }
        if (!FoodModule.CHORUS_FRUIT_PIE.is(level.m_8055_(interaction.m_20183_()))) {
            interaction.m_146870_();
            return;
        }
        if (interaction.f_19797_ == 100) {
            RitualModule.finishRitual(interaction);
            return;
        }
        if (!interaction.m_20160_() && !(itemEntities = level.m_6443_(ItemEntity.class, interaction.m_20191_(), itemEntity -> itemEntity.m_6084_() && !itemEntity.m_20068_())).isEmpty()) {
            ItemEntity itemEntity2 = (ItemEntity)itemEntities.get(0);
            itemEntity2.m_20329_((Entity)interaction);
            itemEntity2.m_32010_(100);
        }
    }

    public static void finishRitual(Interaction interaction) {
        ServerLevel serverLevel;
        Advancement advancement;
        Entity aabb;
        BlockPos pos;
        Level level = interaction.m_9236_();
        List<BlockPos> heads = RitualModule.findRitual(level, pos = interaction.m_20183_());
        if (heads.isEmpty()) {
            return;
        }
        for (BlockPos head : heads) {
            BlockEntity blockEntity = level.m_7702_(head);
            if (!(blockEntity instanceof SkullBlockEntity)) continue;
            SkullBlockEntity skullBlockEntity = (SkullBlockEntity)blockEntity;
            skullBlockEntity.f_260504_ = 0;
        }
        if (level.f_46443_) {
            BlockState state = level.m_8055_(pos);
            VoxelShape shape = state.m_60812_((BlockGetter)level, pos);
            level.m_7471_(pos, false);
            if (shape.m_83281_()) {
                return;
            }
            aabb = shape.m_83215_();
            for (int i = 0; i < 24; ++i) {
                double x = Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)aabb.f_82288_, (double)aabb.f_82291_) + (double)pos.m_123341_();
                double y = Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)aabb.f_82289_, (double)aabb.f_82292_) + (double)pos.m_123342_();
                double z = Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)aabb.f_82290_, (double)aabb.f_82293_) + (double)pos.m_123343_();
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, x, y, z, 0.0, 0.0, 0.0);
            }
            return;
        }
        level.m_7471_(pos, false);
        ItemStack itemStack = ItemStack.f_41583_;
        aabb = interaction.m_146895_();
        if (aabb instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)aabb;
            itemStack = itemEntity.m_32055_();
        }
        interaction.m_146870_();
        int breathCount = Hooks.vac && VacModule.VAC_GUN_CASING.is(itemStack) ? 1 : heads.size() + 1;
        AreaEffectCloud flame = new AreaEffectCloud(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        flame.m_19712_(0.5f * (float)breathCount);
        flame.m_19734_(200);
        flame.m_19724_((ParticleOptions)ParticleTypes.f_123799_);
        flame.m_19716_(new MobEffectInstance(MobEffects.f_19602_, 1, 1));
        flame.f_19695_ = DUMMY_UUID;
        level.m_7967_((Entity)flame);
        level.m_5594_(null, pos, SoundEvents.f_11894_, SoundSource.AMBIENT, 1.0f, 1.0f);
        if (breathCount == 1) {
            interaction.m_19983_(VacModule.VAC_GUN.itemStack());
            itemStack.m_41774_(1);
        }
        if ((advancement = Hooks.advancement(serverLevel = (ServerLevel)level, "ritual")) != null) {
            for (ServerPlayer player : serverLevel.m_6907_()) {
                if (player.m_20280_((Entity)interaction) > 256.0) continue;
                player.m_8960_().m_135988_(advancement, "_");
            }
        }
    }

    public static void rightClickInteraction(Interaction interaction, Player player, InteractionHand interactionHand) {
        Level level = interaction.m_9236_();
        if (level.f_46443_) {
            return;
        }
        ItemStack itemStack = player.m_21120_(interactionHand);
        if (itemStack.m_41619_()) {
            return;
        }
        itemStack = itemStack.m_41620_(1);
        ItemEntity itemEntity = new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), itemStack.m_41620_(1));
        if (level.m_7967_((Entity)itemEntity)) {
            itemEntity.m_20329_((Entity)interaction);
            itemEntity.m_32010_(100);
        }
    }
}

